/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import ch.qos.logback.classic.Level;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BatchInvocationsPerJobByBatchTypeConfigTest {
    protected static final String PROCESS_ENGINE_CONFIG = "camunda.cfg.invocationsPerJobByBatchType.xml";
    protected static final String CONFIG_LOGGER = "org.camunda.bpm.engine.cfg";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.cfg"}).level(Level.WARN);
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl engineConfiguration;

    @Before
    public void setup() {
        this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)PROCESS_ENGINE_CONFIG).buildProcessEngine();
        this.engineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
    }

    @After
    public void teardown() {
        this.processEngine.close();
    }

    @Test
    public void shouldSetInvocationsPerJobByBatchType() {
        Map invocationsPerBatchJobByBatchType = this.engineConfiguration.getInvocationsPerBatchJobByBatchType();
        Assertions.assertThat((Map)invocationsPerBatchJobByBatchType).containsExactly(new Map.Entry[]{Assertions.entry((Object)"instance-migration", (Object)7), Assertions.entry((Object)"instance-modification", (Object)3), Assertions.entry((Object)"custom-batch-operation", (Object)42)});
    }

    @Test
    public void shouldWriteLogWhenBatchTypeIsUnknown() {
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("ENGINE-12014 The configuration property 'invocationsPerJobByBatchType' contains an invalid batch type 'custom-batch-operation' which is neither a custom nor a built-in batch type")).hasSize(1);
    }
}

