/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.PeriodUnit;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class HistoricProcessInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected String deploymentId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        HistoricProcessInstance instance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        HistoricProcessInstance instance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processInstanceId, (Object)instance.getId());
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testDeleteHistoricProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricProcessInstance(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the historic process instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testDeleteHistoricProcessInstanceWithDeleteHistoryPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.disableAuthorization();
        long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).count();
        Assert.assertEquals((long)0L, (long)count);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteHistoricProcessInstanceWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.disableAuthorization();
        long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).count();
        Assert.assertEquals((long)0L, (long)count);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteHistoricProcessInstanceAfterDeletingDeployment() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.disableAuthorization();
        long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).count();
        Assert.assertEquals((long)0L, (long)count);
        this.enableAuthorization();
    }

    @Test
    public void testHistoricProcessInstanceReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
            Assert.fail((String)"Exception expected: It should not be possible to create a historic process instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            Assert.assertEquals((long)1L, (long)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            Assert.assertEquals((Object)Permissions.READ_HISTORY.toString(), (Object)missingAuthorization.getViolatedPermissionName());
            Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)missingAuthorization.getResourceType());
            Assert.assertEquals((Object)"*", (Object)missingAuthorization.getResourceId());
        }
    }

    @Test
    public void testHistoricProcessInstanceReportWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testReportWithoutQueryCriteriaAndAnyReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testReportWithoutQueryCriteriaAndNoReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        try {
            this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
            Assert.fail((String)"Exception expected: It should not be possible to create a historic process instance report");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testReportWithQueryCriterionProcessDefinitionKeyInAndReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_KEY, MESSAGE_START_PROCESS_KEY}).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testReportWithQueryCriterionProcessDefinitionKeyInAndMissingReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        try {
            this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_KEY, MESSAGE_START_PROCESS_KEY}).duration(PeriodUnit.MONTH);
            Assert.fail((String)"Exception expected: It should not be possible to create a historic process instance report");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testReportWithQueryCriterionProcessDefinitionIdInAndReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processInstance1.getProcessDefinitionId(), processInstance2.getProcessDefinitionId()}).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testReportWithQueryCriterionProcessDefinitionIdInAndMissingReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        try {
            this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processInstance1.getProcessDefinitionId(), processInstance2.getProcessDefinitionId()}).duration(PeriodUnit.MONTH);
            Assert.fail((String)"Exception expected: It should not be possible to create a historic process instance report");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testReportWithMixedQueryCriteriaAndReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_KEY}).processDefinitionIdIn(new String[]{processInstance2.getProcessDefinitionId()}).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testReportWithMixedQueryCriteriaAndMissingReadHistoryPermission() {
        ProcessInstance processInstance1 = this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstance processInstance2 = this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstance1.getProcessInstanceId(), "");
        this.runtimeService.deleteProcessInstance(processInstance2.getProcessInstanceId(), "");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        try {
            this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{PROCESS_KEY}).processDefinitionIdIn(new String[]{processInstance2.getProcessDefinitionId()}).duration(PeriodUnit.MONTH);
            Assert.fail((String)"Exception expected: It should not be possible to create a historic process instance report");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testReportWithQueryCriterionProcessInstanceIdInWrongProcessDefinitionId() {
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{"aWrongProcessDefinitionId"}).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testHistoryCleanupReportWithPermissions() {
        this.prepareProcessInstances(PROCESS_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((long)10L, (long)((CleanableHistoricProcessInstanceReportResult)reportResults.get(0)).getCleanableProcessInstanceCount());
        Assert.assertEquals((long)10L, (long)((CleanableHistoricProcessInstanceReportResult)reportResults.get(0)).getFinishedProcessInstanceCount());
    }

    @Test
    public void testHistoryCleanupReportWithReadPermissionOnly() {
        this.prepareProcessInstances(PROCESS_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testHistoryCleanupReportWithReadHistoryPermissionOnly() {
        this.prepareProcessInstances(PROCESS_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testHistoryCleanupReportWithoutPermissions() {
        this.prepareProcessInstances(PROCESS_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricProcessInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testCheckAllHistoricProcessInstancePermissions() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, "*", this.userId, new Permission[]{HistoricProcessInstancePermissions.ALL});
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.NONE, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isTrue();
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.READ, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isTrue();
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.ALL, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isTrue();
    }

    @Test
    public void testCheckReadHistoricProcessInstancePermissions() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, "*", this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.NONE, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isTrue();
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.READ, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isTrue();
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.ALL, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isFalse();
    }

    @Test
    public void testCheckNoneHistoricProcessInstancePermission() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, "*", this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.NONE, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isTrue();
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.READ, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isFalse();
        Assertions.assertThat((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricProcessInstancePermissions.ALL, (Resource)Resources.HISTORIC_PROCESS_INSTANCE)).isFalse();
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testHistoricProcessInstancePermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getProcessInstanceId();
        this.disableAuthorization();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testDeleteHistoricAuthorizationRelatedToHistoricProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        AuthorizationQuery authorizationQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE).resourceId(processInstanceId);
        Assertions.assertThat((List)authorizationQuery.list()).extracting("resourceId").containsExactly(new Object[]{processInstanceId});
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        authorizationQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE).resourceId(processInstanceId);
        Assertions.assertThat((List)authorizationQuery.list()).isEmpty();
    }

    protected void verifyQueryResults(HistoricProcessInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void prepareProcessInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        ProcessDefinition processDefinition = this.selectProcessDefinitionByKey(key);
        this.disableAuthorization();
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), historyTimeToLive);
        this.enableAuthorization();
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)daysInThePast));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < instanceCount; ++i) {
            ProcessInstance processInstance = this.startProcessInstanceByKey(key);
            processInstanceIds.add(processInstance.getId());
        }
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        this.enableAuthorization();
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

