/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CustomExpressionManagerFunctionsTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    public void shouldResolveCustomFunction() {
        this.processEngineConfiguration.getExpressionManager().addFunction("foobar", ReflectUtil.getMethod(TestFunctions.class, (String)"foobar", (Class[])new Class[0]));
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaExpression("${execution.setVariable(\"baz\", foobar())}")).userTask().endEvent().done());
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "baz")).isEqualTo((Object)"foobar");
    }

    @Test
    public void shouldResolveCustomPrefixedFunction() {
        this.processEngineConfiguration.getExpressionManager().addFunction("foo:bar", ReflectUtil.getMethod(TestFunctions.class, (String)"foobar", (Class[])new Class[0]));
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaExpression("${execution.setVariable(\"baz\", foo:bar())}")).userTask().endEvent().done());
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "baz")).isEqualTo((Object)"foobar");
    }

    public static class TestFunctions {
        public static String foobar() {
            return "foobar";
        }
    }
}

