/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.cfg.MyCacheFactory;
import org.camunda.bpm.engine.test.api.cfg.MyCacheImplementation;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CallActivityModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.commons.utils.cache.Cache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeploymentCacheCfgTest {
    @ClassRule
    public static ProcessEngineBootstrapRule cacheFactoryBootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setCacheCapacity(2);
        configuration.setCacheFactory((CacheFactory)new MyCacheFactory());
        configuration.setEnableFetchProcessDefinitionDescription(false);
    });
    protected ProvidedProcessEngineRule cacheFactoryEngineRule = new ProvidedProcessEngineRule(cacheFactoryBootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.cacheFactoryEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.cacheFactoryEngineRule).around((TestRule)this.testRule);
    RepositoryService repositoryService;
    ProcessEngineConfigurationImpl processEngineConfiguration;
    RuntimeService runtimeService;
    TaskService taskService;
    ManagementService managementService;

    @Before
    public void initialize() {
        this.repositoryService = this.cacheFactoryEngineRule.getRepositoryService();
        this.processEngineConfiguration = this.cacheFactoryEngineRule.getProcessEngineConfiguration();
        this.runtimeService = this.cacheFactoryEngineRule.getRuntimeService();
        this.taskService = this.cacheFactoryEngineRule.getTaskService();
        this.managementService = this.cacheFactoryEngineRule.getManagementService();
    }

    @Test
    public void testPlugInOwnCacheImplementation() {
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        Cache cache = deploymentCache.getProcessDefinitionCache();
        Assertions.assertThat((Object)cache).isInstanceOf(MyCacheImplementation.class);
    }

    @Test
    public void testDefaultCacheRemovesElementWhenMaxSizeIsExceeded() {
        List<BpmnModelInstance> modelInstances = this.createProcesses(3);
        this.deploy(modelInstances);
        String processDefinitionIdZero = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process0").singleResult()).getId();
        String processDefinitionIdOne = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process1").singleResult()).getId();
        String processDefinitionIdTwo = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process2").singleResult()).getId();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        int numberOfProcessesInCache = 0;
        numberOfProcessesInCache += deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionIdZero) == null ? 0 : 1;
        numberOfProcessesInCache += deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionIdOne) == null ? 0 : 1;
        Assert.assertEquals((long)2L, (long)(numberOfProcessesInCache += deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionIdTwo) == null ? 0 : 1));
    }

    @Test
    public void testDisableQueryOfProcessDefinitionAddModelInstancesToDeploymentCache() {
        this.deploy(ProcessModels.ONE_TASK_PROCESS_WITH_DOCUMENTATION);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("Process");
        ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process").singleResult()).getId();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        BpmnModelInstance modelInstance = (BpmnModelInstance)deploymentCache.getBpmnModelInstanceCache().get((Object)pi.getProcessDefinitionId());
        Assert.assertNull((Object)modelInstance);
    }

    @Test
    public void testEnableQueryOfProcessDefinitionAddModelInstancesToDeploymentCache() {
        this.deploy(ProcessModels.ONE_TASK_PROCESS_WITH_DOCUMENTATION);
        this.processEngineConfiguration.setEnableFetchProcessDefinitionDescription(true);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("Process");
        ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process").singleResult()).getId();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        BpmnModelInstance modelInstance = (BpmnModelInstance)deploymentCache.getBpmnModelInstanceCache().get((Object)pi.getProcessDefinitionId());
        Assert.assertNotNull((Object)modelInstance);
    }

    @Test
    public void testDescriptionIsNullWhenFetchProcessDefinitionDescriptionIsDisabled() {
        this.deploy(ProcessModels.ONE_TASK_PROCESS_WITH_DOCUMENTATION);
        this.runtimeService.startProcessInstanceByKey("Process");
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process").singleResult();
        Assert.assertNull((Object)processDefinition.getDescription());
    }

    @Test
    public void testDescriptionIsAvailableWhenFetchProcessDefinitionDescriptionIsEnabled() {
        this.deploy(ProcessModels.ONE_TASK_PROCESS_WITH_DOCUMENTATION);
        this.processEngineConfiguration.setEnableFetchProcessDefinitionDescription(true);
        this.runtimeService.startProcessInstanceByKey("Process");
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process").singleResult();
        Assert.assertNotNull((Object)processDefinition.getDescription());
        Assert.assertEquals((Object)"This is a documentation!", (Object)processDefinition.getDescription());
    }

    @Test
    public void testLoadProcessDefinitionsFromDBWhenNotExistingInCacheAnymore() {
        int numberOfProcessesToDeploy = 10;
        List<BpmnModelInstance> modelInstances = this.createProcesses(numberOfProcessesToDeploy);
        this.deploy(modelInstances);
        Assert.assertNotNull((Object)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process0").singleResult());
        this.runtimeService.startProcessInstanceByKey("Process0");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    @Test
    public void testSequentialCallActivityCall() {
        List<BpmnModelInstance> modelInstances = this.createSequentialCallActivityProcess();
        this.deploy(modelInstances);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("NextProcess", "Process1");
        this.runtimeService.startProcessInstanceByKey("Process0", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    @Test
    public void testSequentialCallActivityCallAsynchronously() throws InterruptedException {
        List<BpmnModelInstance> modelInstances = this.createSequentialCallActivityProcessAsync();
        this.deploy(modelInstances);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("NextProcess", "Process1");
        this.runtimeService.startProcessInstanceByKey("Process0", variables);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    @Test
    public void testSequentialCallActivityAsynchronousWithUnfinishedExecution() throws InterruptedException {
        List<BpmnModelInstance> modelInstances = this.createSequentialCallActivityProcessAsync();
        Deployment deployment = this.deploy(modelInstances);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("NextProcess", "Process1");
        this.runtimeService.startProcessInstanceByKey("Process0", variables);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void shouldNotAddIdentityLinksAfterRecache() {
        this.testRule.deploy(this.createModel("1"));
        this.testRule.deploy(this.createModel("2"));
        this.testRule.deploy(this.createModel("3"));
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process1");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process2");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("Process3");
        Assertions.assertThat((int)this.repositoryService.getIdentityLinksForProcessDefinition(processInstance1.getProcessDefinitionId()).size()).isEqualTo(1);
        Assertions.assertThat((int)this.repositoryService.getIdentityLinksForProcessDefinition(processInstance2.getProcessDefinitionId()).size()).isEqualTo(1);
        Assertions.assertThat((int)this.repositoryService.getIdentityLinksForProcessDefinition(processInstance3.getProcessDefinitionId()).size()).isEqualTo(1);
    }

    protected List<BpmnModelInstance> createSequentialCallActivityProcess() {
        LinkedList<BpmnModelInstance> modelInstances = new LinkedList<BpmnModelInstance>();
        modelInstances.add(CallActivityModels.oneBpmnCallActivityProcessAsExpression(0));
        modelInstances.add(CallActivityModels.oneBpmnCallActivityProcessPassingVariables(1, 2));
        modelInstances.add(CallActivityModels.oneBpmnCallActivityProcessPassingVariables(2, 0));
        modelInstances.add(ProcessModels.oneTaskProcess(3));
        return modelInstances;
    }

    protected List<BpmnModelInstance> createSequentialCallActivityProcessAsync() {
        LinkedList<BpmnModelInstance> modelInstances = new LinkedList<BpmnModelInstance>();
        modelInstances.add(CallActivityModels.oneBpmnCallActivityProcessAsExpressionAsync(0));
        modelInstances.add(CallActivityModels.oneBpmnCallActivityProcessPassingVariables(1, 2));
        modelInstances.add(CallActivityModels.oneBpmnCallActivityProcessPassingVariables(2, 0));
        modelInstances.add(ProcessModels.oneTaskProcess(3));
        return modelInstances;
    }

    protected Deployment deploy(List<BpmnModelInstance> modelInstances) {
        DeploymentBuilder deploymentbuilder = this.processEngineConfiguration.getRepositoryService().createDeployment();
        for (int i = 0; i < modelInstances.size(); ++i) {
            deploymentbuilder.addModelInstance("process" + i + ".bpmn", modelInstances.get(i));
        }
        return this.testRule.deploy(deploymentbuilder);
    }

    protected Deployment deploy(BpmnModelInstance modelInstance) {
        DeploymentBuilder deploymentbuilder = this.processEngineConfiguration.getRepositoryService().createDeployment();
        deploymentbuilder.addModelInstance("process0.bpmn", modelInstance);
        return this.testRule.deploy(deploymentbuilder);
    }

    protected List<BpmnModelInstance> createProcesses(int numberOfProcesses) {
        ArrayList<BpmnModelInstance> result = new ArrayList<BpmnModelInstance>(numberOfProcesses);
        for (int i = 0; i < numberOfProcesses; ++i) {
            result.add(ProcessModels.oneTaskProcess(i));
        }
        return result;
    }

    protected BpmnModelInstance createModel(String suffix) {
        BpmnModelInstance bpmnModel = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)("Process" + suffix)).startEvent("startEvent").userTask().name("User Task")).endEvent("endEvent").done();
        Process model = (Process)bpmnModel.getModelElementById("Process" + suffix);
        model.setCamundaCandidateStarterUsers("demo" + suffix);
        return bpmnModel;
    }
}

