/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ActivateJobDefinitionTest
extends PluggableProcessEngineTest {
    @After
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-job-definition");
                return null;
            }
        });
    }

    @Test
    public void testActivationById_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionById(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testActivationByIdAndActivateJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionById(null, false);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, true);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testActivationByIdAndActivateJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionById(null, false, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, true, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, false, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, true, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationById_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByIdAndActivateJobsFlag_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByIdAndActivateJobsFlag_shouldSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationById_shouldExecuteImmediatelyAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationById_shouldExecuteImmediatelyAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationById_shouldExecuteDelayedAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        String deploymentId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)deploymentId);
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationById_shouldExecuteDelayedAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        String deploymentId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)deploymentId);
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Test
    public void testActivationByProcessDefinitionId_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testActivationByProcessDefinitionIdAndActivateJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, false);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, true);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testActivationByProcessDefinitionIdAndActivateJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, false, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, true, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, false, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, true, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionId_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionIdAndActivateJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionIdAndActivateJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionId_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionId_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionId_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)processDefinition.getDeploymentId());
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionId_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)processDefinition.getDeploymentId());
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Test
    public void testActivationByProcessDefinitionKey_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testActivationByProcessDefinitionKeyAndActivateJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, false);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, true);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testActivationByProcessDefinitionKeyAndActivateJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, false, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, true, null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, false, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, true, new Date());
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKey_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKeyAndActivateJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKeyAndActivateJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertFalse((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertFalse((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)processDefinition.getDeploymentId());
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)processDefinition.getDeploymentId());
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJobDefinition.getId());
        Assert.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)activeJob.getJobDefinitionId());
        Assert.assertFalse((boolean)activeJob.isSuspended());
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKeyAndActivateJobsFlag_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKeyAndActivateJobsFlag_shouldSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, false, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        String expectedDeploymentId = ((ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc()).list().get(0)).getDeploymentId();
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, true, this.oneWeekLater());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        String expectedDeploymentId = ((ProcessDefinition)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc()).list().get(0)).getDeploymentId();
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)3L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).activate();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).activate();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        this.managementService.updateJobDefinitionSuspensionState().byProcessDefinitionKey("suspensionProcess").activate();
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testActivationJobDefinitionIncludingJobsUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).includeJobs(true).activate();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        Assert.assertEquals((long)0L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testDelayedActivationUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        JobDefinition jobDefinition = (JobDefinition)query.singleResult();
        this.managementService.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinition.getId()).executionDate(this.oneWeekLater()).activate();
        Assert.assertEquals((long)0L, (long)query.active().count());
        Assert.assertEquals((long)1L, (long)query.suspended().count());
        Job delayedActivationJob = (Job)this.managementService.createJobQuery().timers().active().singleResult();
        Assert.assertNotNull((Object)delayedActivationJob);
        String expectedDeploymentId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
        Assertions.assertThat((String)delayedActivationJob.getDeploymentId()).isEqualTo((Object)expectedDeploymentId);
        this.managementService.executeJob(delayedActivationJob.getId());
        Assert.assertEquals((long)1L, (long)query.active().count());
        Assert.assertEquals((long)0L, (long)query.suspended().count());
    }

    protected Date oneWeekLater() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        return new Date(oneWeekFromStartTime);
    }
}

