/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ManagementServiceAsyncOperationsTest
extends AbstractAsyncOperationsTest {
    protected static final int RETRIES = 5;
    protected static final String TEST_PROCESS = "exceptionInJobExecution";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected final Date TEST_DUE_DATE = new Date(1675752840000L);
    protected List<String> processInstanceIds;
    protected List<String> ids;
    boolean tearDownEnsureJobDueDateNotNull;

    @Before
    public void setup() {
        this.initDefaults(this.engineRule);
        this.prepareData();
    }

    protected void prepareData() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml");
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.addAll(this.startTestProcesses(2));
        this.ids = this.getAllJobIds();
    }

    @After
    public void tearDown() {
        this.processInstanceIds = null;
        if (this.tearDownEnsureJobDueDateNotNull) {
            this.engineConfiguration.setEnsureJobDueDateNotNull(false);
        }
    }

    @Test
    public void testSetJobsRetryAsyncWithJobList() throws Exception {
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).isEmpty();
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void shouldSetInvocationsPerBatchTypeForJobsByJobIds() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("set-job-retries", 42);
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, 5);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessList() throws Exception {
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).isEmpty();
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessListInDifferentDeployments() throws Exception {
        this.prepareData();
        ProcessDefinitionQuery definitionQuery = this.engineRule.getRepositoryService().createProcessDefinitionQuery();
        String firstDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(1)).singleResult()).getDeploymentId();
        String secondDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(2)).singleResult()).getDeploymentId();
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.executeSeedJobs(batch, 2);
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
        Assertions.assertThat((List)batchJobs).hasSize(2);
        Assert.assertThat((Object)((Job)batchJobs.get(0)).getDeploymentId(), (Matcher)IsIn.isOneOf((Object[])new String[]{firstDeploymentId, secondDeploymentId}));
        Assert.assertThat((Object)((Job)batchJobs.get(1)).getDeploymentId(), (Matcher)IsIn.isOneOf((Object[])new String[]{firstDeploymentId, secondDeploymentId}));
        Assertions.assertThat((String)((Job)batchJobs.get(0)).getDeploymentId()).isNotEqualTo((Object)((Job)batchJobs.get(1)).getDeploymentId());
        Assertions.assertThat((long)this.getJobCountWithUnchangedRetries()).isEqualTo(4L);
        this.getJobIdsByDeployment(batchJobs, firstDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        Assertions.assertThat((long)this.getJobCountWithUnchangedRetries()).isEqualTo(2L);
        this.getJobIdsByDeployment(batchJobs, secondDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyJobList() throws Exception {
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(new ArrayList(), 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyProcessList() throws Exception {
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(new ArrayList(), (ProcessInstanceQuery)null, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingJobID() throws Exception {
        this.ids.add("aFake");
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(1);
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingProcessID() throws Exception {
        this.processInstanceIds.add("aFake");
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithJobQueryAndList() throws Exception {
        List<String> extraPi = this.startTestProcesses(1);
        JobQuery query = this.managementService.createJobQuery().processInstanceId(extraPi.get(0));
        Batch batch = this.managementService.setJobRetriesAsync(this.ids, query, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessQueryAndList() throws Exception {
        List<String> extraPi = this.startTestProcesses(1);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId(extraPi.get(0));
        Batch batch = this.managementService.setJobRetriesAsync(this.processInstanceIds, query, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.getAllJobIds(), 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithJobQuery() throws Exception {
        JobQuery query = this.managementService.createJobQuery();
        Batch batch = this.managementService.setJobRetriesAsync(query, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithProcessQuery() throws Exception {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesAsync(null, query, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testSetJobsRetryAsyncWithHistoryProcessQuery() {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesAsync(null, null, historicProcessInstanceQuery, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testSetJobsRetryAsyncWithRuntimeAndHistoryProcessQuery() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceIds.get(0));
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceIds.get(1));
        Batch batch = this.managementService.setJobRetriesAsync(null, query, historicProcessInstanceQuery, 5);
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        this.assertRetries(this.ids, 5);
        this.assertHistoricBatchExists(this.testRule);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyJobQuery() throws Exception {
        JobQuery query = this.managementService.createJobQuery().suspended();
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(query, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithEmptyProcessQuery() throws Exception {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().suspended();
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(null, query, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingIDAsJobQuery() throws Exception {
        JobQuery query = this.managementService.createJobQuery().jobId("aFake");
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(query, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNonExistingIDAsProcessQuery() throws Exception {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId("aFake");
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(null, query, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNullJobList() throws Exception {
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync((List)null, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNullJobQuery() throws Exception {
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync((JobQuery)null, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNullProcessQuery() throws Exception {
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(null, (ProcessInstanceQuery)null, 5)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testSetJobsRetryAsyncWithNegativeRetries() throws Exception {
        JobQuery query = this.managementService.createJobQuery();
        Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesAsync(query, -1)).isInstanceOf(ProcessEngineException.class);
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSetJobDueDateOnJobRetryAsyncByJobQuery() {
        JobQuery query = this.managementService.createJobQuery();
        Batch batch = this.managementService.setJobRetriesByJobsAsync(5).jobQuery(query).dueDate(this.TEST_DUE_DATE).executeAsync();
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        for (String id : this.ids) {
            Job job = (Job)this.managementService.createJobQuery().jobId(id).singleResult();
            Assertions.assertThat((int)job.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)job.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSetJobDueDateOnJobRetryAsyncByProcessInstanceIds() {
        Batch batch = this.managementService.setJobRetriesByProcessAsync(5).processInstanceIds(this.processInstanceIds).dueDate(this.TEST_DUE_DATE).executeAsync();
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        for (String id : this.processInstanceIds) {
            Job job = (Job)this.managementService.createJobQuery().processInstanceId(id).singleResult();
            Assertions.assertThat((int)job.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)job.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
        }
    }

    @Test
    public void shouldSetJobDueDateOnJobRetryAsyncByProcessInstanceQuery() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesByProcessAsync(5).processInstanceQuery(query).dueDate(this.TEST_DUE_DATE).executeAsync();
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        for (String id : this.ids) {
            Job jobResult = (Job)this.managementService.createJobQuery().jobId(id).singleResult();
            Assertions.assertThat((int)jobResult.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)jobResult.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSetJobDueDateOnJobRetryAsyncByHistoricProcessInstanceQuery() {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesByProcessAsync(5).historicProcessInstanceQuery(historicProcessInstanceQuery).dueDate(this.TEST_DUE_DATE).executeAsync();
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        for (String id : this.ids) {
            Job jobResult = (Job)this.managementService.createJobQuery().jobId(id).singleResult();
            Assertions.assertThat((int)jobResult.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)jobResult.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
        }
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSetDueDateNull() {
        this.engineConfiguration.setEnsureJobDueDateNotNull(false);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        List job = this.managementService.createJobQuery().list();
        Assertions.assertThat((Date)((Job)job.get(0)).getDuedate()).isNotNull();
        Assertions.assertThat((Date)((Job)job.get(1)).getDuedate()).isNotNull();
        Batch batch = this.managementService.setJobRetriesByProcessAsync(5).historicProcessInstanceQuery(historicProcessInstanceQuery).dueDate(null).executeAsync();
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        for (String id : this.ids) {
            Job jobResult = (Job)this.managementService.createJobQuery().jobId(id).singleResult();
            Assertions.assertThat((int)jobResult.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)jobResult.getDuedate()).isNull();
        }
    }

    @Test
    public void shouldSetJobDueDateOnJobRetryAsyncByJobIds() {
        Batch batch = this.managementService.setJobRetriesByJobsAsync(5).jobIds(this.ids).dueDate(this.TEST_DUE_DATE).executeAsync();
        this.completeSeedJobs(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assertions.assertThat(exceptions).hasSize(0);
        for (String id : this.ids) {
            Job jobResult = (Job)this.managementService.createJobQuery().jobId(id).singleResult();
            Assertions.assertThat((int)jobResult.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)jobResult.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
        }
    }

    @Test
    public void shouldThrowErrorOnEmptySetRetryByJobsBuilderConfig() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesByJobsAsync(5).executeAsync()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("050").hasMessageContaining("You must specify at least one of jobIds or jobQuery.");
    }

    @Test
    public void shouldThrowErrorOnEmptySetRetryByProcessBuilderConfig() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesByProcessAsync(5).executeAsync()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("051").hasMessageContaining("You must specify at least one of or one of processInstanceIds, processInstanceQuery, or historicProcessInstanceQuery.");
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void shouldSetInvocationsPerBatchTypeForJobsByProcessInstanceIds() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("set-job-retries", 42);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.managementService.setJobRetriesAsync(null, null, historicProcessInstanceQuery, 5);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected List<String> getAllJobIds() {
        return this.getAllJobs().stream().map(Job::getId).collect(Collectors.toList());
    }

    protected List<Job> getAllJobs() {
        return this.managementService.createJobQuery().list().stream().filter(j -> j.getProcessInstanceId() != null).collect(Collectors.toList());
    }

    @Override
    protected List<String> startTestProcesses(int numberOfProcesses) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < numberOfProcesses; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(TEST_PROCESS).getProcessInstanceId());
        }
        return ids;
    }

    protected void assertRetries(List<String> allJobIds, int i) {
        for (String id : allJobIds) {
            Assertions.assertThat((int)((Job)this.managementService.createJobQuery().jobId(id).singleResult()).getRetries()).isEqualTo(i);
        }
    }

    protected long getJobCountWithUnchangedRetries() {
        return this.getAllJobs().stream().filter(j -> j.getRetries() != 5).count();
    }
}

