/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class SuspendJobTest
extends PluggableProcessEngineTest {
    @Test
    public void testSuspensionById_shouldThrowProcessEngineException() {
        try {
            this.managementService.suspendJobById(null);
            Assert.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionById_shouldSuspendJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobById(job.getId());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)suspendedJob.getId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByJobDefinitionId_shouldSuspendJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByJobDefinitionId(jobDefinition.getId());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)suspendedJob.getId());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessInstanceId_shouldSuspendJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByProcessInstanceId(processInstance.getId());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)suspendedJob.getId());
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)suspendedJob.getJobDefinitionId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionId_shouldSuspendJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByProcessDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)suspendedJob.getId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKey_shouldSuspendJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertFalse((boolean)job.isSuspended());
        this.managementService.suspendJobByProcessDefinitionKey(processDefinition.getKey());
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)suspendedJob.getId());
        Assert.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Test
    public void testMultipleSuspensionByProcessDefinitionKey_shouldSuspendJob() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobByProcessDefinitionKey(key);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)3L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        Assert.assertFalse((boolean)job.isSuspended());
        this.managementService.updateJobSuspensionState().byJobId(job.getId()).suspend();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByJobDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.updateJobSuspensionState().byJobDefinitionId(jobDefinition.getId()).suspend();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessInstanceIdUsingBuilder() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.updateJobSuspensionState().byProcessInstanceId(processInstance.getId()).suspend();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionIdUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.managementService.updateJobSuspensionState().byProcessDefinitionId(processDefinition.getId()).suspend();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    @Test
    public void testSuspensionByProcessDefinitionKeyUsingBuilder() {
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", (Map)Variables.createVariables().putValue("fail", (Object)true));
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.active().count());
        this.managementService.updateJobSuspensionState().byProcessDefinitionKey("suspensionProcess").suspend();
        Assert.assertEquals((long)0L, (long)jobQuery.active().count());
        Assert.assertEquals((long)1L, (long)jobQuery.suspended().count());
    }
}

