/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.api.delegate.AssertingTaskListener;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Test;

public class MultiTenancyDelegateTaskTest
extends PluggableProcessEngineTest {
    protected static final String BPMN = "org/camunda/bpm/engine/test/api/multitenancy/taskListener.bpmn";

    @Test
    public void testSingleExecutionWithUserTask() {
        this.testRule.deployForTenant("tenant1", BPMN);
        AssertingTaskListener.addAsserts(MultiTenancyDelegateTaskTest.hasTenantId("tenant1"));
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
    }

    protected static AssertingTaskListener.DelegateTaskAsserter hasTenantId(final String expectedTenantId) {
        return new AssertingTaskListener.DelegateTaskAsserter(){

            @Override
            public void doAssert(DelegateTask task) {
                Assertions.assertThat((String)task.getTenantId()).isEqualTo((Object)expectedTenantId);
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        AssertingTaskListener.clear();
    }
}

