/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceStatisticsQuery;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancySharedDecisionInstanceStatisticsQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String DISH_DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DISH_DECISION = "dish-decision";
    protected static final String TEMPERATURE = "temperature";
    protected static final String DAY_TYPE = "dayType";
    protected static final String WEEKEND = "Weekend";
    protected static final String USER_ID = "user";
    protected static StaticTenantIdTestProvider tenantIdProvider;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain tenantRuleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.decisionService = this.engineRule.getDecisionService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deploy(DISH_DRG_DMN);
        this.decisionService.evaluateDecisionByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        this.identityService.setAuthentication(USER_ID, null, null);
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication(USER_ID, null, null);
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    static {
        bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
            tenantIdProvider = new StaticTenantIdTestProvider(TENANT_ONE);
            configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
        });
    }
}

