/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCleanableHistoricDecisionInstanceReportCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    private static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String DMN_MODEL = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void testReportNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.identityService.setAuthentication("user", null, null);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testReportWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getTenantId());
    }

    @Test
    public void testReportDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)2L, (long)reportResults.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getTenantId());
        Assert.assertEquals((Object)TENANT_TWO, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(1)).getTenantId());
    }

    @Test
    public void testReportTenantIdInNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.testRule.deployForTenant(TENANT_TWO, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        List reportResultsOne = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        List reportResultsTwo = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_TWO}).list();
        Assert.assertEquals((long)0L, (long)reportResultsOne.size());
        Assert.assertEquals((long)0L, (long)reportResultsTwo.size());
    }

    @Test
    public void testReportTenantIdInWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.testRule.deployForTenant(TENANT_TWO, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResultsOne = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        List reportResultsTwo = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_TWO}).list();
        Assert.assertEquals((long)1L, (long)reportResultsOne.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResultsOne.get(0)).getTenantId());
        Assert.assertEquals((long)0L, (long)reportResultsTwo.size());
    }

    @Test
    public void testReportTenantIdInDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.testRule.deployForTenant(TENANT_TWO, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResultsOne = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        List reportResultsTwo = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_TWO}).list();
        Assert.assertEquals((long)1L, (long)reportResultsOne.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResultsOne.get(0)).getTenantId());
        Assert.assertEquals((long)1L, (long)reportResultsTwo.size());
        Assert.assertEquals((Object)TENANT_TWO, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResultsTwo.get(0)).getTenantId());
    }

    @Test
    public void testReportWithoutTenantId() {
        this.testRule.deploy(DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, null);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().withoutTenantId().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals(null, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getTenantId());
    }

    @Test
    public void testReportTenantIdInWithoutTenantId() {
        this.testRule.deploy(DMN_MODEL);
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, null);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().withoutTenantId().list();
        List reportResultsOne = this.historyService.createCleanableHistoricDecisionInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals(null, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getTenantId());
        Assert.assertEquals((long)1L, (long)reportResultsOne.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResultsOne.get(0)).getTenantId());
    }

    protected void prepareDecisionInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount, String tenantId) {
        List decisionDefinitions = null;
        decisionDefinitions = tenantId != null ? this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(key).tenantIdIn(new String[]{tenantId}).list() : this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(key).withoutTenantId().list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
        for (int i = 0; i < instanceCount; ++i) {
            if (tenantId != null) {
                this.engineRule.getDecisionService().evaluateDecisionByKey(key).decisionDefinitionTenantId(tenantId).variables((Map)variables).evaluate();
                continue;
            }
            this.engineRule.getDecisionService().evaluateDecisionByKey(key).decisionDefinitionWithoutTenantId().variables((Map)variables).evaluate();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

