/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionDefinitionQueryTest {
    protected static final String DMN_ONE_RESOURCE = "org/camunda/bpm/engine/test/repository/one.dmn";
    protected static final String DMN_TWO_RESOURCE = "org/camunda/bpm/engine/test/repository/two.dmn";
    protected static final String DMN_THREE_RESOURCE = "org/camunda/bpm/engine/test/api/repository/three_.dmn";
    protected static final String DRD_SCORE_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected String decisionRequirementsDefinitionId;
    protected String firstDeploymentId;
    protected String secondDeploymentId;
    protected String thirdDeploymentId;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.firstDeploymentId = this.testRule.deploy(DMN_ONE_RESOURCE, DMN_TWO_RESOURCE).getId();
        this.secondDeploymentId = this.testRule.deploy(DMN_ONE_RESOURCE).getId();
        this.thirdDeploymentId = this.testRule.deploy(DMN_THREE_RESOURCE).getId();
    }

    @After
    public void tearDown() {
        ClockUtil.resetClock();
    }

    @Test
    public void decisionDefinitionProperties() {
        List decisionDefinitions = ((DecisionDefinitionQuery)((DecisionDefinitionQuery)((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionName().asc()).orderByDecisionDefinitionVersion().asc()).orderByDecisionDefinitionCategory().asc()).list();
        DecisionDefinition decisionDefinition = (DecisionDefinition)decisionDefinitions.get(0);
        Assertions.assertThat((String)decisionDefinition.getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((String)decisionDefinition.getName()).isEqualTo((Object)"One");
        Assertions.assertThat((String)decisionDefinition.getId()).startsWith((CharSequence)"one:1");
        Assertions.assertThat((String)decisionDefinition.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((int)decisionDefinition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)decisionDefinition.getResourceName()).isEqualTo((Object)DMN_ONE_RESOURCE);
        Assertions.assertThat((String)decisionDefinition.getDeploymentId()).isEqualTo((Object)this.firstDeploymentId);
        decisionDefinition = (DecisionDefinition)decisionDefinitions.get(1);
        Assertions.assertThat((String)decisionDefinition.getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((String)decisionDefinition.getName()).isEqualTo((Object)"One");
        Assertions.assertThat((String)decisionDefinition.getId()).startsWith((CharSequence)"one:2");
        Assertions.assertThat((String)decisionDefinition.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((int)decisionDefinition.getVersion()).isEqualTo(2);
        Assertions.assertThat((String)decisionDefinition.getResourceName()).isEqualTo((Object)DMN_ONE_RESOURCE);
        Assertions.assertThat((String)decisionDefinition.getDeploymentId()).isEqualTo((Object)this.secondDeploymentId);
        decisionDefinition = (DecisionDefinition)decisionDefinitions.get(2);
        Assertions.assertThat((String)decisionDefinition.getKey()).isEqualTo((Object)"two");
        Assertions.assertThat((String)decisionDefinition.getName()).isEqualTo((Object)"Two");
        Assertions.assertThat((String)decisionDefinition.getId()).startsWith((CharSequence)"two:1");
        Assertions.assertThat((String)decisionDefinition.getCategory()).isEqualTo((Object)"Examples2");
        Assertions.assertThat((int)decisionDefinition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)decisionDefinition.getResourceName()).isEqualTo((Object)DMN_TWO_RESOURCE);
        Assertions.assertThat((String)decisionDefinition.getDeploymentId()).isEqualTo((Object)this.firstDeploymentId);
    }

    @Test
    public void queryByDecisionDefinitionIds() {
        Assertions.assertThat((List)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(new String[]{"a", "b"}).list()).isEmpty();
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().list();
        ArrayList<String> ids = new ArrayList<String>();
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            ids.add(decisionDefinition.getId());
        }
        decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(ids.toArray(new String[ids.size()])).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(ids.size());
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            Assertions.assertThat(ids).contains((Object[])new String[]{decisionDefinition.getId()}).withFailMessage("Expected to find decision definition " + decisionDefinition, new Object[0]);
        }
    }

    @Test
    public void queryByDeploymentId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.deploymentId(this.firstDeploymentId);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void queryByInvalidDeploymentId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.deploymentId(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByDeploymentTimeAfter() {
        Date startTest = DateUtils.addSeconds((Date)ClockUtil.now(), (int)5);
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)startTest, (int)5));
        org.camunda.bpm.engine.repository.Deployment tempDeploymentOne = this.repositoryService.createDeployment().addClasspathResource(DMN_ONE_RESOURCE).addClasspathResource(DMN_TWO_RESOURCE).deploy();
        this.engineRule.manageDeployment(tempDeploymentOne);
        Date timeAfterDeploymentOne = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)1);
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)timeAfterDeploymentOne, (int)5));
        org.camunda.bpm.engine.repository.Deployment tempDeploymentTwo = this.repositoryService.createDeployment().addClasspathResource(DMN_ONE_RESOURCE).deploy();
        this.engineRule.manageDeployment(tempDeploymentTwo);
        Date timeAfterDeploymentTwo = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)1);
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)timeAfterDeploymentTwo, (int)5));
        org.camunda.bpm.engine.repository.Deployment tempDeploymentThree = this.repositoryService.createDeployment().addClasspathResource(DMN_THREE_RESOURCE).deploy();
        this.engineRule.manageDeployment(tempDeploymentThree);
        Date timeAfterDeploymentThree = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)1);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAfter(startTest).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(4);
        decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAfter(timeAfterDeploymentOne).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(2);
        this.assertThatDecisionDefinitionsWereDeployedAfter(decisionDefinitions, timeAfterDeploymentOne);
        decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAfter(timeAfterDeploymentTwo).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(1);
        this.assertThatDecisionDefinitionsWereDeployedAfter(decisionDefinitions, timeAfterDeploymentTwo);
        decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAfter(timeAfterDeploymentThree).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(0);
    }

    @Test
    public void testQueryByDeploymentTimeAt() throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");
        Date startTest = formatter.parse(formatter.format(DateUtils.addSeconds((Date)ClockUtil.now(), (int)5)));
        ClockUtil.setCurrentTime((Date)startTest);
        Date timeAtDeploymentOne = ClockUtil.getCurrentTime();
        org.camunda.bpm.engine.repository.Deployment tempDeploymentOne = this.repositoryService.createDeployment().addClasspathResource(DMN_ONE_RESOURCE).addClasspathResource(DMN_TWO_RESOURCE).deploy();
        this.engineRule.manageDeployment(tempDeploymentOne);
        Date timeAtDeploymentTwo = DateUtils.addSeconds((Date)timeAtDeploymentOne, (int)5);
        ClockUtil.setCurrentTime((Date)timeAtDeploymentTwo);
        org.camunda.bpm.engine.repository.Deployment tempDeploymentTwo = this.repositoryService.createDeployment().addClasspathResource(DMN_ONE_RESOURCE).deploy();
        this.engineRule.manageDeployment(tempDeploymentTwo);
        Date timeAtDeploymentThree = DateUtils.addSeconds((Date)timeAtDeploymentTwo, (int)5);
        ClockUtil.setCurrentTime((Date)timeAtDeploymentThree);
        org.camunda.bpm.engine.repository.Deployment tempDeploymentThree = this.repositoryService.createDeployment().addClasspathResource(DMN_THREE_RESOURCE).deploy();
        this.engineRule.manageDeployment(tempDeploymentThree);
        List processDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAt(timeAtDeploymentOne).list();
        Assertions.assertThat((List)processDefinitions).hasSize(2);
        this.assertThatDecisionDefinitionsWereDeployedAt(processDefinitions, timeAtDeploymentOne);
        processDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAt(timeAtDeploymentTwo).list();
        Assertions.assertThat((List)processDefinitions).hasSize(1);
        this.assertThatDecisionDefinitionsWereDeployedAt(processDefinitions, timeAtDeploymentTwo);
        processDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAt(timeAtDeploymentThree).list();
        Assertions.assertThat((List)processDefinitions).hasSize(1);
        this.assertThatDecisionDefinitionsWereDeployedAt(processDefinitions, timeAtDeploymentThree);
        processDefinitions = this.repositoryService.createDecisionDefinitionQuery().deployedAt(DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)5)).list();
        Assertions.assertThat((List)processDefinitions).hasSize(0);
    }

    @Test
    public void queryByName() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionName("Two");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionName("One");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void queryByInvalidName() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionName(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionNameLike("%w%");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionNameLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionNameLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByResourceNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionResourceNameLike("%ree%");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionResourceNameLike("%ee\\_%");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidNResourceNameLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionResourceNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionNameLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey("one");
        this.verifyQueryResults(query, 2);
        query.decisionDefinitionKey("two");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionKey(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByKeyLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKeyLike("%o%");
        this.verifyQueryResults(query, 3);
        query.decisionDefinitionKeyLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidKeyLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKeyLike("%invalid%");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionKeyLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByCategory() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategory("Examples");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void queryByInvalidCategory() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategory("invalid");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionCategory(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByCategoryLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategoryLike("%Example%");
        this.verifyQueryResults(query, 3);
        query.decisionDefinitionCategoryLike("%amples2");
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionCategoryLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void queryByInvalidCategoryLike() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionCategoryLike("invalid");
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionCategoryLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByVersion() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void queryByInvalidVersion() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionVersion(Integer.valueOf(-1))).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionVersion(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByLatest() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.latestVersion();
        this.verifyQueryResults(query, 3);
        query.decisionDefinitionKey("one").latestVersion();
        this.verifyQueryResults(query, 1);
        query.decisionDefinitionKey("two").latestVersion();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testInvalidUsageOfLatest() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionId("test").latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionName("test").latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionNameLike("test").latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.decisionDefinitionVersion(Integer.valueOf(1)).latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.deploymentId("test").latestVersion().list()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void queryByDecisionRequirementsDefinitionId() {
        this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE);
        List drds = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionName().asc()).list();
        String dishDrdId = ((DecisionRequirementsDefinition)drds.get(0)).getId();
        String scoreDrdId = ((DecisionRequirementsDefinition)drds.get(1)).getId();
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults(query.decisionRequirementsDefinitionId("non existing"), 0);
        this.verifyQueryResults(query.decisionRequirementsDefinitionId(dishDrdId), 3);
        this.verifyQueryResults(query.decisionRequirementsDefinitionId(scoreDrdId), 2);
    }

    @Test
    public void queryByDecisionRequirementsDefinitionKey() {
        this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults(query.decisionRequirementsDefinitionKey("non existing"), 0);
        this.verifyQueryResults(query.decisionRequirementsDefinitionKey("dish"), 3);
        this.verifyQueryResults(query.decisionRequirementsDefinitionKey("score"), 2);
    }

    @Test
    public void queryByWithoutDecisionRequirementsDefinition() {
        this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults(query, 9);
        this.verifyQueryResults(query.withoutDecisionRequirementsDefinition(), 4);
    }

    @Test
    public void querySorting() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionId().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionKey().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionVersion().asc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionId().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionKey().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        query.orderByDecisionDefinitionVersion().desc();
        this.verifyQueryResults(query, 4);
        query = this.repositoryService.createDecisionDefinitionQuery();
        ((DecisionDefinitionQuery)query.orderByDecisionDefinitionKey().asc()).orderByDecisionDefinitionVersion().desc();
        List decisionDefinitions = query.list();
        Assertions.assertThat((int)decisionDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(0)).getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((int)((DecisionDefinition)decisionDefinitions.get(0)).getVersion()).isEqualTo(2);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(1)).getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((int)((DecisionDefinition)decisionDefinitions.get(1)).getVersion()).isEqualTo(1);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(2)).getKey()).isEqualTo((Object)"two");
        Assertions.assertThat((int)((DecisionDefinition)decisionDefinitions.get(2)).getVersion()).isEqualTo(1);
    }

    protected void verifyQueryResults(DecisionDefinitionQuery query, int expectedCount) {
        Assertions.assertThat((long)query.count()).isEqualTo((long)expectedCount);
        Assertions.assertThat((int)query.list().size()).isEqualTo(expectedCount);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/versionTag.dmn", "org/camunda/bpm/engine/test/api/repository/versionTagHigher.dmn"})
    @Test
    public void testQueryOrderByVersionTag() {
        List decisionDefinitionList = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().versionTagLike("1%").orderByVersionTag().asc()).list();
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitionList.get(1)).getVersionTag()).isEqualTo((Object)"1.1.0");
    }

    @Test
    public void testQueryOrderByDecisionRequirementsDefinitionKey() {
        List scoreDefinitions = this.testRule.deploy(DRD_SCORE_RESOURCE).getDeployedDecisionDefinitions();
        List<String> scoreDefinitionIds = this.asIds(scoreDefinitions);
        List dishDefinitions = this.testRule.deploy(DRD_DISH_RESOURCE).getDeployedDecisionDefinitions();
        List<String> dishDefinitionIds = this.asIds(dishDefinitions);
        List decisionDefinitionList = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionIdIn(this.merge(scoreDefinitionIds, dishDefinitionIds)).orderByDecisionRequirementsDefinitionKey().asc()).list();
        List firstThreeResults = decisionDefinitionList.subList(0, 3);
        List lastTwoResults = decisionDefinitionList.subList(3, 5);
        Assertions.assertThat(firstThreeResults).extracting("id").containsExactlyInAnyOrderElementsOf(dishDefinitionIds);
        Assertions.assertThat(lastTwoResults).extracting("id").containsExactlyInAnyOrderElementsOf(scoreDefinitionIds);
    }

    @Test
    public void testQueryOrderByDeployTime() {
        DecisionDefinitionQuery decisionDefinitionOrderByDeploymentTimeAscQuery = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDeploymentTime().asc();
        DecisionDefinitionQuery decisionDefinitionOrderByDeploymentTimeDescQuery = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDeploymentTime().desc();
        TestOrderingUtil.verifySortingAndCount(decisionDefinitionOrderByDeploymentTimeAscQuery, 4, TestOrderingUtil.decisionDefinitionByDeployTime(this.engineRule.getProcessEngine()));
        TestOrderingUtil.verifySortingAndCount(decisionDefinitionOrderByDeploymentTimeDescQuery, 4, TestOrderingUtil.inverted(TestOrderingUtil.decisionDefinitionByDeployTime(this.engineRule.getProcessEngine())));
    }

    protected String[] merge(List<String> list1, List<String> list2) {
        int numElements = list1.size() + list2.size();
        ArrayList<String> copy = new ArrayList<String>(numElements);
        copy.addAll(list1);
        copy.addAll(list2);
        return copy.toArray(new String[numElements]);
    }

    protected List<String> asIds(List<DecisionDefinition> decisions) {
        ArrayList<String> ids = new ArrayList<String>();
        for (DecisionDefinition decision : decisions) {
            ids.add(decision.getId());
        }
        return ids;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/versionTag.dmn", "org/camunda/bpm/engine/test/api/repository/versionTagHigher.dmn"})
    @Test
    public void testQueryByVersionTag() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().versionTag("1.0.0").singleResult();
        Assertions.assertThat((String)decisionDefinition.getKey()).isEqualTo((Object)"versionTag");
        Assertions.assertThat((String)decisionDefinition.getVersionTag()).isEqualTo((Object)"1.0.0");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/versionTag.dmn", "org/camunda/bpm/engine/test/api/repository/versionTagHigher.dmn"})
    @Test
    public void testQueryByVersionTagLike() {
        List decisionDefinitionList = this.repositoryService.createDecisionDefinitionQuery().versionTagLike("1%").list();
        Assertions.assertThat((List)decisionDefinitionList).hasSize(2);
    }

    protected void assertThatDecisionDefinitionsWereDeployedAfter(List<DecisionDefinition> decisionDefinitions, Date deployedAfter) {
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            Assertions.assertThat((Date)((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(decisionDefinition.getDeploymentId()).singleResult()).getDeploymentTime()).isAfter(deployedAfter);
        }
    }

    protected void assertThatDecisionDefinitionsWereDeployedAt(List<DecisionDefinition> decisionDefinitions, Date deployedAt) {
        for (DecisionDefinition decisionDefinition : decisionDefinitions) {
            Assertions.assertThat((Date)((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(decisionDefinition.getDeploymentId()).singleResult()).getDeploymentTime()).isEqualTo((Object)deployedAt);
        }
    }
}

