/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.util.IncrementCounterListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.commons.utils.cache.Cache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DeleteProcessDefinitionTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected Deployment deployment;
    protected static final String IO_MAPPING_PROCESS_KEY = "ioMappingProcess";
    protected static final BpmnModelInstance IO_MAPPING_PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"ioMappingProcess").startEvent().userTask().camundaOutputParameter("inputParameter", "${notExistentVariable}")).endEvent().done();

    @Before
    public void initServices() {
        this.historyService = this.engineRule.getHistoryService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
    }

    @After
    public void cleanUp() {
        if (this.deployment != null) {
            this.repositoryService.deleteDeployment(this.deployment.getId(), true);
            this.deployment = null;
        }
    }

    @Test
    public void testDeleteProcessDefinitionNullId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinition(null)).isInstanceOf(NullValueException.class)).hasMessageContaining("processDefinitionId is null");
    }

    @Test
    public void testDeleteNonExistingProcessDefinition() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinition("notexist")).isInstanceOf(NotFoundException.class)).hasMessageContaining("No process definition found with id 'notexist': processDefinition is null");
    }

    @Test
    public void testDeleteProcessDefinition() {
        this.deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml").deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testDeleteProcessDefinitionWithProcessInstance() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModel).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.runtimeService.createProcessInstanceByKey("process").executeWithVariablesInReturn();
        try {
            this.repositoryService.deleteProcessDefinition(processDefinition.getId());
            TestCase.fail((String)"Should fail, since there exists a process instance");
        }
        catch (ProcessEngineException pex) {
            TestCase.assertTrue((boolean)pex.getMessage().contains("Deletion of process definition without cascading failed."));
        }
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testDeleteProcessDefinitionCascade() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModel).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.runtimeService.createProcessInstanceByKey("process").executeWithVariablesInReturn();
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
        }
    }

    @Test
    public void testDeleteProcessDefinitionClearsCache() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModel).deploy();
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult()).getId();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        TestCase.assertNotNull((Object)deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionId));
        TestCase.assertNotNull((Object)deploymentCache.getBpmnModelInstanceCache().get((Object)processDefinitionId));
        this.repositoryService.deleteProcessDefinition(processDefinitionId, true);
        TestCase.assertNull((Object)deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionId));
        TestCase.assertNull((Object)deploymentCache.getBpmnModelInstanceCache().get((Object)processDefinitionId));
    }

    @Test
    public void testDeleteProcessDefinitionAndRefillDeploymentCache() {
        this.deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml").deploy();
        ProcessDefinition processDefinitionOne = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").singleResult();
        ProcessDefinition processDefinitionTwo = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two").singleResult();
        String idOne = processDefinitionOne.getId();
        this.repositoryService.deleteProcessDefinition(idOne);
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        ProcessInstanceWithVariables procInst = this.runtimeService.createProcessInstanceByKey("two").executeWithVariablesInReturn();
        TestCase.assertNotNull((Object)procInst);
        TestCase.assertTrue((boolean)procInst.getProcessDefinitionId().contains("two"));
        Cache cache = this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache();
        TestCase.assertNotNull((Object)cache.get((Object)processDefinitionTwo.getId()));
        TestCase.assertNull((Object)cache.get((Object)processDefinitionOne.getId()));
    }

    @Test
    public void testDeleteProcessDefinitionAndRedeploy() {
        this.deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml").deploy();
        ProcessDefinition processDefinitionOne = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").singleResult();
        this.repositoryService.deleteProcessDefinition(processDefinitionOne.getId());
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment").addDeploymentResources(this.deployment.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        this.repositoryService.deleteDeployment(deployment2.getId(), true);
    }

    @Test
    public void testDeleteProcessDefinitionsByNotExistingKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byKey("no existing key").withoutTenantId().delete()).isInstanceOf(NotFoundException.class)).hasMessageContaining("No process definition found");
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byKey(null).withoutTenantId().delete()).isInstanceOf(NullValueException.class)).hasMessageContaining("cannot be null");
    }

    @Test
    public void testDeleteProcessDefinitionsByKey() {
        for (int i = 0; i < 3; ++i) {
            this.deployTwoProcessDefinitions();
        }
        this.repositoryService.deleteProcessDefinitions().byKey("processOne").withoutTenantId().delete();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(3L);
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyWithRunningProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.deployTwoProcessDefinitions();
        }
        this.runtimeService.startProcessInstanceByKey("processOne");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byKey("processOne").withoutTenantId().delete()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Deletion of process definition");
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyCascading() {
        int i;
        for (int i2 = 0; i2 < 3; ++i2) {
            this.deployTwoProcessDefinitions();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        for (i = 0; i < 3; ++i) {
            variables.put("varName" + i, "varValue");
        }
        for (i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("processOne", variables);
            this.runtimeService.startProcessInstanceByKey("processTwo", variables);
        }
        this.repositoryService.deleteProcessDefinitions().byKey("processOne").withoutTenantId().cascade().delete();
        this.repositoryService.deleteProcessDefinitions().byKey("processTwo").withoutTenantId().cascade().delete();
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(0L);
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyWithCustomListenersSkipped() {
        IncrementCounterListener.counter = 0;
        for (int i = 0; i < 3; ++i) {
            this.deployTwoProcessDefinitions();
        }
        this.runtimeService.startProcessInstanceByKey("processOne");
        this.repositoryService.deleteProcessDefinitions().byKey("processOne").withoutTenantId().cascade().skipCustomListeners().delete();
        Assertions.assertThat((int)IncrementCounterListener.counter).isEqualTo(0);
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyWithIoMappingsSkipped() {
        this.testHelper.deploy(IO_MAPPING_PROCESS);
        this.runtimeService.startProcessInstanceByKey(IO_MAPPING_PROCESS_KEY);
        this.testHelper.deploy(IO_MAPPING_PROCESS);
        this.runtimeService.startProcessInstanceByKey(IO_MAPPING_PROCESS_KEY);
        this.repositoryService.deleteProcessDefinitions().byKey(IO_MAPPING_PROCESS_KEY).withoutTenantId().cascade().skipIoMappings().delete();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(0);
    }

    @Test
    public void testDeleteProcessDefinitionsByNotExistingIds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byIds(new String[]{"not existing", "also not existing"}).delete()).isInstanceOf(NotFoundException.class)).hasMessageContaining("No process definition found");
    }

    @Test
    public void testDeleteProcessDefinitionsByIdIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byIds(null).delete()).isInstanceOf(NullValueException.class)).hasMessageContaining("cannot be null");
    }

    @Test
    public void testDeleteProcessDefinitionsByIds() {
        for (int i = 0; i < 3; ++i) {
            this.deployTwoProcessDefinitions();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("processOne");
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(3L);
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsWithRunningProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.deployTwoProcessDefinitions();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("processOne");
        this.runtimeService.startProcessInstanceByKey("processOne");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Deletion of process definition");
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsCascading() {
        int i;
        for (int i2 = 0; i2 < 3; ++i2) {
            this.deployTwoProcessDefinitions();
        }
        String[] processDefinitionIdsOne = this.findProcessDefinitionIdsByKey("processOne");
        String[] processDefinitionIdsTwo = this.findProcessDefinitionIdsByKey("processTwo");
        HashMap<String, String> variables = new HashMap<String, String>();
        for (i = 0; i < 3; ++i) {
            variables.put("varName" + i, "varValue");
        }
        for (i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("processOne", variables);
            this.runtimeService.startProcessInstanceByKey("processTwo", variables);
        }
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIdsOne).cascade().delete();
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIdsTwo).cascade().delete();
        Assertions.assertThat((long)this.historyService.createHistoricVariableInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.historyService.createHistoricProcessInstanceQuery().count()).isEqualTo(0L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(0L);
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsWithCustomListenersSkipped() {
        IncrementCounterListener.counter = 0;
        for (int i = 0; i < 3; ++i) {
            this.deployTwoProcessDefinitions();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("processOne");
        this.runtimeService.startProcessInstanceByKey("processOne");
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().skipCustomListeners().delete();
        Assertions.assertThat((int)IncrementCounterListener.counter).isEqualTo(0);
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsWithIoMappingsSkipped() {
        this.testHelper.deploy(IO_MAPPING_PROCESS);
        this.runtimeService.startProcessInstanceByKey(IO_MAPPING_PROCESS_KEY);
        this.testHelper.deploy(IO_MAPPING_PROCESS);
        this.runtimeService.startProcessInstanceByKey(IO_MAPPING_PROCESS_KEY);
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey(IO_MAPPING_PROCESS_KEY);
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().skipIoMappings().delete();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(0);
    }

    private void deployTwoProcessDefinitions() {
        this.testHelper.deploy(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"processOne").startEvent().userTask().camundaExecutionListenerClass("end", IncrementCounterListener.class.getName())).endEvent().done(), Bpmn.createExecutableProcess((String)"processTwo").startEvent().userTask().endEvent().done());
    }

    private String[] findProcessDefinitionIdsByKey(String processDefinitionKey) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        ArrayList<String> processDefinitionIds = new ArrayList<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionIds.add(processDefinition.getId());
        }
        return processDefinitionIds.toArray(new String[0]);
    }
}

