/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaseInstanceQueryTest
extends PluggableProcessEngineTest {
    private static String CASE_DEFINITION_KEY = "oneTaskCase";
    private static String CASE_DEFINITION_KEY_2 = "oneTaskCase2";
    private List<String> caseInstanceIds;

    @Before
    public void setUp() throws Exception {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn").addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn").deploy();
        this.caseInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            String id = this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).businessKey(String.valueOf(i)).create().getId();
            this.caseInstanceIds.add(id);
        }
        String id = this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY_2).businessKey("1").create().getId();
        this.caseInstanceIds.add(id);
    }

    @After
    public void tearDown() throws Exception {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    private void verifyQueryResults(CaseInstanceQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(CaseInstanceQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testCaseInstanceProperties() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult()).getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult();
        Assert.assertNotNull((Object)caseInstance.getId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertEquals((Object)"1", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)"CasePlanModel_1", (Object)caseInstance.getActivityId());
        Assert.assertNull((Object)caseInstance.getActivityName());
        Assert.assertNull((Object)caseInstance.getParentId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
    }

    @Test
    public void testQueryWithoutQueryParameter() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        this.verifyQueryResults(query, 5);
    }

    @Test
    public void testQueryByCaseDefinitionKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult()).getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 4);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByActive() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.active();
        this.verifyQueryResults(query, 5);
    }

    @Test
    public void testQueryByCompleted() {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn").deploy();
        for (int i = 0; i < 4; ++i) {
            String id = this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).businessKey(String.valueOf(i)).create().getId();
            this.caseInstanceIds.add(id);
        }
        List executions = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").list();
        for (CaseExecution caseExecution : executions) {
            this.caseService.withCaseExecution(caseExecution.getId()).disable();
        }
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.completed();
        this.verifyQueryResults(query, 4);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/CaseInstanceQueryTest.testQueryByTerminated.cmmn"})
    @Test
    public void testQueryByTerminated() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("termination").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(caseInstanceId).singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).complete();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.terminated();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByCaseInstanceBusinessKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceBusinessKey("1");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByInvalidCaseInstanceBusinessKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCaseInstanceBusinessKeyAndCaseDefinitionKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceBusinessKey("0").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("2").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("3").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByCaseInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        for (String caseInstanceId : this.caseInstanceIds) {
            query.caseInstanceId(caseInstanceId);
            this.verifyQueryResults(query, 1);
        }
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByStringVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByShortVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableValueEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByShortVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueNotEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueNotEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableValueNotEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueNotEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueGreaterThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueGreaterThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableGreaterThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueGreaterThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueGreaterThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueGreaterThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableGreaterThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueLessThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueLessThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableLessThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByBooleanVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByShortVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByIntegerVariableValueLessThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByLongVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDateVariableValueLessThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThanOrEqual("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByDoubleVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByByteArrayVariableValueLessThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryBySerializableVariableLessThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLike("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByNullVariableValueNotLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueNotLike("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByStringVariableValueNotLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotLike("aStringValue", "abc%");
        this.verifyQueryResults(query, 0);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotLike("aStringValue", "abd%");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotLike("aStringValue", "%bd");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotLike("aStringValue", "%d%");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotLike("nonExistentValue", "%abc%");
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySorting() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionId().asc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionKey().asc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseInstanceId().asc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionId().desc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionKey().desc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseInstanceId().desc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
    }

    @Test
    public void testCaseVariableValueEqualsNumber() throws Exception {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123L).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)12345L).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123.0).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", null).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)Variables.longValue(null)).create();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("var", (Object)"123").create();
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.caseService.createCaseInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseInstanceQuery().variableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.caseService.createCaseInstanceQuery().variableValueGreaterThan("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)5L, (long)this.caseService.createCaseInstanceQuery().variableValueGreaterThanOrEqual("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)0L, (long)this.caseService.createCaseInstanceQuery().variableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.caseService.createCaseInstanceQuery().variableValueLessThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml"})
    @Test
    public void testQueryBySuperProcessInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivityInsideSubProcess.bpmn20.xml"})
    @Test
    public void testQueryBySuperProcessInstanceIdNested() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidSuperProcessInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().superProcessInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.superProcessInstanceId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryBySubProcessInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String subProcessInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId).singleResult()).getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().subProcessInstanceId(subProcessInstanceId);
        this.verifyQueryResults(query, 1);
        CaseInstance caseInstance = (CaseInstance)query.singleResult();
        Assert.assertEquals((Object)superCaseInstanceId, (Object)caseInstance.getId());
    }

    @Test
    public void testQueryByInvalidSubProcessInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().subProcessInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.subProcessInstanceId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn"})
    @Test
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneCaseTaskCase").getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidSuperCaseInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().superCaseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.superCaseInstanceId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn"})
    @Test
    public void testQueryBySubCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superCaseInstanceId(superCaseInstanceId).singleResult()).getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        this.verifyQueryResults(query, 1);
        CaseInstance caseInstance = (CaseInstance)query.singleResult();
        Assert.assertEquals((Object)superCaseInstanceId, (Object)caseInstance.getId());
    }

    @Test
    public void testQueryByInvalidSubCaseInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().subCaseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.subCaseInstanceId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByDeploymentId() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().deploymentId(deploymentId);
        this.verifyQueryResults(query, 5);
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }
}

