/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceModificationTest
extends PluggableProcessEngineTest {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String SUBPROCESS_LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocessListeners.bpmn20.xml";
    protected static final String SUBPROCESS_BOUNDARY_EVENTS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocessBoundaryEvents.bpmn20.xml";
    protected static final String ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml";
    protected static final String TRANSITION_LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.transitionListeners.bpmn20.xml";
    protected static final String TASK_LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.taskListeners.bpmn20.xml";
    protected static final String IO_MAPPING_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMapping.bpmn20.xml";
    protected static final String IO_MAPPING_ON_SUB_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMappingOnSubProcess.bpmn20.xml";
    protected static final String IO_MAPPING_ON_SUB_PROCESS_AND_NESTED_SUB_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMappingOnSubProcessNested.bpmn20.xml";
    protected static final String LISTENERS_ON_SUB_PROCESS_AND_NESTED_SUB_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.listenersOnSubProcessNested.bpmn20.xml";
    protected static final String DOUBLE_NESTED_SUB_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml";
    protected static final String TRANSACTION_WITH_COMPENSATION_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml";
    protected static final String CALL_ACTIVITY_PARENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityParentProcess.bpmn";
    protected static final String CALL_ACTIVITY_CHILD_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityChildProcess.bpmn";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationThatEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task2")).execute();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationWithWrongProcessInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification("foo").cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task2")).execute();
            this.testRule.assertProcessEnded(processInstance.getId());
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).startsWith((CharSequence)"ENGINE-13036");
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance 'foo' cannot be modified"});
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeWithAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2", tree.getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml"})
    @Test
    public void testStartBeforeWithAncestorInstanceIdTwoScopesUp() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("doubleNestedSubprocess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess")).execute();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerSubProcessTask")).execute();
            Assert.fail((String)"should not succeed because the ancestors are ambiguous");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance randomSubProcessInstance = this.getChildInstanceForActivity(updatedTree, "subProcess");
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerSubProcessTask", randomSubProcessInstance.getId()).execute();
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("subProcessTask").endScope().beginScope("subProcess").activity("subProcessTask").beginScope("innerSubProcess").activity("innerSubProcessTask").done());
        ActivityInstance innerSubProcessInstance = this.getChildInstanceForActivity(updatedTree, "innerSubProcess");
        Assert.assertEquals((Object)randomSubProcessInstance.getId(), (Object)innerSubProcessInstance.getParentActivityInstanceId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerSubProcessTask").scope().done());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "innerSubProcessTask", "innerSubProcessTask", "innerSubProcessTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml"})
    @Test
    public void testStartBeforeWithInvalidAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("doubleNestedSubprocess");
        String processInstanceId = processInstance.getId();
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess", "noValidActivityInstanceId").execute();
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start before activity 'subProcess' with ancestor activity instance 'noValidActivityInstanceId'; Ancestor activity instance 'noValidActivityInstanceId' does not exist", e.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess", null).execute();
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("ancestorActivityInstanceId is null", e.getMessage());
        }
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        String subProcessTaskId = this.getInstanceIdForActivity(tree, "subProcessTask");
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess", subProcessTaskId).execute();
            Assert.fail((String)"should not succeed because subProcessTask is a child of subProcess");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start before activity 'subProcess' with ancestor activity instance '" + subProcessTaskId + "'; Scope execution for '" + subProcessTaskId + "' cannot be found in parent hierarchy of flow element 'subProcess'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("someNonExistingActivity")).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("element 'someNonExistingActivity' does not exist in process ", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testEndProcessInstanceIntermediately() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startAfterActivity("task1")).startBeforeActivity("task1")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task1").scope().done());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow4")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransitionWithAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow4", tree.getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml"})
    @Test
    public void testStartTransitionWithAncestorInstanceIdTwoScopesUp() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("doubleNestedSubprocess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess")).execute();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow5")).execute();
            Assert.fail((String)"should not succeed because the ancestors are ambiguous");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance randomSubProcessInstance = this.getChildInstanceForActivity(updatedTree, "subProcess");
        this.runtimeService.createProcessInstanceModification(processInstanceId).startTransition("flow5", randomSubProcessInstance.getId()).execute();
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("subProcessTask").endScope().beginScope("subProcess").activity("subProcessTask").beginScope("innerSubProcess").activity("innerSubProcessTask").done());
        ActivityInstance innerSubProcessInstance = this.getChildInstanceForActivity(updatedTree, "innerSubProcess");
        Assert.assertEquals((Object)randomSubProcessInstance.getId(), (Object)innerSubProcessInstance.getParentActivityInstanceId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerSubProcessTask").scope().done());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "innerSubProcessTask", "innerSubProcessTask", "innerSubProcessTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml"})
    @Test
    public void testStartTransitionWithInvalidAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("doubleNestedSubprocess");
        String processInstanceId = processInstance.getId();
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow5", "noValidActivityInstanceId").execute();
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start transition 'flow5' with ancestor activity instance 'noValidActivityInstanceId'; Ancestor activity instance 'noValidActivityInstanceId' does not exist", e.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow5", null).execute();
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("ancestorActivityInstanceId is null", e.getMessage());
        }
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        String subProcessTaskId = this.getInstanceIdForActivity(tree, "subProcessTask");
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow5", subProcessTaskId).execute();
            Assert.fail((String)"should not succeed because subProcessTask is a child of subProcess");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start transition 'flow5' with ancestor activity instance '" + subProcessTaskId + "'; Scope execution for '" + subProcessTaskId + "' cannot be found in parent hierarchy of flow element 'flow5'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransitionCase2() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startTransition("flow2")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task1").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartTransitionInvalidTransitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startTransition("invalidFlowId")).execute();
            Assert.fail((String)"should not suceed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start transition 'invalidFlowId'; Element 'invalidFlowId' does not exist in process '" + processInstance.getProcessDefinitionId() + "'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task1").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterWithAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theStart", tree.getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task1").concurrent().noScope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("task1", "task1");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml"})
    @Test
    public void testStartAfterWithAncestorInstanceIdTwoScopesUp() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("doubleNestedSubprocess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcess")).execute();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("innerSubProcessStart")).execute();
            Assert.fail((String)"should not succeed because the ancestors are ambiguous");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance randomSubProcessInstance = this.getChildInstanceForActivity(updatedTree, "subProcess");
        this.runtimeService.createProcessInstanceModification(processInstanceId).startAfterActivity("innerSubProcessStart", randomSubProcessInstance.getId()).execute();
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("subProcessTask").endScope().beginScope("subProcess").activity("subProcessTask").beginScope("innerSubProcess").activity("innerSubProcessTask").done());
        ActivityInstance innerSubProcessInstance = this.getChildInstanceForActivity(updatedTree, "innerSubProcess");
        Assert.assertEquals((Object)randomSubProcessInstance.getId(), (Object)innerSubProcessInstance.getParentActivityInstanceId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerSubProcessTask").scope().done());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "innerSubProcessTask", "innerSubProcessTask", "innerSubProcessTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.doubleNestedSubprocess.bpmn20.xml"})
    @Test
    public void testStartAfterWithInvalidAncestorInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("doubleNestedSubprocess");
        String processInstanceId = processInstance.getId();
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("innerSubProcessStart", "noValidActivityInstanceId").execute();
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start after activity 'innerSubProcessStart' with ancestor activity instance 'noValidActivityInstanceId'; Ancestor activity instance 'noValidActivityInstanceId' does not exist", e.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("innerSubProcessStart", null).execute();
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("ancestorActivityInstanceId is null", e.getMessage());
        }
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        String subProcessTaskId = this.getInstanceIdForActivity(tree, "subProcessTask");
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("innerSubProcessStart", subProcessTaskId).execute();
            Assert.fail((String)"should not succeed because subProcessTask is a child of subProcess");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Start after activity 'innerSubProcessStart' with ancestor activity instance '" + subProcessTaskId + "'; Scope execution for '" + subProcessTaskId + "' cannot be found in parent hierarchy of flow element 'flow5'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterActivityAmbiguousTransitions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startAfterActivity("fork")).execute();
            Assert.fail((String)"should not suceed since 'fork' has more than one outgoing sequence flow");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("activity has more than one outgoing sequence flow", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterActivityNoOutgoingTransitions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startAfterActivity("theEnd")).execute();
            Assert.fail((String)"should not suceed since 'theEnd' has no outgoing sequence flow");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("activity has no outgoing sequence flow to take", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartAfterNonExistingActivity() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startAfterActivity("someNonExistingActivity")).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("Cannot perform instruction: Start after activity 'someNonExistingActivity'; Activity 'someNonExistingActivity' does not exist: activity is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testScopeTaskStartBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("theTask").scope().up().up().child(null).concurrent().noScope().child("theTask").scope().done());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.completeTasksInOrder("theTask", "theTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testScopeTaskStartAfter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").scope().done());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("theStart")).execute();
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").activity("theTask").done());
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("theTask").scope().up().up().child(null).concurrent().noScope().child("theTask").scope().done());
        this.completeTasksInOrder("theTask", "theTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocessBoundaryEvents.bpmn20.xml"})
    @Test
    public void testStartBeforeEventSubscription() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).execute();
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        Job innerJob = (Job)this.managementService.createJobQuery().activityId("innerTimer").singleResult();
        Assert.assertNotNull((Object)innerJob);
        Assert.assertEquals((Object)((Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult()).getId(), (Object)innerJob.getExecutionId());
        Job outerJob = (Job)this.managementService.createJobQuery().activityId("outerTimer").singleResult();
        Assert.assertNotNull((Object)outerJob);
        this.managementService.executeJob(innerJob.getId());
        Task innerBoundaryTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerAfterBoundaryTask").singleResult();
        Assert.assertNotNull((Object)innerBoundaryTask);
        this.managementService.executeJob(outerJob.getId());
        Task outerBoundaryTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("outerAfterBoundaryTask").singleResult();
        Assert.assertNotNull((Object)outerBoundaryTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocessListeners.bpmn20.xml"})
    @Test
    public void testActivityExecutionListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess", Collections.singletonMap("listener", new RecorderExecutionListener()));
        String processInstanceId = processInstance.getId();
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).execute();
        ActivityInstance activityInstanceTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstanceTree);
        Assert.assertEquals((Object)processInstanceId, (Object)activityInstanceTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(activityInstanceTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        ActivityInstance subprocessInstance = this.getChildInstanceForActivity(activityInstanceTree, "subProcess");
        ActivityInstance innerTaskInstance = this.getChildInstanceForActivity(subprocessInstance, "innerTask");
        RecorderExecutionListener.RecordedEvent firstEvent = recordedEvents.get(0);
        RecorderExecutionListener.RecordedEvent secondEvent = recordedEvents.get(1);
        Assert.assertEquals((Object)"subProcess", (Object)firstEvent.getActivityId());
        Assert.assertEquals((Object)subprocessInstance.getId(), (Object)firstEvent.getActivityInstanceId());
        Assert.assertEquals((Object)"start", (Object)secondEvent.getEventName());
        Assert.assertEquals((Object)"innerTask", (Object)secondEvent.getActivityId());
        Assert.assertEquals((Object)innerTaskInstance.getId(), (Object)secondEvent.getActivityInstanceId());
        Assert.assertEquals((Object)"start", (Object)secondEvent.getEventName());
        RecorderExecutionListener.clear();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(innerTaskInstance.getId()).execute();
        Assert.assertEquals((long)2L, (long)RecorderExecutionListener.getRecordedEvents().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocessListeners.bpmn20.xml"})
    @Test
    public void testSkipListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subprocess", Collections.singletonMap("listener", new RecorderExecutionListener()));
        String processInstanceId = processInstance.getId();
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerTask")).execute(true, false);
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
        ActivityInstance activityInstanceTree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getChildInstanceForActivity(activityInstanceTree, "innerTask").getId()).execute(true, false);
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getChildInstanceForActivity(activityInstanceTree, "outerTask").getId()).execute(true, false);
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.taskListeners.bpmn20.xml"})
    @Test
    public void testSkipTaskListenerInvocation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess", Collections.singletonMap("listener", new RecorderTaskListener()));
        String processInstanceId = processInstance.getId();
        RecorderTaskListener.clear();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("task")).execute(true, false);
        Assert.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
        ActivityInstance activityInstanceTree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getChildInstanceForActivity(activityInstanceTree, "task").getId()).execute(true, false);
        Assert.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMapping.bpmn20.xml"})
    @Test
    public void testSkipIoMappings() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute(false, true);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)task2Execution);
        Assert.assertNull((Object)this.runtimeService.getVariable(task2Execution.getId(), "inputMappingExecuted"));
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("task2").execute(false, true);
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "outputMappingExecuted"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMappingOnSubProcess.bpmn20.xml"})
    @Test
    public void testSkipIoMappingsOnSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("boundaryEvent")).execute(false, true);
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "outputMappingExecuted"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.ioMappingOnSubProcessNested.bpmn20.xml"})
    @Test
    public void testSkipIoMappingsOnSubProcessNested() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("boundaryEvent")).execute(false, true);
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "outputMappingExecuted"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.listenersOnSubProcessNested.bpmn20.xml"})
    @Test
    public void testSkipListenersOnSubProcessNested() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("boundaryEvent")).execute(true, false);
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.transitionListeners.bpmn20.xml"})
    @Test
    public void testStartTransitionListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("transitionListenerProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startTransition("flow2")).execute();
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        RecorderExecutionListener.RecordedEvent event = events.get(0);
        Assert.assertEquals((Object)"flow2", (Object)event.getTransitionId());
        RecorderExecutionListener.clear();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)instance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "task2", "task2");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.transitionListeners.bpmn20.xml"})
    @Test
    public void testStartAfterActivityListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("transitionListenerProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startTransition("flow2")).execute();
        List<RecorderExecutionListener.RecordedEvent> events = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        RecorderExecutionListener.RecordedEvent event = events.get(0);
        Assert.assertEquals((Object)"flow2", (Object)event.getTransitionId());
        RecorderExecutionListener.clear();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)instance.getId(), (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(instance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "task2", "task2");
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeWithVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).setVariable("procInstVar", (Object)"procInstValue")).setVariableLocal("localVar", (Object)"localValue")).setVariables((Map)Variables.createVariables().putValue("procInstMapVar", (Object)"procInstMapValue"))).setVariablesLocal((Map)Variables.createVariables().putValue("localMapVar", (Object)"localMapValue"))).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ActivityInstance task2Instance = this.getChildInstanceForActivity(updatedTree, "task2");
        Assert.assertNotNull((Object)task2Instance);
        Assert.assertEquals((long)1L, (long)task2Instance.getExecutionIds().length);
        String task2ExecutionId = task2Instance.getExecutionIds()[0];
        Assert.assertEquals((long)4L, (long)this.runtimeService.createVariableInstanceQuery().count());
        Assert.assertEquals((Object)"procInstValue", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "procInstVar"));
        Assert.assertEquals((Object)"localValue", (Object)this.runtimeService.getVariableLocal(task2ExecutionId, "localVar"));
        Assert.assertEquals((Object)"procInstMapValue", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "procInstMapVar"));
        Assert.assertEquals((Object)"localMapValue", (Object)this.runtimeService.getVariableLocal(task2ExecutionId, "localMapVar"));
        this.completeTasksInOrder("task1", "task2");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testCancellationAndStartBefore() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task2")).execute();
        ActivityInstance activityInstanceTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)activityInstanceTree);
        Assert.assertEquals((Object)processInstanceId, (Object)activityInstanceTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(activityInstanceTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensationRemovalOnCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensationProcess");
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Task task = (Task)this.taskService.createTaskQuery().executionId(taskExecution.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask2")).execute();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Deployment
    @Test
    public void testCompensationCreation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensationProcess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).execute();
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        Task task = (Task)this.taskService.createTaskQuery().executionId(task2Execution.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Task outerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("outerTask").singleResult();
        Assert.assertNotNull((Object)outerTask);
        this.taskService.complete(outerTask.getId());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("innerAfterBoundaryTask").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("outerAfterBoundaryTask").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterSubprocess").count());
        this.completeTasksInOrder("taskAfterSubprocess", "innerAfterBoundaryTask", "outerAfterBoundaryTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNoCompensationCreatedOnCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensationProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"outerTask", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartActivityInTransactionWithCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"undoTask", (Object)task.getTaskDefinitionKey());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").done());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("userTask")).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").activity("userTask").done());
        this.completeTasksInOrder("userTask");
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").done());
        Task newTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotSame((Object)task.getId(), (Object)newTask.getId());
        this.completeTasksInOrder("undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartActivityWithAncestorInTransactionWithCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"undoTask", (Object)task.getTaskDefinitionKey());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").done());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("userTask", processInstance.getId()).execute();
        this.completeTasksInOrder("userTask");
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").endScope().beginScope("tx").activity("txEnd").activity("undoTask").done());
        this.completeTasksInOrder("undoTask", "undoTask", "afterCancel", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartAfterActivityDuringCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"undoTask", (Object)task.getTaskDefinitionKey());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("userTask")).execute();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"afterCancel", (Object)task.getTaskDefinitionKey());
        this.completeTasksInOrder("afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testCancelCompensatingTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "undoTask")).execute();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testCancelCompensatingTaskAndStartActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "undoTask")).startBeforeActivity("userTask")).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("userTask").done());
        this.completeTasksInOrder("userTask", "undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testCancelCompensatingTaskAndStartActivityWithAncestor() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "undoTask")).startBeforeActivity("userTask", processInstance.getId()).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("userTask").done());
        this.completeTasksInOrder("userTask", "undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartActivityAndCancelCompensatingTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("userTask")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "undoTask")).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("userTask").done());
        this.completeTasksInOrder("userTask", "undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartCompensatingTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("undoTask")).execute();
        this.completeTasksInOrder("undoTask");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"userTask", (Object)task.getTaskDefinitionKey());
        this.completeTasksInOrder("userTask", "undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartAdditionalCompensatingTaskAndCompleteOldCompensationTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        Task firstUndoTask = (Task)this.taskService.createTaskQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("undoTask")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").activity("undoTask").done());
        this.taskService.complete(firstUndoTask.getId());
        Task secondUndoTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("undoTask").singleResult();
        Assert.assertNull((Object)secondUndoTask);
        this.completeTasksInOrder("afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartAdditionalCompensatingTaskAndCompleteNewCompensatingTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        Task firstUndoTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("undoTask").singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("undoTask")).setVariableLocal("new", (Object)true)).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").activity("undoTask").done());
        String taskExecutionId = ((Execution)this.runtimeService.createExecutionQuery().variableValueEquals("new", (Object)true).singleResult()).getId();
        Task secondUndoTask = (Task)this.taskService.createTaskQuery().executionId(taskExecutionId).singleResult();
        Assert.assertNotNull((Object)secondUndoTask);
        Assert.assertNotSame((Object)firstUndoTask.getId(), (Object)secondUndoTask.getId());
        this.taskService.complete(secondUndoTask.getId());
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").done());
        this.completeTasksInOrder("undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartCompensationBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("compensateBoundaryEvent")).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("compensation boundary event", e.getMessage());
        }
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("compensateBoundaryEvent")).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no outgoing sequence flow", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartCancelEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("txEnd")).execute();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"afterCancel", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartCancelBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("catchCancelTx")).execute();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"afterCancel", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testTransactionWithCompensation.bpmn20.xml"})
    @Test
    public void testStartTaskAfterCancelBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.completeTasksInOrder("userTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("afterCancel")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("tx").activity("txEnd").activity("undoTask").endScope().activity("afterCancel").done());
        this.completeTasksInOrder("afterCancel", "undoTask", "afterCancel");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testCancelNonExistingActivityInstance() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            this.runtimeService.createProcessInstanceModification(instance.getId()).cancelActivityInstance("nonExistingActivityInstance").execute();
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Cancel activity instance 'nonExistingActivityInstance'; Activity instance 'nonExistingActivityInstance' does not exist", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testCancelNonExistingTranisitionInstance() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        try {
            this.runtimeService.createProcessInstanceModification(instance.getId()).cancelTransitionInstance("nonExistingActivityInstance").execute();
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot perform instruction: Cancel transition instance 'nonExistingActivityInstance'; Transition instance 'nonExistingActivityInstance' does not exist", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityParentProcess.bpmn", "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.testCancelCallActivityChildProcess.bpmn"})
    public void FAILING_testCancelCallActivityInstance() {
        ProcessInstance parentprocess = this.runtimeService.startProcessInstanceByKey("parentprocess");
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subprocess").singleResult();
        ActivityInstance subProcessActivityInst = this.runtimeService.getActivityInstance(subProcess.getId());
        this.runtimeService.createProcessInstanceModification(subProcess.getId()).startBeforeActivity("childEnd", subProcess.getId()).cancelActivityInstance(this.getInstanceIdForActivity(subProcessActivityInst, "innerTask")).execute();
        this.testRule.assertProcessEnded(parentprocess.getId());
    }

    @Test
    public void testModifyNullProcessInstance() {
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(null).startBeforeActivity("someActivity")).execute();
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("processInstanceId is null", e.getMessage());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/concurrentExecutionVariable.bpmn20.xml"})
    public void shouldNotDeleteVariablesWhenConcurrentExecution() {
        String processInstanceId = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("featureIssueId", (Object)178825)).setVariable("implementationCategory", (Object)"category-value")).startBeforeActivity("Implement_feature")).execute().getId();
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "featureIssueId")).isEqualTo((Object)178825);
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "implementationCategory")).isEqualTo((Object)"category-value");
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "implementationIssue")).isNull();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("Set_issue_id")).execute();
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "implementationIssue")).isEqualTo((Object)777);
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "featureIssueId")).isEqualTo((Object)178825);
        Assertions.assertThat((Object)this.runtimeService.getVariable(processInstanceId, "implementationCategory")).isEqualTo((Object)"category-value");
    }

    protected String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

