/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class VariableInstanceQueryForOracleTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void testQueryWhen0InstancesActive() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        List variables = this.engineRule.getRuntimeService().createVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Test
    public void testQueryWhen1InstanceActive() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        String activityInstanceId = runtimeService.getActivityInstance(processInstance.getId()).getId();
        List variables = this.engineRule.getRuntimeService().createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId}).list();
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testQueryWhen1000InstancesActive() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        String[] ids = new String[1000];
        for (int i = 0; i < 1000; ++i) {
            String activityInstanceId;
            ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
            ids[i] = activityInstanceId = runtimeService.getActivityInstance(processInstance.getId()).getId();
        }
        List variables = this.engineRule.getRuntimeService().createVariableInstanceQuery().activityInstanceIdIn(ids).list();
        Assert.assertEquals((long)1000L, (long)variables.size());
    }

    @Test
    public void testQueryWhen1001InstancesActive() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        String[] ids = new String[1001];
        for (int i = 0; i < 1001; ++i) {
            String activityInstanceId;
            ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
            ids[i] = activityInstanceId = runtimeService.getActivityInstance(processInstance.getId()).getId();
        }
        List variables = this.engineRule.getRuntimeService().createVariableInstanceQuery().activityInstanceIdIn(ids).list();
        Assert.assertEquals((long)1001L, (long)variables.size());
    }

    @Test
    public void testQueryWhen2001InstancesActive() {
        Assume.assumeTrue((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("oracle"));
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        String[] ids = new String[2001];
        for (int i = 0; i < 2001; ++i) {
            String activityInstanceId;
            ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
            ids[i] = activityInstanceId = runtimeService.getActivityInstance(processInstance.getId()).getId();
        }
        List variables = this.engineRule.getRuntimeService().createVariableInstanceQuery().activityInstanceIdIn(ids).list();
        Assert.assertEquals((long)2001L, (long)variables.size());
    }
}

