/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MessageReceiveModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationReceiveTaskTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testCannotMigrateActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask", "receiveTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("receiveTask", "receiveTask", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionProperties() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask", "receiveTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        EventSubscription eventSubscriptionBefore = this.testHelper.snapshotBeforeMigration.getEventSubscriptions().get(0);
        List<EventSubscription> eventSubscriptionsAfter = this.testHelper.snapshotAfterMigration.getEventSubscriptions();
        Assert.assertEquals((long)1L, (long)eventSubscriptionsAfter.size());
        EventSubscription eventSubscriptionAfter = eventSubscriptionsAfter.get(0);
        Assert.assertEquals((Object)eventSubscriptionBefore.getCreated(), (Object)eventSubscriptionAfter.getCreated());
        Assert.assertEquals((Object)eventSubscriptionBefore.getExecutionId(), (Object)eventSubscriptionAfter.getExecutionId());
        Assert.assertEquals((Object)eventSubscriptionBefore.getProcessInstanceId(), (Object)eventSubscriptionAfter.getProcessInstanceId());
    }

    @Test
    public void testMigrateEventSubscriptionChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS).changeElementId("receiveTask", "newReceiveTask"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask", "newReceiveTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("receiveTask", "newReceiveTask", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionPreserveMessageName() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS).renameMessage("Message", "newMessage"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask", "receiveTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("receiveTask", "receiveTask", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionUpdateMessageName() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS).renameMessage("Message", "newMessage"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask", "receiveTask").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("receiveTask", "Message", "receiveTask", "newMessage");
        this.rule.getRuntimeService().correlateMessage("newMessage");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateParallelMultiInstanceEventSubscription() {
        BpmnModelInstance parallelMiReceiveTaskProcess = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS).activityBuilder("receiveTask").multiInstance().parallel()).cardinality("3")).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(parallelMiReceiveTaskProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(parallelMiReceiveTaskProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask#multiInstanceBody", "receiveTask#multiInstanceBody").mapActivities("receiveTask", "receiveTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionsMigrated("receiveTask", "receiveTask", "Message");
        this.rule.getRuntimeService().createMessageCorrelation("Message").correlateAll();
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateSequentialMultiInstanceEventSubscription() {
        BpmnModelInstance parallelMiReceiveTaskProcess = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS).activityBuilder("receiveTask").multiInstance().sequential()).cardinality("3")).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(parallelMiReceiveTaskProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(parallelMiReceiveTaskProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask#multiInstanceBody", "receiveTask#multiInstanceBody").mapActivities("receiveTask", "receiveTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionsMigrated("receiveTask", "receiveTask", "Message");
        for (int i = 0; i < 3; ++i) {
            this.rule.getRuntimeService().correlateMessage("Message");
        }
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubscriptionAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(MessageReceiveModels.SUBPROCESS_RECEIVE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("receiveTask", "receiveTask").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("receiveTask", "receiveTask", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

