/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.TimerCatchModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.joda.time.DateTime;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationTimerCatchEventTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateJob() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "timerCatch");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("timerCatch").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("timerCatch")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("timerCatch", this.testHelper.getSingleActivityInstanceBeforeMigration("timerCatch").getId()).done());
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateJobChangeActivityId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(TimerCatchModels.ONE_TIMER_CATCH_PROCESS).changeElementId("timerCatch", "newTimerCatch"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("timerCatch", "newTimerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "newTimerCatch");
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateJobPreserveTimerConfiguration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ProcessModels.newModel().startEvent().intermediateCatchEvent("timerCatch").timerWithDuration("PT50M")).userTask("userTask").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "timerCatch");
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateJobUpdateTimerConfiguration() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ProcessModels.newModel().startEvent().intermediateCatchEvent("timerCatch").timerWithDuration("PT50M")).userTask("userTask").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("timerCatch", "timerCatch").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusMinutes(50).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "timerCatch", newDueDate);
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateJobChangeProcessKey() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(TimerCatchModels.ONE_TIMER_CATCH_PROCESS).changeElementId("Process", "newProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "timerCatch");
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateJobAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.ONE_TIMER_CATCH_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(TimerCatchModels.SUBPROCESS_TIMER_CATCH_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "timerCatch");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).scope().child("timerCatch").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("timerCatch")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity("timerCatch", this.testHelper.getSingleActivityInstanceBeforeMigration("timerCatch").getId()).done());
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

