/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MigrationUserOperationLogTest {
    public static final String USER_ID = "userId";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testLogCreation() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getIdentityService().setAuthenticatedUserId(USER_ID);
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)3L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry procDefEntry = entries.get("processDefinitionId");
        Assert.assertNotNull((Object)procDefEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)procDefEntry.getEntityType());
        Assert.assertEquals((Object)"Migrate", (Object)procDefEntry.getOperationType());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)procDefEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)sourceProcessDefinition.getKey(), (Object)procDefEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)procDefEntry.getProcessInstanceId());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)procDefEntry.getOrgValue());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)procDefEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)procDefEntry.getCategory());
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"Migrate", (Object)asyncEntry.getOperationType());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)asyncEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)sourceProcessDefinition.getKey(), (Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"false", (Object)asyncEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)asyncEntry.getCategory());
        UserOperationLogEntry numInstanceEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstanceEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)numInstanceEntry.getEntityType());
        Assert.assertEquals((Object)"Migrate", (Object)numInstanceEntry.getOperationType());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)numInstanceEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)sourceProcessDefinition.getKey(), (Object)numInstanceEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstanceEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstanceEntry.getOrgValue());
        Assert.assertEquals((Object)"1", (Object)numInstanceEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)numInstanceEntry.getCategory());
        Assert.assertEquals((Object)procDefEntry.getOperationId(), (Object)asyncEntry.getOperationId());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)numInstanceEntry.getOperationId());
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }
}

