/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.ExecutionTree;

public class ProcessInstanceSnapshot {
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String deploymentId;
    protected ActivityInstance activityTree;
    protected ExecutionTree executionTree;
    protected List<EventSubscription> eventSubscriptions;
    protected List<Job> jobs;
    protected List<JobDefinition> jobDefinitions;
    protected List<Task> tasks;
    protected Map<String, VariableInstance> variables;

    public ProcessInstanceSnapshot(String processInstanceId, String processDefinitionId) {
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ActivityInstance getActivityTree() {
        this.ensurePropertySaved("activity tree", this.activityTree);
        return this.activityTree;
    }

    public void setActivityTree(ActivityInstance activityTree) {
        this.activityTree = activityTree;
    }

    public ExecutionTree getExecutionTree() {
        this.ensurePropertySaved("execution tree", this.executionTree);
        return this.executionTree;
    }

    public void setExecutionTree(ExecutionTree executionTree) {
        this.executionTree = executionTree;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Task> getTasks() {
        this.ensurePropertySaved("tasks", this.tasks);
        return this.tasks;
    }

    public Task getTaskForKey(String key) {
        for (Task task : this.getTasks()) {
            if (!key.equals(task.getTaskDefinitionKey())) continue;
            return task;
        }
        return null;
    }

    public List<EventSubscription> getEventSubscriptions() {
        this.ensurePropertySaved("event subscriptions", this.eventSubscriptions);
        return this.eventSubscriptions;
    }

    public EventSubscription getEventSubscriptionById(String id) {
        for (EventSubscription subscription : this.eventSubscriptions) {
            if (!subscription.getId().equals(id)) continue;
            return subscription;
        }
        return null;
    }

    public EventSubscription getEventSubscriptionForActivityIdAndEventName(String activityId, String eventName) {
        List<EventSubscription> collectedEventsubscriptions = this.getEventSubscriptionsForActivityIdAndEventName(activityId, eventName);
        if (collectedEventsubscriptions.isEmpty()) {
            return null;
        }
        if (collectedEventsubscriptions.size() == 1) {
            return collectedEventsubscriptions.get(0);
        }
        throw new RuntimeException("There is more than one event subscription for activity " + activityId + " and event " + eventName);
    }

    public List<EventSubscription> getEventSubscriptionsForActivityIdAndEventName(String activityId, String eventName) {
        ArrayList<EventSubscription> collectedEventsubscriptions = new ArrayList<EventSubscription>();
        for (EventSubscription eventSubscription : this.getEventSubscriptions()) {
            if (!activityId.equals(eventSubscription.getActivityId()) || (eventName != null || eventSubscription.getEventName() != null) && (eventName == null || !eventName.equals(eventSubscription.getEventName()))) continue;
            collectedEventsubscriptions.add(eventSubscription);
        }
        return collectedEventsubscriptions;
    }

    public void setEventSubscriptions(List<EventSubscription> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public List<Job> getJobs() {
        this.ensurePropertySaved("jobs", this.jobs);
        return this.jobs;
    }

    public Job getJobForDefinitionId(String jobDefinitionId) {
        ArrayList<Job> collectedJobs = new ArrayList<Job>();
        for (Job job : this.getJobs()) {
            if (!jobDefinitionId.equals(job.getJobDefinitionId())) continue;
            collectedJobs.add(job);
        }
        if (collectedJobs.isEmpty()) {
            return null;
        }
        if (collectedJobs.size() == 1) {
            return (Job)collectedJobs.get(0);
        }
        throw new RuntimeException("There is more than one job for job definition " + jobDefinitionId);
    }

    public Job getJobById(String jobId) {
        for (Job job : this.getJobs()) {
            if (!jobId.equals(job.getId())) continue;
            return job;
        }
        return null;
    }

    public void setJobs(List<Job> jobs) {
        this.jobs = jobs;
    }

    public List<JobDefinition> getJobDefinitions() {
        this.ensurePropertySaved("job definitions", this.jobDefinitions);
        return this.jobDefinitions;
    }

    public JobDefinition getJobDefinitionForActivityIdAndType(String activityId, String jobHandlerType) {
        List<JobDefinition> collectedDefinitions = this.getJobDefinitionsForActivityIdAndType(activityId, jobHandlerType);
        if (collectedDefinitions.isEmpty()) {
            return null;
        }
        if (collectedDefinitions.size() == 1) {
            return collectedDefinitions.get(0);
        }
        throw new RuntimeException("There is more than one job definition for activity " + activityId + " and job handler type " + jobHandlerType);
    }

    protected List<JobDefinition> getJobDefinitionsForActivityIdAndType(String activityId, String jobHandlerType) {
        ArrayList<JobDefinition> collectedDefinitions = new ArrayList<JobDefinition>();
        for (JobDefinition jobDefinition : this.getJobDefinitions()) {
            if (!activityId.equals(jobDefinition.getActivityId()) || !jobHandlerType.equals(jobDefinition.getJobType())) continue;
            collectedDefinitions.add(jobDefinition);
        }
        return collectedDefinitions;
    }

    public void setJobDefinitions(List<JobDefinition> jobDefinitions) {
        this.jobDefinitions = jobDefinitions;
    }

    public Collection<VariableInstance> getVariables() {
        return this.variables.values();
    }

    public void setVariables(List<VariableInstance> variables) {
        this.variables = new HashMap<String, VariableInstance>();
        for (VariableInstance variable : variables) {
            this.variables.put(variable.getId(), variable);
        }
    }

    public VariableInstance getSingleVariable(final String variableName) {
        return this.getSingleVariable(new Condition<VariableInstance>(){

            @Override
            public boolean matches(VariableInstance variable) {
                return variableName.equals(variable.getName());
            }
        });
    }

    public VariableInstance getSingleVariable(final String executionId, final String variableName) {
        return this.getSingleVariable(new Condition<VariableInstance>(){

            @Override
            public boolean matches(VariableInstance variable) {
                return executionId.equals(variable.getExecutionId()) && variableName.equals(variable.getName());
            }
        });
    }

    public VariableInstance getSingleTaskVariable(final String taskId, final String variableName) {
        return this.getSingleVariable(new Condition<VariableInstance>(){

            @Override
            public boolean matches(VariableInstance variable) {
                return variableName.equals(variable.getName()) && taskId.equals(variable.getTaskId());
            }
        });
    }

    protected VariableInstance getSingleVariable(Condition<VariableInstance> condition) {
        ArrayList<VariableInstance> matchingVariables = new ArrayList<VariableInstance>();
        for (VariableInstance variable : this.variables.values()) {
            if (!condition.matches(variable)) continue;
            matchingVariables.add(variable);
        }
        if (matchingVariables.size() == 1) {
            return (VariableInstance)matchingVariables.get(0);
        }
        if (matchingVariables.size() == 0) {
            return null;
        }
        throw new RuntimeException("There is more than one variable that matches the given condition");
    }

    public VariableInstance getVariable(String id) {
        return this.variables.get(id);
    }

    protected void ensurePropertySaved(String name, Object property) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, (String)("The snapshot has not saved the " + name + " of the process instance"), (String)name, (Object)property);
    }

    protected static interface Condition<T> {
        public boolean matches(T var1);
    }
}

