/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.util.ArrayList;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigrationInstructionsBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.BatchHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;

public class BatchMigrationHelper
extends BatchHelper {
    protected MigrationTestRule migrationRule;
    public ProcessDefinition sourceProcessDefinition;
    public ProcessDefinition targetProcessDefinition;

    public BatchMigrationHelper(ProcessEngineRule engineRule, MigrationTestRule migrationRule) {
        super(engineRule);
        this.migrationRule = migrationRule;
    }

    public BatchMigrationHelper(ProcessEngineRule engineRule) {
        this(engineRule, null);
    }

    public ProcessDefinition getSourceProcessDefinition() {
        return this.sourceProcessDefinition;
    }

    public ProcessDefinition getTargetProcessDefinition() {
        return this.targetProcessDefinition;
    }

    public Batch createMigrationBatchWithSize(int batchSize) {
        int invocationsPerBatchJob = ((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getInvocationsPerBatchJob();
        return this.migrateProcessInstancesAsync(invocationsPerBatchJob * batchSize);
    }

    public Batch migrateProcessInstancesAsync(int numberOfProcessInstances) {
        this.sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        return this.migrateProcessInstancesAsync(numberOfProcessInstances, this.sourceProcessDefinition, this.targetProcessDefinition);
    }

    public Batch migrateProcessInstancesAsyncForTenant(int numberOfProcessInstances, String tenantId) {
        this.sourceProcessDefinition = this.migrationRule.deployForTenantAndGetDefinition(tenantId, ProcessModels.ONE_TASK_PROCESS);
        this.targetProcessDefinition = this.migrationRule.deployForTenantAndGetDefinition(tenantId, ProcessModels.ONE_TASK_PROCESS);
        return this.migrateProcessInstancesAsync(numberOfProcessInstances, this.sourceProcessDefinition, this.targetProcessDefinition);
    }

    public Batch migrateProcessInstanceAsync(ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition) {
        return this.migrateProcessInstancesAsync(1, sourceProcessDefinition, targetProcessDefinition);
    }

    public Batch migrateProcessInstancesAsync(int numberOfProcessInstances, ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition, Map<String, Object> variables, boolean authenticated) {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        ArrayList<String> processInstanceIds = new ArrayList<String>(numberOfProcessInstances);
        for (int i = 0; i < numberOfProcessInstances; ++i) {
            String srcProcessDefinitionId = sourceProcessDefinition.getId();
            String processInstanceId = runtimeService.startProcessInstanceById(srcProcessDefinitionId).getId();
            processInstanceIds.add(processInstanceId);
        }
        if (authenticated) {
            this.engineRule.getIdentityService().setAuthenticatedUserId("user");
        }
        MigrationInstructionsBuilder planBuilder = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities();
        if (variables != null) {
            planBuilder.setVariables(variables);
        }
        return runtimeService.newMigration(planBuilder.build()).processInstanceIds(processInstanceIds).executeAsync();
    }

    public Batch migrateProcessInstancesAsync(int numberOfProcessInstances, ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition, Map<String, Object> variables) {
        return this.migrateProcessInstancesAsync(numberOfProcessInstances, sourceProcessDefinition, targetProcessDefinition, variables, false);
    }

    public Batch migrateProcessInstancesAsync(int numberOfProcessInstances, ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition) {
        return this.migrateProcessInstancesAsync(numberOfProcessInstances, sourceProcessDefinition, targetProcessDefinition, null, false);
    }

    @Override
    public JobDefinition getExecutionJobDefinition(Batch batch) {
        return (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).jobType("instance-migration").singleResult();
    }

    public long countSourceProcessInstances() {
        return this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(this.sourceProcessDefinition.getId()).count();
    }

    public long countTargetProcessInstances() {
        return this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(this.targetProcessDefinition.getId()).count();
    }
}

