/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.history;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationHistoricActivityInstanceTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.historyService = this.rule.getHistoryService();
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoryActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "Process2").changeElementId("userTask", "userTask2").changeElementName("userTask", "new activity name"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        HistoricActivityInstanceQuery sourceHistoryActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        HistoricActivityInstanceQuery targetHistoryActivityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(targetProcessDefinition.getId());
        Assert.assertEquals((long)2L, (long)sourceHistoryActivityInstanceQuery.count());
        Assert.assertEquals((long)0L, (long)targetHistoryActivityInstanceQuery.count());
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        this.runtimeService.newMigration(migrationPlan).processInstanceQuery(sourceProcessInstanceQuery).execute();
        Assert.assertEquals((long)1L, (long)sourceHistoryActivityInstanceQuery.count());
        Assert.assertEquals((long)1L, (long)targetHistoryActivityInstanceQuery.count());
        HistoricActivityInstance instance = (HistoricActivityInstance)targetHistoryActivityInstanceQuery.singleResult();
        this.assertMigratedTo(instance, targetProcessDefinition, "userTask2");
        Assert.assertEquals((Object)"new activity name", (Object)instance.getActivityName());
        Assert.assertEquals((Object)processInstance.getId(), (Object)instance.getParentActivityInstanceId());
        Assert.assertEquals((Object)"userTask", (Object)instance.getActivityType());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoricSubProcessInstance() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(processDefinition.getId(), processDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        List historicInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).unfinished().orderByActivityId().asc()).list();
        Assert.assertEquals((long)2L, (long)historicInstances.size());
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(0), processDefinition, "subProcess");
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(1), processDefinition, "userTask");
        Assert.assertEquals((Object)processInstance.getId(), (Object)((HistoricActivityInstance)historicInstances.get(0)).getParentActivityInstanceId());
        Assert.assertEquals((Object)((HistoricActivityInstance)historicInstances.get(0)).getId(), (Object)((HistoricActivityInstance)historicInstances.get(1)).getParentActivityInstanceId());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoricSubProcessRename() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).changeElementId("subProcess", "newSubProcess"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("subProcess", "newSubProcess").mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        List historicInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).unfinished().orderByActivityId().asc()).list();
        Assert.assertEquals((long)2L, (long)historicInstances.size());
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(0), targetDefinition, "newSubProcess");
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(1), targetDefinition, "userTask");
        Assert.assertEquals((Object)processInstance.getId(), (Object)((HistoricActivityInstance)historicInstances.get(0)).getParentActivityInstanceId());
        Assert.assertEquals((Object)((HistoricActivityInstance)historicInstances.get(0)).getId(), (Object)((HistoricActivityInstance)historicInstances.get(1)).getParentActivityInstanceId());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testHistoricActivityInstanceBecomeScope() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        List historicInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).unfinished().orderByActivityId().asc()).list();
        Assert.assertEquals((long)1L, (long)historicInstances.size());
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(0), targetDefinition, "userTask");
        Assert.assertEquals((Object)processInstance.getId(), (Object)((HistoricActivityInstance)historicInstances.get(0)).getParentActivityInstanceId());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoricActivityInstanceAddScope() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.rule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        List historicInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).unfinished().orderByActivityId().asc()).list();
        Assert.assertEquals((long)2L, (long)historicInstances.size());
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(0), targetDefinition, "subProcess");
        this.assertMigratedTo((HistoricActivityInstance)historicInstances.get(1), targetDefinition, "userTask");
        Assert.assertEquals((Object)processInstance.getId(), (Object)((HistoricActivityInstance)historicInstances.get(0)).getParentActivityInstanceId());
        Assert.assertEquals((Object)((HistoricActivityInstance)historicInstances.get(0)).getId(), (Object)((HistoricActivityInstance)historicInstances.get(1)).getParentActivityInstanceId());
    }

    protected void assertMigratedTo(HistoricActivityInstance activityInstance, ProcessDefinition processDefinition, String activityId) {
        Assert.assertEquals((Object)processDefinition.getId(), (Object)activityInstance.getProcessDefinitionId());
        Assert.assertEquals((Object)processDefinition.getKey(), (Object)activityInstance.getProcessDefinitionKey());
        Assert.assertEquals((Object)activityId, (Object)activityInstance.getActivityId());
    }
}

