/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.Date;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskQueryDisabledStoredExpressionsTest {
    protected static final String EXPECTED_STORED_QUERY_FAILURE_MESSAGE = "Expressions are forbidden in stored queries. This behavior can be toggled in the process engine configuration";
    public static final String STATE_MANIPULATING_EXPRESSION = "${''.getClass().forName('" + TaskQueryDisabledStoredExpressionsTest.class.getName() + "').getField('MUTABLE_FIELD').setLong(null, 42)}";
    public static long MUTABLE_FIELD = 0L;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/api/task/task-query-disabled-stored-expressions-test.camunda.cfg.xml");
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected FilterService filterService;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.filterService = this.engineRule.getFilterService();
        MUTABLE_FIELD = 0L;
    }

    @Test
    public void testStoreFilterWithoutExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfter(new Date());
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(filter);
        Assert.assertEquals((long)1L, (long)this.filterService.createFilterQuery().count());
        this.filterService.deleteFilter(filter.getId());
    }

    @Test
    public void testStoreFilterWithExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfterExpression(STATE_MANIPULATING_EXPRESSION);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        try {
            this.filterService.saveFilter(filter);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
    }

    @Test
    public void testUpdateFilterWithExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfter(new Date());
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(filter);
        filter.setQuery((Query)taskQuery.dueBeforeExpression(STATE_MANIPULATING_EXPRESSION));
        Assert.assertEquals((long)1L, (long)this.filterService.createFilterQuery().count());
        try {
            this.filterService.saveFilter(filter);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
        this.filterService.deleteFilter(filter.getId());
    }

    @Test
    public void testCannotExecuteStoredFilter() {
        TaskQuery filterQuery = this.taskService.createTaskQuery().dueAfterExpression(STATE_MANIPULATING_EXPRESSION);
        String filterId = (String)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            FilterEntity filter = new FilterEntity("Task");
            filter.setQuery((Query)filterQuery);
            filter.setName("filter");
            commandContext.getDbEntityManager().insert((DbEntity)filter);
            return filter.getId();
        });
        this.extendFilterAndValidateFailingQuery(filterId, null);
        this.filterService.deleteFilter(filterId);
    }

    protected boolean fieldIsUnchanged() {
        return MUTABLE_FIELD == 0L;
    }

    protected void extendFilterAndValidateFailingQuery(String filterId, TaskQuery query) {
        try {
            this.filterService.list(filterId, (Query)query);
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
        try {
            this.filterService.count(filterId, (Query)query);
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        Assert.assertTrue((boolean)this.fieldIsUnchanged());
    }
}

