/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.form.CamundaFormRef;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.NativeTaskQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskQueryTest
extends PluggableProcessEngineTest {
    private List<String> taskIds;
    protected static final double MAX_DOUBLE_VALUE = 1.0E125;

    @Before
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.identityService.createMembership("fozzie", "management");
        this.taskIds = this.generateTestTasks();
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
        this.taskService.deleteTasks(this.taskIds, true);
    }

    public void tesBasicTaskPropertiesNotNull() {
        Task task = (Task)this.taskService.createTaskQuery().taskId(this.taskIds.get(0)).singleResult();
        Assert.assertNotNull((Object)task.getDescription());
        Assert.assertNotNull((Object)task.getId());
        Assert.assertNotNull((Object)task.getName());
        Assert.assertNotNull((Object)task.getCreateTime());
    }

    @Test
    public void testQueryNoCriteria() {
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertEquals((long)12L, (long)query.count());
        Assert.assertEquals((long)12L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByTaskId() {
        String taskId = this.taskIds.get(0);
        TaskQuery query = this.taskService.createTaskQuery().taskId(taskId);
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.count());
        List foundTasks = query.list();
        Assert.assertEquals((long)1L, (long)foundTasks.size());
        List foundTaskIds = foundTasks.stream().map(Task::getId).collect(Collectors.toList());
        Assertions.assertThat(foundTaskIds).containsOnly((Object[])new String[]{taskId});
    }

    @Test
    public void testQueryByTaskIdIn() {
        String task0Id = this.taskIds.get(0);
        String task1Id = this.taskIds.get(1);
        TaskQuery query = this.taskService.createTaskQuery().taskIdIn(new String[]{task0Id, task1Id});
        Assert.assertEquals((long)2L, (long)query.count());
        List foundTasks = query.list();
        Assert.assertEquals((long)2L, (long)foundTasks.size());
        List foundTaskIds = foundTasks.stream().map(Task::getId).collect(Collectors.toList());
        Assertions.assertThat(foundTaskIds).containsOnly((Object[])new String[]{task0Id, task1Id});
    }

    @Test
    public void testQueryByInvalidTaskId() {
        TaskQuery query = this.taskService.createTaskQuery().taskId("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskId(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("testTask");
        Assert.assertEquals((long)6L, (long)query.list().size());
        Assert.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByInvalidName() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskNameLike("gonzo\\_%");
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidNameLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskName("1");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskName(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("testTask description");
        Assert.assertEquals((long)6L, (long)query.list().size());
        Assert.assertEquals((long)6L, (long)query.count());
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByInvalidDescription() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescription("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescription(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testTaskQueryLookupByNameCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskName("testTask");
        List tasks = query.list();
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((int)tasks.size()).isEqualTo(6);
        query = this.taskService.createTaskQuery();
        query.taskName("TeStTaSk");
        tasks = query.list();
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((int)tasks.size()).isEqualTo(6);
    }

    @Test
    public void testTaskQueryLookupByNameLikeCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("%task%");
        List tasks = query.list();
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((int)tasks.size()).isEqualTo(10);
        query = this.taskService.createTaskQuery();
        query.taskNameLike("%Task%");
        tasks = query.list();
        Assert.assertNotNull((Object)tasks);
        Assertions.assertThat((int)tasks.size()).isEqualTo(10);
    }

    @Test
    public void testQueryByDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("%gonzo\\_%");
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidDescriptionLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskDescriptionLike("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.taskService.createTaskQuery().taskDescriptionLike(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByPriority() {
        TaskQuery query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(10));
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(100));
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(50));
        Assert.assertEquals((long)3L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(10));
        Assert.assertEquals((long)5L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(10));
        Assert.assertEquals((long)9L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskMaxPriority(Integer.valueOf(3));
        Assert.assertEquals((long)6L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(50)).taskMaxPriority(Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskPriority(Integer.valueOf(30)).taskMaxPriority(Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(30)).taskPriority(Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskMinPriority(Integer.valueOf(30)).taskPriority(Integer.valueOf(20)).taskMaxPriority(Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryByInvalidPriority() {
        try {
            this.taskService.createTaskQuery().taskPriority(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByAssignee() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee("gonzo_");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("kermit");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Test
    public void testQueryByAssigneeLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeLike("gonz%\\_");
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
        query = this.taskService.createTaskQuery().taskAssignee("gonz");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertNull((Object)query.singleResult());
    }

    @Test
    public void testQueryByNullAssignee() {
        try {
            this.taskService.createTaskQuery().taskAssignee(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByAssigneeInPositive() {
        String[] assignees = new String[]{"fozzie", "john", "mary"};
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeIn(assignees);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigneeInNegative() {
        String[] assignees = new String[]{"kermit", "gonzo"};
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeIn(assignees);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigneeAndAssigneeIn() {
        String assignee = "fozzie";
        String[] assignees = new String[]{"fozzie", "john", "mary"};
        TaskQuery query = this.taskService.createTaskQuery().taskAssignee(assignee).taskAssigneeIn(assignees);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigneeInNull() {
        String[] assignees = null;
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.taskAssigneeIn(assignees);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"Assignees is null", (Object)ex.getMessage());
        }
    }

    @Test
    public void testQueryByAssigneeNotInPositive() {
        String[] assignees = new String[]{"fozzie", "john", "mary"};
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeNotIn(assignees);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigneeNotInNegative() {
        String[] assignees = new String[]{"gonzo_", "fozzie"};
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeNotIn(assignees);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigneeInAndAssigneeNotIn() {
        String[] assigneesIn = new String[]{"fozzie", "gonzo"};
        String[] assigneesNotIn = new String[]{"john", "mary"};
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeIn(assigneesIn).taskAssigneeNotIn(assigneesNotIn);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigneeNotInNull() {
        String[] assignees = null;
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.taskAssigneeNotIn(assignees);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"Assignees is null", (Object)ex.getMessage());
        }
    }

    @Test
    public void testQueryByUnassigned() {
        TaskQuery query = this.taskService.createTaskQuery().taskUnassigned();
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertEquals((long)10L, (long)query.list().size());
    }

    @Test
    public void testQueryByAssigned() {
        TaskQuery query = this.taskService.createTaskQuery().taskAssigned();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
    }

    @Test
    public void testQueryByCandidateUser() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertEquals((long)10L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateUser("kermit").includeAssignedTasks();
        Assert.assertEquals((long)12L, (long)query.count());
        Assert.assertEquals((long)12L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateUser("fozzie");
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateUser("fozzie").includeAssignedTasks();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateUser("gonzo");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateUser("gonzo").includeAssignedTasks();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testQueryByNullCandidateUser() {
        try {
            this.taskService.createTaskQuery().taskCandidateUser(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByIncludeAssignedTasksWithMissingCandidateUserOrGroup() {
        try {
            this.taskService.createTaskQuery().includeAssignedTasks();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCandidateGroup() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroup("management");
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroup("management").includeAssignedTasks();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("accountancy");
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("accountancy").includeAssignedTasks();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("sales");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroup("sales").includeAssignedTasks();
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryWithCandidateGroups() {
        TaskQuery query = this.taskService.createTaskQuery().withCandidateGroups();
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)query.list().size());
        Assert.assertEquals((long)5L, (long)query.includeAssignedTasks().count());
        Assert.assertEquals((long)5L, (long)query.includeAssignedTasks().list().size());
    }

    @Test
    public void testQueryWithoutCandidateGroups() {
        TaskQuery query = this.taskService.createTaskQuery().withoutCandidateGroups();
        Assert.assertEquals((long)6L, (long)query.count());
        Assert.assertEquals((long)6L, (long)query.list().size());
        Assert.assertEquals((long)7L, (long)query.includeAssignedTasks().count());
        Assert.assertEquals((long)7L, (long)query.includeAssignedTasks().list().size());
    }

    @Test
    public void shouldQueryWithoutCandidateGroupsAndUsers() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskIds.add(task.getId());
        TaskQuery query = this.taskService.createTaskQuery().withoutCandidateGroups().withoutCandidateUsers();
        Assertions.assertThat((List)query.list()).extracting("id").containsExactly(new Object[]{task.getId()});
    }

    @Test
    public void testQueryByNullCandidateGroup() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroup(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByCandidateGroupIn() {
        List<String> groups = Arrays.asList("management", "accountancy");
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).includeAssignedTasks();
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertEquals((long)5L, (long)query.list().size());
        groups = Arrays.asList("management", "accountancy", "sales", "unexising");
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups);
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).includeAssignedTasks();
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertEquals((long)5L, (long)query.list().size());
    }

    @Test
    public void testQueryByCandidateGroupInAndCandidateGroup() {
        List<String> groups = Arrays.asList("management", "accountancy");
        String candidateGroup = "management";
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup(candidateGroup);
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup(candidateGroup).includeAssignedTasks();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        groups = Arrays.asList("management", "accountancy", "sales", "unexising");
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup(candidateGroup);
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup(candidateGroup).includeAssignedTasks();
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup("sales");
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup("sales").includeAssignedTasks();
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryByCandidateGroupInAndCandidateGroupNotIntersected() {
        List<String> groups = Arrays.asList("accountancy");
        String candidateGroup = "management";
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateGroupIn(groups).taskCandidateGroup(candidateGroup);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryByNullCandidateGroupIn() {
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskCandidateGroupIn(new ArrayList()).list();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByDelegationState() {
        TaskQuery query = this.taskService.createTaskQuery().taskDelegationState(null);
        Assert.assertEquals((long)12L, (long)query.count());
        Assert.assertEquals((long)12L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        String taskId = ((Task)this.taskService.createTaskQuery().taskAssignee("gonzo_").singleResult()).getId();
        this.taskService.delegateTask(taskId, "kermit");
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        Assert.assertEquals((long)11L, (long)query.count());
        Assert.assertEquals((long)11L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        this.taskService.resolveTask(taskId);
        query = this.taskService.createTaskQuery().taskDelegationState(null);
        Assert.assertEquals((long)11L, (long)query.count());
        Assert.assertEquals((long)11L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.PENDING);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
        query = this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }

    @Test
    public void testQueryCreatedOn() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date createTime = sdf.parse("01/01/2001 01:01:01.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedOn(createTime);
        Assert.assertEquals((long)6L, (long)query.count());
        Assert.assertEquals((long)6L, (long)query.list().size());
    }

    @Test
    public void testQueryCreatedBefore() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date before = sdf.parse("03/02/2002 02:02:02.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        Assert.assertEquals((long)7L, (long)query.count());
        Assert.assertEquals((long)7L, (long)query.list().size());
        before = sdf.parse("01/01/2001 01:01:01.000");
        query = this.taskService.createTaskQuery().taskCreatedBefore(before);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testQueryCreatedAfter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date after = sdf.parse("03/03/2003 03:03:03.000");
        TaskQuery query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
        after = sdf.parse("05/05/2005 05:05:05.000");
        query = this.taskService.createTaskQuery().taskCreatedAfter(after);
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testCreateTimeCombinations() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        Date createTime = sdf.parse("01/01/2001 01:01:01.000");
        Date oneHourAgo = new Date(createTime.getTime() - 3600000L);
        Date oneHourLater = new Date(createTime.getTime() + 3600000L);
        Assert.assertEquals((long)6L, (long)this.taskService.createTaskQuery().taskCreatedAfter(oneHourAgo).taskCreatedOn(createTime).taskCreatedBefore(oneHourLater).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCreatedAfter(oneHourLater).taskCreatedOn(createTime).taskCreatedBefore(oneHourAgo).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCreatedAfter(oneHourLater).taskCreatedOn(createTime).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCreatedOn(createTime).taskCreatedBefore(oneHourAgo).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    @Test
    public void testTaskDefinitionKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("taskKey_1").list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_1", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKey("unexistingKey").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    @Test
    public void testTaskDefinitionKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("taskKey\\_1%").orderByTaskName().asc()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_1", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        Assert.assertEquals((Object)"taskKey_123", (Object)((Task)tasks.get(1)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%\\_123").orderByTaskName().asc()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_123", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyLike("%Key\\_12%").orderByTaskName().asc()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_123", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKeyLike("%unexistingKey%").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml"})
    @Test
    public void testTaskDefinitionKeyIn() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        List tasks = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"taskKey_1"}).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_1", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"taskKey_1", "taskKey_123"}).orderByTaskName().asc()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_1", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        Assert.assertEquals((Object)"taskKey_123", (Object)((Task)tasks.get(1)).getTaskDefinitionKey());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"taskKey_1", "taskKey_123", "unexistingKey"}).orderByTaskName().asc()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"taskKey_1", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        Assert.assertEquals((Object)"taskKey_123", (Object)((Task)tasks.get(1)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{"unexistingKey"}).count();
        Assert.assertEquals((long)0L, (long)count);
        count = this.taskService.createTaskQuery().taskDefinitionKey("unexistingKey").taskDefinitionKeyIn(new String[]{"taskKey1"}).count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskVariableNameEqualsIgnoreCase() throws Exception {
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), variableName, (Object)variableValue);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).matchVariableNamesIgnoreCase().count());
    }

    @Deployment
    @Test
    public void testTaskVariableValueEquals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("unexistingVar", (Object)"value").count());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)999L).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)999).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)999).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"999").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", (Object)"999").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("longVar", (Object)999L).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("shortVar", (Object)999).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("integerVar", (Object)999).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("stringVar", (Object)"999").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals("booleanVar", (Object)false).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    @Test
    public void testTaskVariableValueEqualsIgnoreCase() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        this.taskService.setVariableLocal(task.getId(), variableName, (Object)variableValue);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName, (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nonExistentVariable", (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueEquals("nonExistentVariable", (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName, (Object)"nonExistentValue").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName, (Object)"nonExistentValue".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).matchVariableValuesIgnoreCase().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskVariableValueNameEqualsIgnoreCase() throws Exception {
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), variableName, (Object)variableValue);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).matchVariableNamesIgnoreCase().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    @Test
    public void testTaskVariableValueLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.taskService.setVariablesLocal(task.getId(), variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal%").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngValue").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVal%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVar%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "%ngVar%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueLike("stringVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    @Test
    public void testTaskVariableValueLikeIgnoreCase() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.taskService.setVariablesLocal(task.getId(), variables);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "%ngValue".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "%ngVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "stringVar%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "%ngVar".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "%ngVar%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("stringVar", "stringVal".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike("nonExistingVar", "stringVal%".toLowerCase()).count());
        try {
            this.taskService.createTaskQuery().taskVariableValueLike("stringVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    @Test
    public void testTaskVariableValueCompare() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928373).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928375).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("numericVar", (Object)928373).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)before).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)after).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThan("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThan("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThan("nullVar", (Object)true).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThan("nullVar", (Object)true).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment
    @Test
    public void testProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", null).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)999L).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("shortVar", (Object)999).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("integerVar", (Object)999).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("stringVar", (Object)"999").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nullVar", (Object)"999").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("longVar", (Object)928374L).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("nullVar", null).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)999L).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("shortVar", (Object)999).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("integerVar", (Object)999).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("stringVar", (Object)"999").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("booleanVar", (Object)false).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("longVar", (Object)928374L).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"theValue");
        this.taskService.setVariableLocal(task.getId(), "longVar", (Object)928374L);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("taskVar", (Object)"theValue").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("longVar", (Object)928374L).taskVariableValueEquals("longVar", (Object)928374L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableNameEqualsIgnoreCase() throws Exception {
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).matchVariableNamesIgnoreCase().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testTaskVariableValueEquals.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEqualsIgnoreCase() throws Exception {
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals(variableName, (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("nonExistentVariable", (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals("nonExistentVariable", (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals(variableName, (Object)"nonExistentValue").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)"nonExistentValue".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal%").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngValue").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVal%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVar%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "%ngVar%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.taskService.createTaskQuery().processVariableValueLike("stringVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLikeIgnoreCase() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngValue".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "stringVar%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngVar".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngVar%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "stringVal".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("nonExistingVar", "stringVal%".toLowerCase()).count());
        try {
            this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    @Test
    public void testProcessVariableValueNotLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "stringVal%").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "%ngValue").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "%ngVal%").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "stringVar%").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "%ngVar").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "%ngVar%").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "stringVal").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("nonExistingVar", "string%").count());
        Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", null).count()).isInstanceOf(ProcessEngineException.class);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    @Test
    public void testProcessVariableValueNotLikeIgnoreCase() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueNotLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngValue".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "stringVar%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngVar".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngVar%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "stringVal".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("nonExistingVar", "stringVal%".toLowerCase()).count());
        Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", null).count()).isInstanceOf(ProcessEngineException.class);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessVariableValueEquals.bpmn20.xml"})
    @Test
    public void testProcessVariableValueCompare() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928373).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928375).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("numericVar", (Object)928373).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)before).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)after).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThan("nullVar", (Object)true).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThan("nullVar", (Object)true).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueNumberComparison() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().processVariableValueGreaterThanOrEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().processVariableValueLessThanOrEquals("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTaskVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        Assert.assertEquals((long)8L, (long)tasks.size());
        this.taskService.setVariableLocal(((Task)tasks.get(0)).getId(), "var", (Object)123L);
        this.taskService.setVariableLocal(((Task)tasks.get(1)).getId(), "var", (Object)12345L);
        this.taskService.setVariableLocal(((Task)tasks.get(2)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(3)).getId(), "var", (Object)123.0);
        this.taskService.setVariableLocal(((Task)tasks.get(4)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(5)).getId(), "var", null);
        this.taskService.setVariableLocal(((Task)tasks.get(6)).getId(), "var", (Object)Variables.longValue(null));
        this.taskService.setVariableLocal(((Task)tasks.get(7)).getId(), "var", (Object)"123");
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableEqualsNumberMax() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 1.0E125));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)1.0E125)).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)Long.MAX_VALUE)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableEqualsNumberLongValueOverflow() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 1.0E125));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)1.0E125)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableEqualsNumberNonIntegerDoubleShouldNotMatchInteger() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)42).putValue("var2", (Object)52.4));
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)42.4)).count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42.4));
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)52)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessDefinitionId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionId(processInstance.getProcessDefinitionId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionId("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessDefinitionKey() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionKey("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/taskDefinitionProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionKeyIn() throws Exception {
        this.runtimeService.startProcessInstanceByKey("taskDefinitionKeyProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess"}).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"theTask", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess", "taskDefinitionKeyProcess"}).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        HashSet<String> keysFound = new HashSet<String>();
        for (Task task : tasks) {
            keysFound.add(task.getTaskDefinitionKey());
        }
        Assert.assertTrue((boolean)keysFound.contains("taskKey_123"));
        Assert.assertTrue((boolean)keysFound.contains("theTask"));
        Assert.assertTrue((boolean)keysFound.contains("taskKey_1"));
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess", "NonExistingKey"}).orderByTaskName().asc()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"theTask", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        Long count = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"NonExistingKey"}).count();
        Assert.assertEquals((long)0L, (long)count);
        count = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{"oneTaskProcess"}).processDefinitionKey("NonExistingKey").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessDefinitionName() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionName("The%One%Task%Process").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionName("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessDefinitionNameLike() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionNameLike("The\\%One\\%Task%").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The One Task").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processDefinitionNameLike("The Other Task%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessInstanceBusinessKey() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processDefinitionName("The%One%Task%Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKey("NON-EXISTING").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessInstanceBusinessKeyIn() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-2");
        List tasks = this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1"}).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"theTask", (Object)((Task)tasks.get(0)).getTaskDefinitionKey());
        tasks = this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1", "BUSINESS-KEY-2"}).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            Assert.assertEquals((Object)"theTask", (Object)task.getTaskDefinitionKey());
        }
        Task task = (Task)this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1", "NON-EXISTING-KEY"}).singleResult();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((Object)"theTask", (Object)task.getTaskDefinitionKey());
        long count = this.taskService.createTaskQuery().processInstanceBusinessKeyIn(new String[]{"BUSINESS-KEY-1"}).processInstanceBusinessKey("NON-EXISTING-KEY").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testProcessInstanceBusinessKeyLike() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "BUSINESS-KEY-1");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processDefinitionName("The%One%Task%Process").processInstanceBusinessKey("BUSINESS-KEY-1").list().size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY%").list().size());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUSINESS-KEY").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceBusinessKeyLike("BUZINESS-KEY%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testTaskDueDate() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueDate(dueDate).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueDate(otherDate.getTime()).count());
        Calendar priorDate = Calendar.getInstance();
        priorDate.setTime(dueDate);
        priorDate.roll(1, -1);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(priorDate.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(otherDate.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testTaskDueBefore() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourLater.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueBefore(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testTaskDueAfter() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Calendar dueDateCal = Calendar.getInstance();
        task.setDueDate(dueDateCal.getTime());
        this.taskService.saveTask(task);
        Calendar oneHourAgo = Calendar.getInstance();
        oneHourAgo.setTime(dueDateCal.getTime());
        oneHourAgo.add(10, -1);
        Calendar oneHourLater = Calendar.getInstance();
        oneHourLater.setTime(dueDateCal.getTime());
        oneHourLater.add(10, 1);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(null);
        this.taskService.saveTask(task);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo.getTime()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testTaskDueDateCombinations() throws ParseException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setDueDate(dueDate);
        this.taskService.saveTask(task);
        Date oneHourAgo = new Date(dueDate.getTime() - 3600000L);
        Date oneHourLater = new Date(dueDate.getTime() + 3600000L);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().dueAfter(oneHourAgo).dueDate(dueDate).dueBefore(oneHourLater).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater).dueDate(dueDate).dueBefore(oneHourAgo).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueAfter(oneHourLater).dueDate(dueDate).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().dueDate(dueDate).dueBefore(oneHourAgo).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void shouldQueryForTasksWithoutDueDate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setDueDate(ClockUtil.now());
        this.taskService.saveTask(task);
        Assert.assertEquals((long)12L, (long)this.taskService.createTaskQuery().withoutDueDate().count());
    }

    @Test
    public void shouldRejectDueDateAndWithoutDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().dueDate(ClockUtil.now()).withoutDueDate()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectWithoutDueDateAndDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().withoutDueDate().dueDate(ClockUtil.now())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectDueBeforeAndWithoutDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().dueBefore(ClockUtil.now()).withoutDueDate()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectWithoutDueDateAndDueBeforeCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().withoutDueDate().dueBefore(ClockUtil.now())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectDueAfterAndWithoutDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().dueAfter(ClockUtil.now()).withoutDueDate()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectWithoutDueDateAndDueAfterCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().withoutDueDate().dueAfter(ClockUtil.now())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testFollowUpDate() throws Exception {
        Calendar otherDate = Calendar.getInstance();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).followUpBeforeOrNotExistent(otherDate.getTime()).count());
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date followUpDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(followUpDate);
        this.taskService.saveTask(task);
        Assert.assertEquals((Object)followUpDate, (Object)((Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult()).getFollowUpDate());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpDate(followUpDate).count());
        otherDate.setTime(followUpDate);
        otherDate.add(1, 1);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(otherDate.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).followUpBeforeOrNotExistent(otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        otherDate.add(1, -2);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpAfter(otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpBefore(otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).followUpBeforeOrNotExistent(otherDate.getTime()).count());
        this.taskService.complete(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testFollowUpDateCombinations() throws ParseException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date dueDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/02/2003 01:12:13");
        task.setFollowUpDate(dueDate);
        this.taskService.saveTask(task);
        Date oneHourAgo = new Date(dueDate.getTime() - 3600000L);
        Date oneHourLater = new Date(dueDate.getTime() + 3600000L);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().followUpAfter(oneHourAgo).followUpDate(dueDate).followUpBefore(oneHourLater).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(oneHourLater).followUpDate(dueDate).followUpBefore(oneHourAgo).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpAfter(oneHourLater).followUpDate(dueDate).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().followUpDate(dueDate).followUpBefore(oneHourAgo).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryByActivityInstanceId() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String activityInstanceId = this.runtimeService.getActivityInstance(processInstance.getId()).getChildActivityInstances()[0].getId();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryByMultipleActivityInstanceIds() throws Exception {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String activityInstanceId1 = this.runtimeService.getActivityInstance(processInstance1.getId()).getChildActivityInstances()[0].getId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String activityInstanceId2 = this.runtimeService.getActivityInstance(processInstance2.getId()).getChildActivityInstances()[0].getId();
        List result1 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1}).list();
        Assert.assertEquals((long)1L, (long)result1.size());
        Assert.assertEquals((Object)processInstance1.getId(), (Object)((Task)result1.get(0)).getProcessInstanceId());
        List result2 = this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId2}).list();
        Assert.assertEquals((long)1L, (long)result2.size());
        Assert.assertEquals((Object)processInstance2.getId(), (Object)((Task)result2.get(0)).getProcessInstanceId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{activityInstanceId1, activityInstanceId2}).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryByInvalidActivityInstanceId() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{"anInvalidActivityInstanceId"}).list().size());
    }

    @Test
    public void testQueryPaging() {
        TaskQuery query = this.taskService.createTaskQuery().taskCandidateUser("kermit");
        Assert.assertEquals((long)10L, (long)query.listPage(0, Integer.MAX_VALUE).size());
        Assert.assertEquals((long)10L, (long)query.count());
        Assert.assertEquals((long)10L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.listPage(0, 2).size());
        Assert.assertEquals((long)2L, (long)query.listPage(2, 2).size());
        Assert.assertEquals((long)3L, (long)query.listPage(4, 3).size());
        Assert.assertEquals((long)1L, (long)query.listPage(9, 3).size());
        Assert.assertEquals((long)1L, (long)query.listPage(9, 1).size());
        Assert.assertEquals((long)0L, (long)query.listPage(-1, -1).size());
        Assert.assertEquals((long)0L, (long)query.listPage(10, 2).size());
        Assert.assertEquals((long)10L, (long)query.listPage(0, 15).size());
    }

    @Test
    public void testQuerySorting() {
        int expectedCount = 12;
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery(), expectedCount, TestOrderingUtil.taskById());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().asc(), expectedCount, TestOrderingUtil.taskById());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskName().asc(), expectedCount, TestOrderingUtil.taskByName());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskPriority().asc(), expectedCount, TestOrderingUtil.taskByPriority());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskAssignee().asc(), expectedCount, TestOrderingUtil.taskByAssignee());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskDescription().asc(), expectedCount, TestOrderingUtil.taskByDescription());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByProcessInstanceId().asc(), expectedCount, TestOrderingUtil.taskByProcessInstanceId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByExecutionId().asc(), expectedCount, TestOrderingUtil.taskByExecutionId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskCreateTime().asc(), expectedCount, TestOrderingUtil.taskByCreateTime());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByDueDate().asc(), expectedCount, TestOrderingUtil.taskByDueDate());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByFollowUpDate().asc(), expectedCount, TestOrderingUtil.taskByFollowUpDate());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseInstanceId().asc(), expectedCount, TestOrderingUtil.taskByCaseInstanceId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseExecutionId().asc(), expectedCount, TestOrderingUtil.taskByCaseExecutionId());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskById()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskName().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByName()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskPriority().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByPriority()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskAssignee().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByAssignee()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskDescription().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByDescription()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByProcessInstanceId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByProcessInstanceId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByExecutionId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByExecutionId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskCreateTime().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByCreateTime()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByDueDate().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByDueDate()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByFollowUpDate().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByFollowUpDate()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseInstanceId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByCaseInstanceId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByCaseExecutionId().desc(), expectedCount, TestOrderingUtil.inverted(TestOrderingUtil.taskByCaseExecutionId()));
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").asc(), 6, TestOrderingUtil.taskById());
        TestOrderingUtil.verifySortingAndCount(this.taskService.createTaskQuery().orderByTaskId().taskName("testTask").desc(), 6, TestOrderingUtil.inverted(TestOrderingUtil.taskById()));
    }

    @Test
    public void testQuerySortingByNameShouldBeCaseInsensitive() {
        Task task = this.taskService.newTask("caseSensitiveTestTask");
        task.setName("CaseSensitiveTestTask");
        this.taskService.saveTask(task);
        Filter filter = this.filterService.newTaskFilter("taskNameOrdering");
        this.filterService.saveFilter(filter);
        List<String> sortedNames = this.getTaskNamesFromTasks(this.taskService.createTaskQuery().list());
        Collections.sort(sortedNames, String.CASE_INSENSITIVE_ORDER);
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().orderByTaskNameCaseInsensitive().asc();
        List<String> ascNames = this.getTaskNamesFromTasks(taskQuery.list());
        Assert.assertEquals(sortedNames, ascNames);
        ascNames = this.getTaskNamesFromTasks(this.filterService.list(filter.getId(), (Query)taskQuery));
        Assert.assertEquals(sortedNames, ascNames);
        Collections.reverse(sortedNames);
        taskQuery = (TaskQuery)this.taskService.createTaskQuery().orderByTaskNameCaseInsensitive().desc();
        List<String> descNames = this.getTaskNamesFromTasks(taskQuery.list());
        Assert.assertEquals(sortedNames, descNames);
        descNames = this.getTaskNamesFromTasks(this.filterService.list(filter.getId(), (Query)taskQuery));
        Assert.assertEquals(sortedNames, descNames);
        this.taskService.deleteTask(task.getId(), true);
        this.filterService.deleteFilter(filter.getId());
    }

    @Test
    public void testQueryOrderByTaskName() {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)12L, (long)tasks.size());
        List<String> taskNames = this.getTaskNamesFromTasks(tasks);
        Assert.assertEquals((Object)"accountancy description", (Object)taskNames.get(0));
        Assert.assertEquals((Object)"accountancy description", (Object)taskNames.get(1));
        Assert.assertEquals((Object)"gonzo_Task", (Object)taskNames.get(2));
        Assert.assertEquals((Object)"managementAndAccountancyTask", (Object)taskNames.get(3));
        Assert.assertEquals((Object)"managementTask", (Object)taskNames.get(4));
        Assert.assertEquals((Object)"managementTask", (Object)taskNames.get(5));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(6));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(7));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(8));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(9));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(10));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(11));
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        Assert.assertEquals((long)12L, (long)tasks.size());
        taskNames = this.getTaskNamesFromTasks(tasks);
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(0));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(1));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(2));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(3));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(4));
        Assert.assertEquals((Object)"testTask", (Object)taskNames.get(5));
        Assert.assertEquals((Object)"managementTask", (Object)taskNames.get(6));
        Assert.assertEquals((Object)"managementTask", (Object)taskNames.get(7));
        Assert.assertEquals((Object)"managementAndAccountancyTask", (Object)taskNames.get(8));
        Assert.assertEquals((Object)"gonzo_Task", (Object)taskNames.get(9));
        Assert.assertEquals((Object)"accountancy description", (Object)taskNames.get(10));
        Assert.assertEquals((Object)"accountancy description", (Object)taskNames.get(11));
    }

    public List<String> getTaskNamesFromTasks(List<Task> tasks) {
        ArrayList<String> names = new ArrayList<String>();
        for (Task task : tasks) {
            names.add(task.getName());
        }
        return names;
    }

    @Test
    public void testNativeQuery() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_TASK"), (Object)this.managementService.getTableName(Task.class));
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_TASK"), (Object)this.managementService.getTableName(TaskEntity.class));
        Assert.assertEquals((long)12L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).list().size());
        Assert.assertEquals((long)12L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class))).count());
        Assert.assertEquals((long)144L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + tablePrefix + "ACT_RU_TASK T1, " + tablePrefix + "ACT_RU_TASK T2")).count());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).count());
        List tasks = ((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT T1.* FROM " + this.managementService.getTableName(Task.class) + " T1, " + this.managementService.getTableName(VariableInstanceEntity.class) + " V1 WHERE V1.TASK_ID_ = T1.ID_")).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"gonzo_Task", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((long)12L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT DISTINCT T1.* FROM " + tablePrefix + "ACT_RU_TASK T1")).list().size());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzo_Task'")).count());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = 'gonzo_Task'")).list().size());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Task.class) + " T WHERE T.NAME_ = #{taskName}")).parameter("taskName", (Object)"gonzo_Task")).count());
    }

    @Test
    public void testNativeQueryPaging() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_TASK"), (Object)this.managementService.getTableName(Task.class));
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_TASK"), (Object)this.managementService.getTableName(TaskEntity.class));
        Assert.assertEquals((long)5L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(0, 5).size());
        Assert.assertEquals((long)2L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Task.class))).listPage(10, 12).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionKey() {
        String caseDefinitionKey = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getKey();
        this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionKey(caseDefinitionKey);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionKey() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseDefinitionName() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        String caseDefinitionId = caseDefinition.getId();
        String caseDefinitionName = caseDefinition.getName();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionName(caseDefinitionName);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionName() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionName(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/repository/three_.cmmn"})
    @Test
    public void testQueryByCaseDefinitionNameLike() {
        List<String> caseDefinitionIds = this.getCaseDefinitionIds();
        for (String caseDefinitionId : caseDefinitionIds) {
            this.caseService.withCaseDefinition(caseDefinitionId).create();
        }
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionNameLike("One T%");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%Task Case");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%Task%");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionNameLike("%z\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionNameLike() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseDefinitionNameLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionNameLike(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseInstanceId() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testQueryByCaseInstanceIdHierarchy.cmmn", "org/camunda/bpm/engine/test/api/task/TaskQueryTest.testQueryByCaseInstanceIdHierarchy.bpmn20.xml"})
    @Test
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 2);
        for (Task task : query.list()) {
            Assert.assertEquals((Object)caseInstanceId, (Object)task.getCaseInstanceId());
            this.taskService.complete(task.getId());
        }
        this.verifyQueryResults(query, 1);
        Assert.assertEquals((Object)caseInstanceId, (Object)((Task)query.singleResult()).getCaseInstanceId());
        this.taskService.complete(((Task)query.singleResult()).getId());
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseInstanceBusinessKey() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String businessKey = "aBusinessKey";
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKey(businessKey);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseInstanceBusinessKey() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByCaseInstanceBusinessKeyLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String businessKey = "aBusiness_Key";
        this.caseService.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKeyLike("aBus%");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%siness\\_Key");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%sines%");
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKeyLike("%sines%");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseInstanceBusinessKeyLike() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceBusinessKeyLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKeyLike(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String humanTaskExecutionId = this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseExecutionId(humanTaskExecutionId);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidCaseExecutionId() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseExecutionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseExecutionId(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseInstanceVariableNameEqualsIgnoreCase() throws Exception {
        String caseDefinitionId = this.getCaseDefinitionId();
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable(variableName, (Object)variableValue).create();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).matchVariableNamesIgnoreCase().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueEqualsIgnoreCase() {
        String caseDefinitionId = this.getCaseDefinitionId();
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable(variableName, (Object)variableValue).create();
        TaskQuery query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals(variableName, (Object)variableValue.toLowerCase());
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery().caseInstanceVariableValueEquals(variableName, (Object)variableValue.toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals("nonExistingVariable", (Object)variableValue.toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals(variableName, (Object)"nonExistentValue".toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().caseInstanceVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase());
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByBooleanCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByShortCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByIntegerCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByLongCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDateCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDoubleCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySerializableCaseInstanceVariableValueEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByFileCaseInstanceVariableValueEquals() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueEquals(variableName, (Object)fileValue).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Variables of type File cannot be used to query"});
        }
    }

    protected void startDefaultCaseWithVariable(Object variableValue, String variableName) {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.createCaseWithVariable(caseDefinitionId, variableValue, variableName);
    }

    protected String getCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        return caseDefinitionId;
    }

    protected List<String> getCaseDefinitionIds() {
        ArrayList<String> caseDefinitionIds = new ArrayList<String>();
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().list();
        for (CaseDefinition caseDefinition : caseDefinitions) {
            caseDefinitionIds.add(caseDefinition.getId());
        }
        return caseDefinitionIds;
    }

    protected void createCaseWithVariable(String caseDefinitionId, Object variableValue, String variableName) {
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable(variableName, variableValue).create();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByBooleanCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByShortCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByIntegerCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByLongCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDateCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDoubleCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByFileCaseInstanceVariableValueNotEquals() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals(variableName, (Object)fileValue).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Variables of type File cannot be used to query"});
        }
    }

    protected FileValue createDefaultFileValue() {
        FileValue fileValue = (FileValue)Variables.fileValue((String)"tst.txt").file("somebytes".getBytes()).create();
        return fileValue;
    }

    protected String startDefaultCaseExecutionManually() {
        String humanTaskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskExecutionId).manualStart();
        return humanTaskExecutionId;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySerializableCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueNotEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByShortCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByLongCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDateCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        TaskQuery query = this.taskService.createTaskQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySerializableCaseInstanceVariableGreaterThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testQueryByFileCaseInstanceVariableValueGreaterThan() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        this.startDefaultCaseExecutionManually();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThan(variableName, (Object)fileValue).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Variables of type File cannot be used to query"});
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByBooleanCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByShortCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByIntegerCaseInstanceVariableValueGreaterThanOrEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByLongCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDateCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        TaskQuery query = this.taskService.createTaskQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThanOrEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDoubleCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueGreaterThanOrEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySerializableCaseInstanceVariableGreaterThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByFileCaseInstanceVariableValueGreaterThanOrEqual() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEquals(variableName, (Object)fileValue).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Variables of type File cannot be used to query"});
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByBooleanCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByShortCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByIntegerCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByLongCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDateCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        TaskQuery query = this.taskService.createTaskQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDoubleCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySerializableCaseInstanceVariableLessThan() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByFileCaseInstanceVariableValueLessThan() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThan(variableName, (Object)fileValue).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Variables of type File cannot be used to query"});
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByBooleanCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aBooleanValue", (Object)true).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aBooleanValue", (Object)false).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByShortCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aShortValue", (Object)123).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByIntegerCaseInstanceVariableValueLessThanOrEquals() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("anIntegerValue", (Object)456).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByLongCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aLongValue", (Object)789L).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDateCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        Date now = new Date();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDateValue", (Object)now).create();
        TaskQuery query = this.taskService.createTaskQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThanOrEquals("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByDoubleCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aDoubleValue", (Object)1.5).create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLessThanOrEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByByteArrayCaseInstanceVariableValueLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aByteArrayValue", (Object)bytes).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aByteArrayValue", (Object)bytes).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryBySerializableCaseInstanceVariableLessThanOrEqual() {
        String caseDefinitionId = this.getCaseDefinitionId();
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aSerializableValue", serializable).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals("aSerializableValue", serializable).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByFileCaseInstanceVariableValueLessThanOrEqual() {
        FileValue fileValue = this.createDefaultFileValue();
        String variableName = "aFileValue";
        this.startDefaultCaseWithVariable(fileValue, variableName);
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEquals(variableName, (Object)fileValue).list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Variables of type File cannot be used to query"});
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueLike("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByNullCaseInstanceVariableValueNotLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aNullValue", null).create();
        TaskQuery query = this.taskService.createTaskQuery();
        try {
            query.caseInstanceVariableValueNotLike("aNullValue", null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueLikeIgnoreCase() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringVariable", (Object)"aStringValue").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueLike("aStringVariable", "aString%".toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueLike("aStringVariable", "aString%".toLowerCase());
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueNotLike() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringValue", (Object)"abc").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringValue", "abc%");
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringValue", "abx%");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringValue", "%be");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringValue", "abd");
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("nonExistingVar", "%b%");
        this.verifyQueryResults(query, 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryByStringCaseInstanceVariableValueNotLikeIgnoreCase() {
        String caseDefinitionId = this.getCaseDefinitionId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aStringVariable", (Object)"aStringValue").create();
        TaskQuery query = this.taskService.createTaskQuery();
        query.caseInstanceVariableValueNotLike("aStringVariable", "aString%".toLowerCase());
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "aString%".toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "%ringValue".toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "%ngVal%".toLowerCase());
        this.verifyQueryResults(query, 0);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "aStrong%".toLowerCase());
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "%Strong".toLowerCase());
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "%ngVar%".toLowerCase());
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("aStringVariable", "stringVal".toLowerCase());
        this.verifyQueryResults(query, 1);
        query = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotLike("nonExistingVar", "%String%".toLowerCase());
        this.verifyQueryResults(query, 0);
    }

    @Deployment
    @Test
    public void testQueryByVariableInParallelBranch() throws Exception {
        this.runtimeService.startProcessInstanceByKey("parallelGateway");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)12345L);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "var", (Object)12345);
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)12345).count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().processVariableValueEquals("var", (Object)12345L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByProcessVariables() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).desc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        List unorderedTasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        Assert.assertEquals((long)3L, (long)unorderedTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testLocalExecutionVariable.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByExecutionVariables() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("parallelGateway", Collections.singletonMap("var", "aValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("parallelGateway", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("parallelGateway", Collections.singletonMap("var", "cValue"));
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.runtimeService.setVariableLocal(task1.getExecutionId(), "var", (Object)"cValue");
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.runtimeService.setVariableLocal(task2.getExecutionId(), "var", (Object)"bValue");
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.runtimeService.setVariableLocal(task3.getExecutionId(), "var", (Object)"aValue");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("parallelGateway").orderByExecutionVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByTaskVariables() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "var", (Object)"cValue");
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(task2.getId(), "var", (Object)"bValue");
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.taskService.setVariableLocal(task3.getId(), "var", (Object)"aValue");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByTaskVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testQueryResultOrderingByCaseInstanceVariables() {
        CaseInstance instance1 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "cValue"));
        CaseInstance instance2 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "aValue"));
        CaseInstance instance3 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "bValue"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().caseDefinitionKey("oneTaskCase").orderByCaseInstanceVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(0)).getCaseInstanceId());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(1)).getCaseInstanceId());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(2)).getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testQueryResultOrderingByCaseExecutionVariables() {
        CaseInstance instance1 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "cValue"));
        CaseInstance instance2 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "aValue"));
        CaseInstance instance3 = this.caseService.createCaseInstanceByKey("oneTaskCase", Collections.singletonMap("var", "bValue"));
        CaseExecution caseExecution1 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(instance1.getId()).singleResult();
        this.caseService.withCaseExecution(caseExecution1.getId()).setVariableLocal("var", (Object)"aValue").manualStart();
        CaseExecution caseExecution2 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(instance2.getId()).singleResult();
        this.caseService.withCaseExecution(caseExecution2.getId()).setVariableLocal("var", (Object)"bValue").manualStart();
        CaseExecution caseExecution3 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").caseInstanceId(instance3.getId()).singleResult();
        this.caseService.withCaseExecution(caseExecution3.getId()).setVariableLocal("var", (Object)"cValue").manualStart();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().caseDefinitionKey("oneTaskCase").orderByCaseExecutionVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(0)).getCaseInstanceId());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(1)).getCaseInstanceId());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(2)).getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByVariablesWithNullValues() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "bValue"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        ProcessInstance instance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Task firstTask = (Task)tasks.get(0);
        if (firstTask.getProcessInstanceId().equals(instance4.getId())) {
            Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
            Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
            Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(3)).getProcessInstanceId());
        } else {
            Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
            Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
            Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
            Assert.assertEquals((Object)instance4.getId(), (Object)((Task)tasks.get(3)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByVariablesWithMixedTypes() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "cValue"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "aValue"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Task firstTask = (Task)tasks.get(0);
        if (firstTask.getProcessInstanceId().equals(instance1.getId())) {
            Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
            Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        } else {
            Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
            Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
            Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByStringVariableWithMixedCase() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "a"));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "B"));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "c"));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByVariablesOfAllPrimitiveTypes() {
        ProcessInstance booleanInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", true));
        ProcessInstance shortInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)16));
        ProcessInstance longInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 500L));
        ProcessInstance intInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 400));
        ProcessInstance stringInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "300"));
        ProcessInstance dateInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", new Date(1000L)));
        ProcessInstance doubleInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42.5));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.BOOLEAN).asc()).list();
        this.verifyFirstOrLastTask(tasks, booleanInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.SHORT).asc()).list();
        this.verifyFirstOrLastTask(tasks, shortInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.LONG).asc()).list();
        this.verifyFirstOrLastTask(tasks, longInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        this.verifyFirstOrLastTask(tasks, intInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        this.verifyFirstOrLastTask(tasks, stringInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.DATE).asc()).list();
        this.verifyFirstOrLastTask(tasks, dateInstance);
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.DOUBLE).asc()).list();
        this.verifyFirstOrLastTask(tasks, doubleInstance);
    }

    @Test
    public void testQueryByUnsupportedValueTypes() {
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.BYTES);
            Assert.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot order by variables of type byte", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.NULL);
            Assert.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot order by variables of type null", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.NUMBER);
            Assert.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot order by variables of type number", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.OBJECT);
            Assert.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot order by variables of type object", e.getMessage());
        }
        try {
            this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.FILE);
            Assert.fail((String)"this type is not supported");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot order by variables of type file", e.getMessage());
        }
    }

    protected void verifyFirstOrLastTask(List<Task> tasks, ProcessInstance belongingProcessInstance) {
        if (tasks.size() == 0) {
            Assert.fail((String)"no tasks given");
        }
        int numTasks = tasks.size();
        boolean matches = tasks.get(0).getProcessInstanceId().equals(belongingProcessInstance.getId());
        matches = matches || tasks.get(numTasks - 1).getProcessInstanceId().equals(belongingProcessInstance.getId());
        Assert.assertTrue((String)("neither first nor last task belong to process instance " + belongingProcessInstance.getId()), (boolean)matches);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByVariablesWithMixedTypesAndSameColumn() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 42));
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 800));
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 500L));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Task firstTask = (Task)tasks.get(0);
        if (firstTask.getProcessInstanceId().equals(instance3.getId())) {
            Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
            Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        } else {
            Assert.assertEquals((Object)instance1.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
            Assert.assertEquals((Object)instance2.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
            Assert.assertEquals((Object)instance3.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByTwoVariables() {
        ProcessInstance bInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b").putValue("var2", (Object)14));
        ProcessInstance bInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b").putValue("var2", (Object)30));
        ProcessInstance cInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c").putValue("var2", (Object)50));
        ProcessInstance cInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c").putValue("var2", (Object)30));
        ProcessInstance aInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a").putValue("var2", (Object)14));
        ProcessInstance aInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a").putValue("var2", (Object)50));
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).desc()).orderByProcessVariable("var2", (ValueType)ValueType.INTEGER).asc()).list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        Assert.assertEquals((Object)cInstance2.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)cInstance1.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)bInstance1.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        Assert.assertEquals((Object)bInstance2.getId(), (Object)((Task)tasks.get(3)).getProcessInstanceId());
        Assert.assertEquals((Object)aInstance1.getId(), (Object)((Task)tasks.get(4)).getProcessInstanceId());
        Assert.assertEquals((Object)aInstance2.getId(), (Object)((Task)tasks.get(5)).getProcessInstanceId());
        tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var2", (ValueType)ValueType.INTEGER).desc()).orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        Assert.assertEquals((Object)aInstance2.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)cInstance1.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)bInstance2.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        Assert.assertEquals((Object)cInstance2.getId(), (Object)((Task)tasks.get(3)).getProcessInstanceId());
        Assert.assertEquals((Object)aInstance1.getId(), (Object)((Task)tasks.get(4)).getProcessInstanceId());
        Assert.assertEquals((Object)bInstance1.getId(), (Object)((Task)tasks.get(5)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryResultOrderingByVariablesWithSecondaryOrderingByProcessInstanceId() {
        ProcessInstance bInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b"));
        ProcessInstance bInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"b"));
        ProcessInstance cInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c"));
        ProcessInstance cInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"c"));
        ProcessInstance aInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a"));
        ProcessInstance aInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a"));
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.STRING).asc()).orderByProcessInstanceId().asc()).list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        this.verifyTasksSortedByProcessInstanceId(Arrays.asList(aInstance1, aInstance2), tasks.subList(0, 2));
        this.verifyTasksSortedByProcessInstanceId(Arrays.asList(bInstance1, bInstance2), tasks.subList(2, 4));
        this.verifyTasksSortedByProcessInstanceId(Arrays.asList(cInstance1, cInstance2), tasks.subList(4, 6));
    }

    @Test
    public void testQueryResultOrderingWithInvalidParameters() {
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable(null, (ValueType)ValueType.STRING).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", null).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByExecutionVariable(null, (ValueType)ValueType.STRING).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByExecutionVariable("var", null).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByTaskVariable(null, (ValueType)ValueType.STRING).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByTaskVariable("var", null).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseInstanceVariable(null, (ValueType)ValueType.STRING).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseInstanceVariable("var", null).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseExecutionVariable(null, (ValueType)ValueType.STRING).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        try {
            ((TaskQuery)this.taskService.createTaskQuery().orderByCaseExecutionVariable("var", null).asc()).list();
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    protected void verifyTasksSortedByProcessInstanceId(List<ProcessInstance> expectedProcessInstances, List<Task> actualTasks) {
        Assert.assertEquals((long)expectedProcessInstances.size(), (long)actualTasks.size());
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>(expectedProcessInstances);
        Collections.sort(instances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance p1, ProcessInstance p2) {
                return p1.getId().compareTo(p2.getId());
            }
        });
        for (int i = 0; i < instances.size(); ++i) {
            Assert.assertEquals((Object)((ProcessInstance)instances.get(i)).getId(), (Object)actualTasks.get(i).getProcessInstanceId());
        }
    }

    private void verifyQueryResults(TaskQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(TaskQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/oneTaskWithFormKeyProcess.bpmn20.xml"})
    @Test
    public void testInitializeFormKeys() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).initializeFormKeys().singleResult();
        Assert.assertEquals((Object)"exampleFormKey", (Object)task.getFormKey());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        try {
            task.getFormKey();
            Assert.fail((String)"exception expected.");
        }
        catch (BadUserRequestException e) {
            Assert.assertEquals((Object)"ENGINE-03052 The form key / form reference is not initialized. You must call initializeFormKeys() on the task query before you can retrieve the form key or the form reference.", (Object)e.getMessage());
        }
    }

    @Test
    @Deployment
    public void testInitializeFormKeysCamundaFormRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("formRefProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).initializeFormKeys().singleResult();
        CamundaFormRef camundaFormRef = task.getCamundaFormRef();
        Assertions.assertThat((String)camundaFormRef.getKey()).isEqualTo((Object)"myForm");
        Assertions.assertThat((String)camundaFormRef.getBinding()).isEqualTo((Object)"latest");
        Assertions.assertThat((Integer)camundaFormRef.getVersion()).isNull();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> task2.getCamundaFormRef()).isInstanceOf(BadUserRequestException.class)).hasMessage("ENGINE-03052 The form key / form reference is not initialized. You must call initializeFormKeys() on the task query before you can retrieve the form key or the form reference.");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithFormKey.cmmn"})
    @Test
    public void testInitializeFormKeysForCaseInstance() {
        String caseDefinitionId = this.getCaseDefinitionId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).create();
        Task task = (Task)this.taskService.createTaskQuery().initializeFormKeys().caseInstanceId(caseInstance.getId()).singleResult();
        Assert.assertEquals((Object)"aFormKey", (Object)task.getFormKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryOrderByProcessVariableInteger() {
        ProcessInstance instance500 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)500));
        ProcessInstance instance1000 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)1000));
        ProcessInstance instance250 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)250));
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance250.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance500.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance1000.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)instance1000.getId(), (Object)((Task)tasks.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)instance500.getId(), (Object)((Task)tasks.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)instance250.getId(), (Object)((Task)tasks.get(2)).getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryOrderByTaskVariableInteger() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task500 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(task500.getId(), "var", (Object)500);
        Task task250 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(task250.getId(), "var", (Object)250);
        Task task1000 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.taskService.setVariableLocal(task1000.getId(), "var", (Object)1000);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByTaskVariable("var", (ValueType)ValueType.INTEGER).asc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)task250.getId(), (Object)((Task)tasks.get(0)).getId());
        Assert.assertEquals((Object)task500.getId(), (Object)((Task)tasks.get(1)).getId());
        Assert.assertEquals((Object)task1000.getId(), (Object)((Task)tasks.get(2)).getId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Assert.assertEquals((Object)task1000.getId(), (Object)((Task)tasks.get(0)).getId());
        Assert.assertEquals((Object)task500.getId(), (Object)((Task)tasks.get(1)).getId());
        Assert.assertEquals((Object)task250.getId(), (Object)((Task)tasks.get(2)).getId());
    }

    @Test
    public void testQueryByParentTaskId() {
        String parentTaskId = "parentTask";
        Task parent = this.taskService.newTask(parentTaskId);
        this.taskService.saveTask(parent);
        Task sub1 = this.taskService.newTask("subTask1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("subTask2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        TaskQuery query = this.taskService.createTaskQuery().taskParentTaskId(parentTaskId);
        this.verifyQueryResults(query, 2);
        this.taskService.deleteTask(parentTaskId, true);
    }

    @Test
    public void testExtendTaskQueryList_ProcessDefinitionKeyIn() {
        String processDefinitionKey = "invoice";
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{processDefinitionKey});
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] processDefinitionKeys = ((TaskQueryImpl)result).getProcessDefinitionKeys();
        Assert.assertEquals((long)1L, (long)processDefinitionKeys.length);
        Assert.assertEquals((Object)processDefinitionKey, (Object)processDefinitionKeys[0]);
    }

    @Test
    public void testExtendingTaskQueryList_ProcessDefinitionKeyIn() {
        String processDefinitionKey = "invoice";
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().processDefinitionKeyIn(new String[]{processDefinitionKey});
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] processDefinitionKeys = ((TaskQueryImpl)result).getProcessDefinitionKeys();
        Assert.assertEquals((long)1L, (long)processDefinitionKeys.length);
        Assert.assertEquals((Object)processDefinitionKey, (Object)processDefinitionKeys[0]);
    }

    @Test
    public void testExtendTaskQueryList_TaskDefinitionKeyIn() {
        String taskDefinitionKey = "assigneApprover";
        TaskQuery query = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{taskDefinitionKey});
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] key = ((TaskQueryImpl)result).getKeys();
        Assert.assertEquals((long)1L, (long)key.length);
        Assert.assertEquals((Object)taskDefinitionKey, (Object)key[0]);
    }

    @Test
    public void testExtendingTaskQueryList_TaskDefinitionKeyIn() {
        String taskDefinitionKey = "assigneApprover";
        TaskQuery query = this.taskService.createTaskQuery();
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskDefinitionKeyIn(new String[]{taskDefinitionKey});
        TaskQuery result = ((TaskQueryImpl)query).extend(extendingQuery);
        String[] key = ((TaskQueryImpl)result).getKeys();
        Assert.assertEquals((long)1L, (long)key.length);
        Assert.assertEquals((Object)taskDefinitionKey, (Object)key[0]);
    }

    @Test
    public void testQueryWithCandidateUsers() {
        BpmnModelInstance process = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaCandidateUsers("anna")).endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).withCandidateUsers().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testQueryWithoutCandidateUsers() {
        BpmnModelInstance process = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaCandidateGroups("sales")).endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).withoutCandidateUsers().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Test
    public void testQueryAssignedTasksWithCandidateUsers() {
        BpmnModelInstance process = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaCandidateGroups("sales")).endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).includeAssignedTasks().withCandidateUsers().list();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryAssignedTasksWithoutCandidateUsers() {
        BpmnModelInstance process = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaCandidateGroups("sales")).endEvent().done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).includeAssignedTasks().withoutCandidateUsers().list();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNameNotEqual() {
        TaskQuery query = this.taskService.createTaskQuery().taskNameNotEqual("gonzo_Task");
        Assert.assertEquals((long)11L, (long)query.list().size());
    }

    @Test
    public void testQueryByNameNotLike() {
        TaskQuery query = this.taskService.createTaskQuery().taskNameNotLike("management%");
        Assert.assertEquals((long)9L, (long)query.list().size());
        Assert.assertEquals((long)9L, (long)query.count());
        query = this.taskService.createTaskQuery().taskNameNotLike("gonzo\\_%");
        Assert.assertEquals((long)11L, (long)query.list().size());
        Assert.assertEquals((long)11L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceIdIn() {
        String instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processInstanceIdIn(new String[]{instance1, instance2, "nonexisting"}).list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
        for (Task task : tasks) {
            Assertions.assertThat((String)task.getProcessInstanceId()).isIn(new Object[]{instance1, instance2});
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.testProcessDefinition.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceIdInNonExisting() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processInstanceIdIn(new String[]{"nonexisting"}).list();
        Assertions.assertThat((int)tasks.size()).isZero();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskQueryTest.shouldContainCamundaFormRefIfInitialized.bpmn"})
    @Test
    public void shouldContainCamundaFormRefIfInitialized() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskFormRefVersion").getId();
        List withoutFormKeys = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        List withFormKeys = this.taskService.createTaskQuery().processInstanceId(processInstanceId).initializeFormKeys().list();
        Assertions.assertThat((List)withoutFormKeys).hasSize(1);
        Assertions.assertThat((List)withFormKeys).hasSize(1);
        Task taskWithoutFormKey = (Task)withoutFormKeys.get(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> taskWithoutFormKey.getCamundaFormRef()).isInstanceOf(BadUserRequestException.class)).hasMessage("ENGINE-03052 The form key / form reference is not initialized. You must call initializeFormKeys() on the task query before you can retrieve the form key or the form reference.");
        Task taskWithFormKey = (Task)withFormKeys.get(0);
        CamundaFormRef camundaFormRefWithFormKey = taskWithFormKey.getCamundaFormRef();
        Assertions.assertThat((Object)camundaFormRefWithFormKey).isNotNull();
        Assertions.assertThat((String)camundaFormRefWithFormKey.getKey()).isEqualTo((Object)"key");
        Assertions.assertThat((String)camundaFormRefWithFormKey.getBinding()).isEqualTo((Object)"version");
        Assertions.assertThat((Integer)camundaFormRefWithFormKey.getVersion()).isEqualTo(3);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldFindTaskLastUpdatedNullUseCreateDate() {
        Date beforeStart = this.getBeforeCurrentTime();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskUpdatedAfter(beforeStart).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isNull();
        Assertions.assertThat((Date)taskResult.getCreateTime()).isAfter(beforeStart);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotFindTaskLastUpdatedNullCreateDateBeforeQueryDate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date afterStart = this.getAfterCurrentTime();
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskUpdatedAfter(afterStart).singleResult();
        Assertions.assertThat((Object)taskResult).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotFindTaskLastUpdatedBeforeQueryDate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Date lastUpdatedBeforeUpdate = task.getLastUpdated();
        task.setAssignee("myself");
        Assertions.assertThat((Date)lastUpdatedBeforeUpdate).isNull();
        this.taskService.saveTask(task);
        Date afterUpdate = this.getAfterCurrentTime();
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskUpdatedAfter(afterUpdate).singleResult();
        Assertions.assertThat((Object)taskResult).isNull();
        taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isBefore(afterUpdate);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotFindTaskLastUpdatedEqualsQueryDate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        task.setAssignee("myself");
        this.taskService.saveTask(task);
        Task taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isNotNull();
        taskResult = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskUpdatedAfter(taskResult.getLastUpdated()).singleResult();
        Assertions.assertThat((Object)taskResult).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnResultsOrderedByLastUpdatedAsc() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date beforeUpdates = this.getBeforeCurrentTime();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        this.taskService.setOwner(task2.getId(), "myself");
        ClockUtil.offset((Long)1000L);
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "myVar", (Object)"varVal");
        ClockUtil.offset((Long)2000L);
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult();
        this.taskService.setPriority(task3.getId(), 3);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId(), processInstance3.getId()}).taskUpdatedAfter(beforeUpdates).orderByLastUpdated().asc()).list();
        Assertions.assertThat((List)tasks).hasSize(3);
        Assertions.assertThat((List)tasks).extracting("id").containsExactly(new Object[]{task2.getId(), task1.getId(), task3.getId()});
        Assertions.assertThat((List)tasks).extracting("lastUpdated").isSorted();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnResultsOrderedByLastUpdatedDesc() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Date beforeUpdates = this.getBeforeCurrentTime();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        this.taskService.setOwner(task2.getId(), "myself");
        ClockUtil.offset((Long)1000L);
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "myVar", (Object)"varVal");
        ClockUtil.offset((Long)2000L);
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult();
        this.taskService.setPriority(task3.getId(), 3);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId(), processInstance3.getId()}).taskUpdatedAfter(beforeUpdates).orderByLastUpdated().desc()).list();
        Assertions.assertThat((List)tasks).hasSize(3);
        Assertions.assertThat((List)tasks).extracting("id").containsExactly(new Object[]{task3.getId(), task1.getId(), task2.getId()});
        Assertions.assertThat((List)tasks).extracting("lastUpdated").isSortedAccordingTo(Collections.reverseOrder());
    }

    @Test
    public void shouldFindStandaloneTaskWithoutUpdateByLastUpdated() {
        Date beforeCreateTask = this.getBeforeCurrentTime();
        Task task = this.taskService.newTask("myTask");
        this.taskIds.add(task.getId());
        task.setAssignee("myself");
        Date beforeSave = this.getAfterCurrentTime();
        this.taskService.saveTask(task);
        Task taskResult = (Task)this.taskService.createTaskQuery().taskId("myTask").taskUpdatedAfter(beforeCreateTask).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isNull();
        Assertions.assertThat((Date)taskResult.getCreateTime()).isBefore(beforeSave);
    }

    @Test
    public void shouldFindStandaloneTaskWithUpdateByLastUpdated() {
        Task task = this.taskService.newTask("myTask");
        this.taskIds.add(task.getId());
        task.setAssignee("myself");
        Date beforeSave = this.getBeforeCurrentTime();
        this.taskService.saveTask(task);
        ClockUtil.offset((Long)1000L);
        this.taskService.setPriority(task.getId(), 2);
        Task taskResult = (Task)this.taskService.createTaskQuery().taskId("myTask").taskUpdatedAfter(beforeSave).singleResult();
        Assertions.assertThat((Object)taskResult).isNotNull();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(beforeSave);
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isAfter(taskResult.getCreateTime());
    }

    private Date getAfterCurrentTime() {
        return new Date(ClockUtil.getCurrentTime().getTime() + 1000L);
    }

    private Date getBeforeCurrentTime() {
        return new Date(ClockUtil.getCurrentTime().getTime() - 1000L);
    }

    private List<String> generateTestTasks() throws Exception {
        int i;
        ArrayList<String> ids = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
        ClockUtil.setCurrentTime((Date)sdf.parse("01/01/2001 01:01:01.000"));
        for (int i2 = 0; i2 < 6; ++i2) {
            Task task = this.taskService.newTask();
            task.setName("testTask");
            task.setDescription("testTask description");
            task.setPriority(3);
            this.taskService.saveTask(task);
            ids.add(task.getId());
            this.taskService.addCandidateUser(task.getId(), "kermit");
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("02/02/2002 02:02:02.000"));
        Task task = this.taskService.newTask();
        task.setName("gonzo_Task");
        task.setDescription("gonzo_description");
        task.setPriority(4);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "gonzo_");
        this.taskService.setVariable(task.getId(), "testVar", (Object)"someVariable");
        this.taskService.addCandidateUser(task.getId(), "kermit");
        this.taskService.addCandidateUser(task.getId(), "gonzo");
        ids.add(task.getId());
        ClockUtil.setCurrentTime((Date)sdf.parse("03/03/2003 03:03:03.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("managementTask");
            task.setPriority(10);
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "management");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("04/04/2004 04:04:04.000"));
        for (i = 0; i < 2; ++i) {
            task = this.taskService.newTask();
            task.setName("accountancyTask");
            task.setName("accountancy description");
            this.taskService.saveTask(task);
            this.taskService.addCandidateGroup(task.getId(), "accountancy");
            ids.add(task.getId());
        }
        ClockUtil.setCurrentTime((Date)sdf.parse("05/05/2005 05:05:05.000"));
        task = this.taskService.newTask();
        task.setName("managementAndAccountancyTask");
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "fozzie");
        this.taskService.addCandidateGroup(task.getId(), "management");
        this.taskService.addCandidateGroup(task.getId(), "accountancy");
        ids.add(task.getId());
        ClockUtil.reset();
        return ids;
    }
}

