/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MessageStartEventSubscriptionTest {
    private static final String SINGLE_MESSAGE_START_EVENT_XML = "org/camunda/bpm/engine/test/bpmn/event/message/MessageStartEventTest.testSingleMessageStartEvent.bpmn20.xml";
    private static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    private static final String MESSAGE_EVENT_PROCESS = "singleMessageStartEvent";
    private static final BpmnModelInstance MODEL_WITHOUT_MESSAGE = Bpmn.createExecutableProcess((String)"singleMessageStartEvent").startEvent().userTask().endEvent().done();
    private static final BpmnModelInstance MODEL = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"another").startEvent().message("anotherMessage")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void setUp() throws Exception {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void testUpdateProcessVersionCancelsSubscriptions() {
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        List eventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)eventSubscriptions.size());
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        List newEventSubscriptions = this.runtimeService.createEventSubscriptionQuery().list();
        List newProcessDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)newEventSubscriptions.size());
        Assert.assertEquals((long)2L, (long)newProcessDefinitions.size());
        for (ProcessDefinition processDefinition : newProcessDefinitions) {
            EventSubscriptionEntity subscriptionEntity;
            if (processDefinition.getVersion() == 1) {
                for (EventSubscription subscription : newEventSubscriptions) {
                    subscriptionEntity = (EventSubscriptionEntity)subscription;
                    Assert.assertFalse((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
                }
                continue;
            }
            for (EventSubscription subscription : newEventSubscriptions) {
                subscriptionEntity = (EventSubscriptionEntity)subscription;
                Assert.assertTrue((boolean)subscriptionEntity.getConfiguration().equals(processDefinition.getId()));
            }
        }
        Assert.assertFalse((boolean)eventSubscriptions.equals(newEventSubscriptions));
    }

    @Test
    public void testEventSubscriptionAfterDeleteLatestProcessVersion() {
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        ProcessDefinition processDefinitionV1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinitionV1);
        String deploymentId = this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML).getId();
        this.repositoryService.deleteDeployment(deploymentId, true);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(MESSAGE_EVENT_PROCESS).singleResult();
        Assert.assertEquals((Object)processDefinitionV1.getId(), (Object)processDefinition.getId());
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)eventSubscription);
        Assert.assertEquals((Object)processDefinitionV1.getId(), (Object)eventSubscription.getConfiguration());
    }

    @Test
    public void testStartInstanceAfterDeleteLatestProcessVersionByIds() {
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        DeploymentWithDefinitions deployment = this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{processDefinition.getId()}).delete();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByMessage("newInvoiceMessage");
        Assert.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ProcessInstance completedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        if (completedInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + completedInstance + "' but it was still in the db");
        }
    }

    @Test
    public void testStartInstanceAfterDeleteLatestProcessVersion() {
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        String deploymentId = this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML).getId();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(MESSAGE_EVENT_PROCESS);
        Assert.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ProcessInstance completedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        if (completedInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + completedInstance + "' but it was still in the db");
        }
    }

    @Test
    public void testVersionWithoutConditionAfterDeleteLatestProcessVersionWithCondition() {
        this.testRule.deploy(MODEL_WITHOUT_MESSAGE);
        String deploymentId = this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML).getId();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)1).evaluateStartConditions()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("No subscriptions were found during evaluation of the conditional start events.");
    }

    @Test
    public void testSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionByKeys() {
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        this.testRule.deploy(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byKey(MESSAGE_EVENT_PROCESS).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    public void testSubscriptionsWhenDeletingGroupsProcessDefinitionsByIds() {
        String processDefId11 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String processDefId12 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String processDefId13 = this.testRule.deployAndGetDefinition(MODEL_WITHOUT_MESSAGE).getId();
        String processDefId21 = this.deployModel(MODEL);
        String processDefId22 = this.deployModel(MODEL);
        String processDefId23 = this.deployModel(MODEL);
        String processDefId31 = this.deployProcess(ONE_TASK_PROCESS);
        String processDefId32 = this.deployProcess(ONE_TASK_PROCESS);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{processDefId21, processDefId23, processDefId13, processDefId12, processDefId31}).delete();
        List list = this.runtimeService.createEventSubscriptionQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (EventSubscription eventSubscription : list) {
            EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)eventSubscription;
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId11) || eventSubscriptionEntity.getConfiguration().equals(processDefId22)) continue;
            Assert.fail((String)("This process definition '" + eventSubscriptionEntity.getConfiguration() + "' and the respective event subscription should not exist."));
        }
    }

    @Test
    public void testSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionByIdOrdered() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    public void testSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionByIdReverseOrder() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId3, definitionId2, definitionId1}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    public void testMixedSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionById1() {
        String definitionId1 = this.deployModel(MODEL_WITHOUT_MESSAGE);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    public void testMixedSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionById2() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployModel(MODEL_WITHOUT_MESSAGE);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    public void testMixedSubscriptionsWhenDeletingProcessDefinitionsInOneTransactionById3() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployModel(MODEL_WITHOUT_MESSAGE);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId1, definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
    }

    @Test
    public void testMixedSubscriptionsWhenDeletingTwoProcessDefinitionsInOneTransaction1() {
        String definitionId1 = this.deployModel(MODEL_WITHOUT_MESSAGE);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId());
    }

    @Test
    public void testMixedSubscriptionsWhenDeletingTwoProcessDefinitionsInOneTransaction2() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployModel(MODEL_WITHOUT_MESSAGE);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    public void testMixedSubscriptionsWhenDeletingTwoProcessDefinitionsInOneTransaction3() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployModel(MODEL_WITHOUT_MESSAGE);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    public void testDeleteNotLatestVersion() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId3, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    @Test
    public void testSubscribePreviousPreviousVersion() {
        String definitionId1 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId2 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        String definitionId3 = this.deployProcess(SINGLE_MESSAGE_START_EVENT_XML);
        this.repositoryService.deleteProcessDefinitions().byIds(new String[]{definitionId2, definitionId3}).delete();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Assert.assertEquals((Object)definitionId1, (Object)((EventSubscriptionEntity)this.runtimeService.createEventSubscriptionQuery().singleResult()).getConfiguration());
    }

    protected String deployProcess(String resourcePath) {
        List deployedProcessDefinitions = this.testRule.deploy(resourcePath).getDeployedProcessDefinitions();
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitions.size());
        return ((ProcessDefinition)deployedProcessDefinitions.get(0)).getId();
    }

    protected String deployModel(BpmnModelInstance model) {
        List deployedProcessDefinitions = this.testRule.deploy(model).getDeployedProcessDefinitions();
        Assert.assertEquals((long)1L, (long)deployedProcessDefinitions.size());
        String definitionId2 = ((ProcessDefinition)deployedProcessDefinitions.get(0)).getId();
        return definitionId2;
    }
}

