/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SignalEventParseInvalidProcessTest {
    private static final String PROCESS_DEFINITION_DIRECTORY = "org/camunda/bpm/engine/test/bpmn/event/signal/";
    @Parameterized.Parameter(value=0)
    public String processDefinitionResource;
    @Parameterized.Parameter(value=1)
    public String expectedErrorMessage;
    @Parameterized.Parameter(value=2)
    public String elementIds;
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RepositoryService repositoryService;

    @Parameterized.Parameters(name="{index}: process definition = {0}, expected error message = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"InvalidProcessWithDuplicateSignalNames.bpmn20.xml", "duplicate signal name", "alertSignal2"}, {"InvalidProcessWithNoSignalName.bpmn20.xml", "signal with id 'alertSignal' has no name", "alertSignal"}, {"InvalidProcessWithSignalNoId.bpmn20.xml", "signal must have an id", null}, {"InvalidProcessWithSignalNoRef.bpmn20.xml", "signalEventDefinition does not have required property 'signalRef'", "signalEvent"}, {"InvalidProcessWithMultipleSignalStartEvents.bpmn20.xml", "Cannot have more than one signal event subscription with name 'signal'", "start2"}, {"InvalidProcessWithMultipleInterruptingSignalEventSubProcesses.bpmn20.xml", "Cannot have more than one signal event subscription with name 'alert'", "subprocessStartEvent2"});
    }

    @Before
    public void initServices() {
        this.repositoryService = this.rule.getRepositoryService();
    }

    @Test
    public void testParseInvalidProcessDefinition() {
        try {
            this.repositoryService.createDeployment().addClasspathResource(PROCESS_DEFINITION_DIRECTORY + this.processDefinitionResource).deploy();
            Assert.fail((String)("exception expected: " + this.expectedErrorMessage));
        }
        catch (ParseException e) {
            this.assertTextPresent(this.expectedErrorMessage, e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)this.elementIds);
        }
    }

    public void assertTextPresent(String expected, String actual) {
        if (actual == null || !actual.contains(expected)) {
            throw new AssertionFailedError("expected presence of [" + expected + "], but was [" + actual + "]");
        }
    }
}

