/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.executionlistener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.model.PropertyKey;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class RecorderExecutionListener
implements ExecutionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private FixedValue parameter;
    private static List<RecordedEvent> recordedEvents = new ArrayList<RecordedEvent>();

    public void notify(DelegateExecution execution) throws Exception {
        ExecutionEntity executionCasted = (ExecutionEntity)execution;
        String parameterValue = null;
        if (this.parameter != null) {
            parameterValue = (String)this.parameter.getValue((VariableScope)execution);
        }
        String activityName = null;
        if (executionCasted.getActivity() != null) {
            activityName = (String)executionCasted.getActivity().getProperties().get(new PropertyKey("name"));
        }
        recordedEvents.add(new RecordedEvent(executionCasted.getActivityId(), activityName, execution.getEventName(), parameterValue, execution.getActivityInstanceId(), execution.getCurrentTransitionId(), execution.isCanceled(), execution.getId()));
    }

    public static void clear() {
        recordedEvents.clear();
    }

    public static List<RecordedEvent> getRecordedEvents() {
        return recordedEvents;
    }

    public static class RecordedEvent {
        private final String activityId;
        private final String eventName;
        private final String activityName;
        private final String parameter;
        private final String activityInstanceId;
        private final String transitionId;
        private final boolean canceled;
        private final String executionId;

        public RecordedEvent(String activityId, String activityName, String eventName, String parameter, String activityInstanceId, String transitionId, boolean canceled, String executionId) {
            this.activityId = activityId;
            this.activityName = activityName;
            this.parameter = parameter;
            this.eventName = eventName;
            this.activityInstanceId = activityInstanceId;
            this.transitionId = transitionId;
            this.canceled = canceled;
            this.executionId = executionId;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String getActivityInstanceId() {
            return this.activityInstanceId;
        }

        public String getTransitionId() {
            return this.transitionId;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public String getExecutionId() {
            return this.executionId;
        }
    }
}

