/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.tasklistener.AbstractTaskListenerTest;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.CompletingTaskListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.TaskDeleteListener;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.commons.utils.IoUtil;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskListenerTest
extends AbstractTaskListenerTest {
    @Before
    public void resetListenerCounters() {
        VariablesCollectingListener.reset();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskCreateListener() {
        this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Schedule meeting", (Object)task.getName());
        Assert.assertEquals((Object)"TaskCreateListener is listening!", (Object)task.getDescription());
    }

    @Test
    public void testCompleteTaskInCreateEventTaskListener() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"startToEnd").startEvent().userTask().camundaTaskListenerClass("create", CompletingTaskListener.class.getName())).name("userTask")).endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Test
    public void testCompleteTaskInCreateEventTaskListenerWithIdentityLinks() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"startToEnd").startEvent().userTask().camundaTaskListenerClass("create", CompletingTaskListener.class.getName())).name("userTask")).camundaCandidateUsers(Arrays.asList("users1", "user2"))).camundaCandidateGroups(Arrays.asList("group1", "group2"))).endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("startToEnd");
        Assert.assertNull((Object)this.taskService.createTaskQuery().singleResult());
    }

    @Test
    public void testCompleteTaskInCreateEventListenerWithFollowingCallActivity() {
        BpmnModelInstance subProcess = Bpmn.createExecutableProcess((String)"subProc").startEvent().userTask("calledTask").endEvent().done();
        BpmnModelInstance instance = ((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"mainProc").startEvent().userTask("mainTask").camundaTaskListenerClass("create", CompletingTaskListener.class.getName())).callActivity().calledElement("subProc")).endEvent().done();
        this.testRule.deploy(subProcess, instance);
        this.runtimeService.startProcessInstanceByKey("mainProc");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)task.getTaskDefinitionKey(), (Object)"calledTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskCompleteListener() {
        TaskDeleteListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "expressionValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)TaskDeleteListener.eventCounter);
        Assert.assertNull((Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertNull((Object)TaskDeleteListener.lastDeleteReason);
        Assert.assertEquals((Object)"Hello from The Process", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        Assert.assertEquals((Object)"Act", (Object)this.runtimeService.getVariable(processInstance.getId(), "shortName"));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskDeleteListenerByProcessDeletion() {
        TaskDeleteListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals((long)0L, (long)TaskDeleteListener.eventCounter);
        Assert.assertNull((Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertNull((Object)TaskDeleteListener.lastDeleteReason);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), "test delete task listener");
        Assert.assertEquals((long)1L, (long)TaskDeleteListener.eventCounter);
        Assert.assertEquals((Object)task.getTaskDefinitionKey(), (Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertEquals((Object)"test delete task listener", (Object)TaskDeleteListener.lastDeleteReason);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskDeleteListenerByBoundaryEvent() {
        TaskDeleteListener.clear();
        this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals((long)0L, (long)TaskDeleteListener.eventCounter);
        Assert.assertNull((Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertNull((Object)TaskDeleteListener.lastDeleteReason);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.correlateMessage("message");
        Assert.assertEquals((long)1L, (long)TaskDeleteListener.eventCounter);
        Assert.assertEquals((Object)task.getTaskDefinitionKey(), (Object)TaskDeleteListener.lastTaskDefinitionKey);
        Assert.assertEquals((Object)"deleted", (Object)TaskDeleteListener.lastDeleteReason);
    }

    @Test
    public void testActivityInstanceIdOnDeleteInCalledProcess() {
        RecorderTaskListener.clear();
        BpmnModelInstance callActivityProcess = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent().done();
        BpmnModelInstance calledProcess = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"called").startEvent().userTask().camundaTaskListenerClass("create", RecorderTaskListener.class.getName())).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).endEvent().done();
        this.testRule.deploy(callActivityProcess, calledProcess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("calling");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        List<RecorderTaskListener.RecordedTaskEvent> recordedEvents = RecorderTaskListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        String createActivityInstanceId = recordedEvents.get(0).getActivityInstanceId();
        String deleteActivityInstanceId = recordedEvents.get(1).getActivityInstanceId();
        Assert.assertEquals((Object)createActivityInstanceId, (Object)deleteActivityInstanceId);
    }

    @Test
    public void testVariableAccessOnDeleteInCalledProcess() {
        VariablesCollectingListener.reset();
        BpmnModelInstance callActivityProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().camundaIn("foo", "foo")).calledElement("called")).endEvent().done();
        BpmnModelInstance calledProcess = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"called").startEvent().userTask().camundaTaskListenerClass("delete", VariablesCollectingListener.class.getName())).endEvent().done();
        this.testRule.deploy(callActivityProcess, calledProcess);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("calling", (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        VariableMap collectedVariables = VariablesCollectingListener.getCollectedVariables();
        Assert.assertNotNull((Object)collectedVariables);
        Assert.assertEquals((long)1L, (long)collectedVariables.size());
        Assert.assertEquals((Object)"bar", (Object)collectedVariables.get((Object)"foo"));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.bpmn20.xml"})
    public void testTaskListenerWithExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("taskListenerProcess");
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting2"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((Object)"Write meeting notes", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting2"));
    }

    @Test
    @Deployment
    public void testScriptListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "create")));
        this.taskService.setAssignee(task.getId(), "test");
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "assignment")));
        this.taskService.complete(task.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "complete")));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("delete").singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertTrue((boolean)((Boolean)variable.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.testScriptResourceListener.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/tasklistener/taskListener.groovy"})
    public void testScriptResourceListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "create")));
        this.taskService.setAssignee(task.getId(), "test");
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "assignment")));
        this.taskService.complete(task.getId());
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstance.getId(), "complete")));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("delete").singleResult();
            Assert.assertNotNull((Object)variable);
            Assert.assertTrue((boolean)((Boolean)variable.getValue()));
        }
    }

    @Test
    public void testUpdateTaskListenerOnAssign() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "gonzo");
        this.taskService.setAssignee(task.getId(), "leelo");
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnOwnerSet() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setOwner(task.getId(), "gonzo");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnUserIdLinkAdd() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addUserIdentityLink(task.getId(), "gonzo", "candidate");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnUserIdLinkDelete() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addUserIdentityLink(task.getId(), "gonzo", "candidate");
        this.taskService.deleteUserIdentityLink(task.getId(), "gonzo", "candidate");
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnGroupIdLinkAdd() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addGroupIdentityLink(task.getId(), "admins", "candidate");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnGroupIdLinkDelete() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addGroupIdentityLink(task.getId(), "admins", "candidate");
        this.taskService.deleteGroupIdentityLink(task.getId(), "admins", "candidate");
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnTaskResolve() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.resolveTask(task.getId());
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnDelegate() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.delegateTask(task.getId(), "gonzo");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnClaim() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.claim(task.getId(), "test");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnPrioritySet() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setPriority(task.getId(), 3000);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnTaskFormSubmit() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskService.delegateTask(task.getId(), "john");
        this.processEngineConfiguration.getFormService().submitTaskForm(task.getId(), null);
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnPropertyUpdate() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setDueDate(new Date());
        this.taskService.saveTask(task);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnPropertyUpdateOnlyOnce() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setAssignee("test");
        task.setDueDate(new Date());
        task.setOwner("test");
        this.taskService.saveTask(task);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testUpdateTaskListenerOnCommentCreate() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.createComment(task.getId(), null, "new comment");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testUpdateTaskListenerOnCommentAdd() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addComment(task.getId(), null, "new comment");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testUpdateTaskListenerOnAttachmentCreate() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.createAttachment("foo", task.getId(), null, "bar", "baz", IoUtil.stringAsInputStream((String)"foo"));
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @RequiredHistoryLevel(value="activity")
    @Test
    public void testUpdateTaskListenerOnAttachmentUpdate() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Attachment attachment = this.taskService.createAttachment("foo", task.getId(), null, "bar", "baz", IoUtil.stringAsInputStream((String)"foo"));
        attachment.setDescription("bla");
        attachment.setName("foo");
        this.taskService.saveAttachment(attachment);
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnAttachmentDelete() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Attachment attachment = this.taskService.createAttachment("foo", task.getId(), null, "bar", "baz", IoUtil.stringAsInputStream((String)"foo"));
        this.taskService.deleteAttachment(attachment.getId());
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnAttachmentDeleteWithTaskId() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Attachment attachment = this.taskService.createAttachment("foo", task.getId(), null, "bar", "baz", IoUtil.stringAsInputStream((String)"foo"));
        this.taskService.deleteTaskAttachment(task.getId(), attachment.getId());
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnSetLocalVariable() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(task.getId(), "foo", (Object)"bar");
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnSetLocalVariables() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"val1").putValue("var2", (Object)"val2");
        this.taskService.setVariablesLocal(task.getId(), (Map)variables);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnSetVariableInTaskScope() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(task.getId(), "foo", (Object)"bar");
        this.taskService.setVariable(task.getId(), "foo", (Object)"bar");
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)2L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerOnSetVariableInHigherScope() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("update");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(task.getId(), "foo", (Object)"bar");
        Assert.assertEquals((long)0L, (long)RecorderTaskListener.getTotalEventCount());
        Assert.assertEquals((long)0L, (long)RecorderTaskListener.getEventCount("update"));
    }

    @Test
    public void testUpdateTaskListenerInvokedBeforeConditionalEventsOnSetVariable() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").camundaTaskListenerClass("update", RecorderTaskListener.class)).boundaryEvent().condition("${triggerBoundaryEvent}")).userTask("afterBoundaryEvent").camundaTaskListenerClass("create", RecorderTaskListener.class)).endEvent().moveToActivity("task").endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskLocalVariable", (Object)"bar");
        RecorderTaskListener.clear();
        VariableMap variables = Variables.createVariables().putValue("triggerBoundaryEvent", (Object)true).putValue("taskLocalVariable", (Object)"baz");
        this.taskService.setVariables(task.getId(), (Map)variables);
        Assertions.assertThat(RecorderTaskListener.getOrderedEvents()).containsExactly((Object[])new String[]{"update", "create"});
    }

    @Test
    public void testAssignmentTaskListenerWhenSavingTask() {
        this.createAndDeployModelWithTaskEventsRecorderOnUserTask("assignment");
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        task.setAssignee("gonzo");
        this.taskService.saveTask(task);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("assignment"));
    }

    @Test
    @Deployment
    public void testTimeoutTaskListenerDuration() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assertions.assertThat((Object)this.runtimeService.getVariable(instance.getId(), "timeout-status")).isEqualTo((Object)"fired");
    }

    @Test
    @Deployment
    public void testTimeoutTaskListenerDate() throws ParseException {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").parse("2019-09-09T13:00:00"));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assertions.assertThat((Object)this.runtimeService.getVariable(instance.getId(), "timeout-status")).isEqualTo((Object)"fired");
    }

    @Test
    @Deployment
    public void testTimeoutTaskListenerCycle() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(130L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assertions.assertThat((Object)this.runtimeService.getVariable(instance.getId(), "timeout-status")).isEqualTo((Object)"fired2");
    }

    @Test
    @Deployment
    public void testMultipleTimeoutTaskListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(2L);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(1L);
        Assertions.assertThat((Object)this.runtimeService.getVariable(instance.getId(), "timeout-status")).isEqualTo((Object)"fired");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.testTimeoutTaskListenerDuration.bpmn20.xml"})
    public void testTimeoutTaskListenerNotCalledWhenTaskCompleted() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        this.runtimeService.startProcessInstanceByKey("process");
        Assertions.assertThat((long)jobQuery.count()).isEqualTo(1L);
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        HistoricVariableInstanceQuery variableQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("timeout-status");
        Assertions.assertThat((long)variableQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)jobQuery.count()).isEqualTo(0L);
    }

    @Test
    @Deployment
    public void testTimeoutTaskListenerNotCalledWhenTaskCompletedByBoundaryEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        this.runtimeService.startProcessInstanceByKey("process");
        Assertions.assertThat((long)jobQuery.count()).isEqualTo(2L);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        HistoricVariableInstanceQuery variableQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("timeout-status");
        Assertions.assertThat((long)variableQuery.count()).isEqualTo(0L);
        Assertions.assertThat((long)jobQuery.count()).isEqualTo(0L);
    }

    @Test
    @Deployment
    public void testRecalculateTimeoutTaskListenerDuedateCreationDateBased() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"duration", (Object)"PT1H"));
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        this.runtimeService.setVariable(pi.getId(), "duration", (Object)"PT15M");
        this.managementService.recalculateJobDuedate(job.getId(), true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDate.after(jobUpdated.getDuedate()));
        Assert.assertEquals((Object)LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusMinutes(15).toDate(), (Object)jobUpdated.getDuedate());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/tasklistener/TaskListenerTest.testRecalculateTimeoutTaskListenerDuedateCreationDateBased.bpmn20.xml"})
    public void testRecalculateTimeoutTaskListenerDuedateCurrentDateBased() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"duration", (Object)"PT1H"));
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        ClockUtil.offset((Long)2000L);
        this.managementService.recalculateJobDuedate(job.getId(), false);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDate.before(jobUpdated.getDuedate()));
    }

    @Test
    @Deployment
    public void testRecalculateTimeoutTaskListenerDuedateCreationDateBasedWithDefinedBoundaryEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.putValue((String)"duration", (Object)"PT1H"));
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId()).activityId("userTask");
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Date oldDate = job.getDuedate();
        this.runtimeService.setVariable(pi.getId(), "duration", (Object)"PT15M");
        this.managementService.recalculateJobDuedate(job.getId(), true);
        Job jobUpdated = (Job)jobQuery.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)jobUpdated.getId());
        Assert.assertNotEquals((Object)oldDate, (Object)jobUpdated.getDuedate());
        Assert.assertTrue((boolean)oldDate.after(jobUpdated.getDuedate()));
        Assert.assertEquals((Object)LocalDateTime.fromDateFields((Date)jobUpdated.getCreateTime()).plusMinutes(15).toDate(), (Object)jobUpdated.getDuedate());
    }

    public static class VariablesCollectingListener
    implements TaskListener {
        protected static VariableMap collectedVariables;

        public void notify(DelegateTask delegateTask) {
            collectedVariables = delegateTask.getVariablesTyped();
        }

        public static VariableMap getCollectedVariables() {
            return collectedVariables;
        }

        public static void reset() {
            collectedVariables = null;
        }
    }
}

