/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskAssignmentExtensionsTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.createMembership("kermit", "management");
        this.identityService.createMembership("kermit", "accountancy");
        this.identityService.createMembership("fozzie", "management");
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteUser("kermit");
    }

    @Deployment
    @Test
    public void testAssigneeExtension() {
        this.runtimeService.startProcessInstanceByKey("assigneeExtension");
        List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"my task", (Object)((Task)tasks.get(0)).getName());
    }

    @Test
    public void testDuplicateAssigneeDeclaration() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testDuplicateAssigneeDeclaration");
            this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
            Assert.fail((String)"Invalid BPMN 2.0 process should not parse, but it gets parsed sucessfully");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testCandidateUsersExtension() {
        this.runtimeService.startProcessInstanceByKey("candidateUsersExtension");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("gonzo").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Deployment
    @Test
    public void testCandidateGroupsExtension() {
        this.runtimeService.startProcessInstanceByKey("candidateGroupsExtension");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"make profit", (Object)((Task)tasks.get(0)).getName());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"make profit", (Object)((Task)tasks.get(0)).getName());
        TaskQuery query = this.taskService.createTaskQuery();
        Assert.assertEquals((long)1L, (long)query.taskCandidateGroup("management").count());
        Assert.assertEquals((long)1L, (long)query.taskCandidateGroup("accountancy").count());
    }

    @Deployment
    @Test
    public void testMixedCandidateUserDefinition() {
        this.runtimeService.startProcessInstanceByKey("mixedCandidateUser");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("gonzo").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("mispiggy").list();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }
}

