/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.bpmn.usertask.ModelExecutionContextTaskListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UserTaskBpmnModelExecutionContextTest {
    private static final String PROCESS_ID = "process";
    private static final String USER_TASK_ID = "userTask";
    private RepositoryService repositoryService;
    private RuntimeService runtimeService;
    private TaskService taskService;
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);

    @Before
    public void setup() {
        this.runtimeService = this.rule.getRuntimeService();
        this.repositoryService = this.rule.getRepositoryService();
        this.taskService = this.rule.getTaskService();
    }

    @After
    public void tearDown() {
        ModelExecutionContextTaskListener.clear();
    }

    @Test
    public void shouldGetBpmnModelElementInstanceOnCreate() {
        String eventName = "create";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        this.assertModelInstance();
        this.assertUserTask(eventName);
    }

    @Test
    public void shouldGetBpmnModelElementInstanceOnAssignment() {
        String eventName = "assignment";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.assertModelInstance();
        this.assertUserTask(eventName);
    }

    @Test
    public void shouldGetBpmnModelElementInstanceOnComplete() {
        String eventName = "complete";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        Assert.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        this.taskService.complete(taskId);
        this.assertModelInstance();
        this.assertUserTask(eventName);
    }

    @Test
    public void shouldGetBpmnModelElementInstanceOnUpdateAfterAssignment() {
        String eventName = "update";
        this.deployProcess(eventName);
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        String taskId = ((org.camunda.bpm.engine.task.Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        Assert.assertNotNull((Object)ModelExecutionContextTaskListener.modelInstance);
        Assert.assertNotNull((Object)ModelExecutionContextTaskListener.userTask);
        this.taskService.complete(taskId);
        this.assertModelInstance();
        this.assertUserTask(eventName);
    }

    @Test
    @Deployment
    public void shouldGetBpmnModelElementInstanceOnTimeout() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.modelInstance);
        Assert.assertNull((Object)ModelExecutionContextTaskListener.userTask);
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        this.assertModelInstance();
        this.assertUserTask("timeout");
    }

    private void assertModelInstance() {
        BpmnModelInstance modelInstance = ModelExecutionContextTaskListener.modelInstance;
        Assert.assertNotNull((Object)modelInstance);
        Collection events = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Event.class));
        Assert.assertEquals((long)2L, (long)events.size());
        Collection tasks = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Task.class));
        Assert.assertEquals((long)1L, (long)tasks.size());
        Process process = (Process)modelInstance.getDefinitions().getRootElements().iterator().next();
        Assert.assertEquals((Object)PROCESS_ID, (Object)process.getId());
        Assert.assertTrue((boolean)process.isExecutable());
    }

    private void assertUserTask(String eventName) {
        UserTask userTask = ModelExecutionContextTaskListener.userTask;
        Assert.assertNotNull((Object)userTask);
        ModelElementInstance taskListener = userTask.getExtensionElements().getUniqueChildElementByNameNs("http://camunda.org/schema/1.0/bpmn", "taskListener");
        Assert.assertEquals((Object)eventName, (Object)taskListener.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "event"));
        Assert.assertEquals((Object)ModelExecutionContextTaskListener.class.getName(), (Object)taskListener.getAttributeValueNs("http://camunda.org/schema/1.0/bpmn", "class"));
        BpmnModelInstance modelInstance = ModelExecutionContextTaskListener.modelInstance;
        Collection tasks = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Task.class));
        Assert.assertTrue((boolean)tasks.contains(userTask));
    }

    private void deployProcess(String eventName) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask(USER_TASK_ID).camundaTaskListenerClass(eventName, ModelExecutionContextTaskListener.class)).endEvent().done();
        this.rule.manageDeployment(this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy());
    }
}

