/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.util.List;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserTaskTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveGroup(this.identityService.newGroup("accountancy"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("fozzie", "accountancy");
        this.identityService.createMembership("kermit", "management");
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("kermit");
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup("management");
    }

    @Deployment
    @Test
    public void testTaskPropertiesNotNull() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task.getId());
        Assert.assertEquals((Object)"my task", (Object)task.getName());
        Assert.assertEquals((Object)"Very important", (Object)task.getDescription());
        Assert.assertTrue((task.getPriority() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"kermit", (Object)task.getAssignee());
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getExecutionId());
        Assert.assertNotNull((Object)task.getProcessDefinitionId());
        Assert.assertNotNull((Object)task.getTaskDefinitionKey());
        Assert.assertNotNull((Object)task.getCreateTime());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Assert.assertEquals((long)0L, (long)this.taskService.getTaskEvents(task.getId()).size());
        }
    }

    @Deployment
    @Test
    public void testQuerySortingWithParameter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list().size());
    }

    @Deployment
    @Test
    public void testCompleteAfterParallelGateway() throws InterruptedException {
        this.runtimeService.startProcessInstanceByKey("ForkProcess");
        List taskList = this.taskService.createTaskQuery().list();
        Assert.assertNotNull((Object)taskList);
        Assert.assertEquals((long)2L, (long)taskList.size());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("SimpleUser").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Deployment
    @Test
    public void testComplexScenarioWithSubprocessesAndParallelGateways() {
        this.runtimeService.startProcessInstanceByKey("processWithSubProcessesAndParallelGateways");
        List taskList = this.taskService.createTaskQuery().list();
        Assert.assertNotNull((Object)taskList);
        Assert.assertEquals((long)13L, (long)taskList.size());
    }

    @Deployment
    @Test
    public void testSimpleProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("financialReport");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Write monthly financial report", (Object)task.getName());
        this.taskService.claim(task.getId(), "fozzie");
        tasks = this.taskService.createTaskQuery().taskAssignee("fozzie").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(task.getId());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("fozzie").list();
        Assert.assertEquals((long)0L, (long)tasks.size());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Verify monthly financial report", (Object)((Task)tasks.get(0)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }
}

