/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.casetask;

import java.util.List;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.CmmnTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.junit.Assert;
import org.junit.Test;

public class CaseTaskTest
extends CmmnTest {
    protected final String CASE_TASK = "PI_CaseTask_1";
    protected final String ONE_CASE_TASK_CASE = "oneCaseTaskCase";
    protected final String ONE_TASK_CASE = "oneTaskCase";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseAsConstant() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseAsExpressionStartsWithDollar() {
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("oneTaskCase", (Object)"oneTaskCase");
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseAsExpressionStartsWithHash() {
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("oneTaskCase", (Object)"oneTaskCase");
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallLatestCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallLatestCase() {
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        Assert.assertEquals((long)3L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String latestCaseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").latestVersion().singleResult()).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)latestCaseDefinitionId, (Object)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByDeployment.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseByDeployment() {
        String firstDeploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String cmmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName).deploy().getId();
        Assert.assertEquals((long)3L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSameDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(firstDeploymentId).singleResult()).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)caseDefinitionIdInSameDeployment, (Object)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByVersion.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseByVersion() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        Assert.assertEquals((long)4L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)caseDefinitionIdInSecondDeployment, (Object)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByVersionAsExpressionStartsWithDollar.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseByVersionAsExpressionStartsWithDollar() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        Assert.assertEquals((long)4L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("myVersion", (Object)2);
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)caseDefinitionIdInSecondDeployment, (Object)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testCallCaseByVersionAsExpressionStartsWithHash.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCallCaseByVersionAsExpressionStartsWithHash() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        Assert.assertEquals((long)4L, (long)this.repositoryService.createCaseDefinitionQuery().count());
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String caseDefinitionIdInSecondDeployment = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").deploymentId(secondDeploymentId).singleResult()).getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("myVersion", (Object)2).manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)caseDefinitionIdInSecondDeployment, (Object)subCaseInstance.getCaseDefinitionId());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputBusinessKey.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputBusinessKey() {
        String businessKey = "myBusinessKey";
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", businessKey).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)businessKey, (Object)subCaseInstance.getBusinessKey());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputDifferentBusinessKey.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputDifferentBusinessKey() {
        String businessKey = "myBusinessKey";
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", businessKey).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("myOwnBusinessKey", (Object)"myOwnBusinessKey").manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        String superCaseExecutionId = subCaseInstance.getSuperCaseExecutionId();
        CaseExecution superCaseExecution = this.queryCaseExecutionById(superCaseExecutionId);
        Assert.assertEquals((Object)caseTaskId, (Object)superCaseExecutionId);
        Assert.assertEquals((Object)superCaseInstanceId, (Object)superCaseExecution.getCaseInstanceId());
        Assert.assertEquals((Object)"myOwnBusinessKey", (Object)subCaseInstance.getBusinessKey());
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSourceWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputSource() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).setVariable("aThirdVariable", (Object)"def").manualStart();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSourceDifferentTarget.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputSourceDifferentTarget() {
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("aVariable", (Object)"abc");
        vars.putValue("anotherVariable", (Object)999);
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                Assert.assertEquals((Object)"myVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                Assert.assertEquals((Object)"myAnotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputSourceNullValue() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
            } else if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
            } else {
                Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            Assert.assertNull((Object)variable.getValue());
        }
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputSourceExpression.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputSourceExpression() {
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("aVariable", (Object)"abc");
        vars.putValue("anotherVariable", (Object)999);
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputAll.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputAll() {
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("aVariable", (Object)"abc");
        vars.putValue("anotherVariable", (Object)999);
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertCaseEnded(subCaseInstance.getId());
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testInputAllLocal.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testInputAllLocal() {
        this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariable("aVariable", (Object)"abc").setVariableLocal("aLocalVariable", (Object)"def").manualStart();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{subCaseInstance.getId()}).list();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aLocalVariable", (Object)((VariableInstance)variables.get(0)).getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCaseNotFound() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).manualStart();
            Assert.fail((String)"It should not be possible to start a not existing case instance.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.caseService.withCaseExecution(caseTaskId).disable();
        this.close(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCompleteSimpleCase() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNull((Object)caseTask);
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testOutputSource() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).setVariable("aThirdVariable", (Object)"def").execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSourceDifferentTarget.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testOutputSourceDifferentTarget() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("myVariable".equals(name)) {
                Assert.assertEquals((Object)"myVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("myAnotherVariable".equals(name)) {
                Assert.assertEquals((Object)"myAnotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSource.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testOutputSourceNullValue() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
            } else if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
            } else {
                Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
            }
            Assert.assertNull((Object)variable.getValue());
        }
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputSourceExpression.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testOutputSourceExpression() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)1000L, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputAll.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testOutputAll() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testOutputVariablesShouldNotExistAnymore.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testOutputVariablesShouldNotExistAnymore() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.caseService.withCaseExecution(caseTaskId).setVariableLocal("aVariable", (Object)"xyz").setVariableLocal("anotherVariable", (Object)123).manualStart();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertTrue((boolean)variables.isEmpty());
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testVariablesRoundtrip.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testVariablesRoundtrip() {
        VariableMapImpl vars = new VariableMapImpl();
        vars.putValue("aVariable", (Object)"xyz");
        vars.putValue("anotherVariable", (Object)123);
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase", (VariableMap)vars).getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.caseService.withCaseExecution(subCaseInstanceId).setVariable("aVariable", (Object)"abc").setVariable("anotherVariable", (Object)999).execute();
        String humanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        this.caseService.withCaseExecution(humanTaskId).complete();
        this.caseService.withCaseExecution(subCaseInstanceId).close();
        List variables = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{superCaseInstanceId}).list();
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            String name = variable.getName();
            if ("aVariable".equals(name)) {
                Assert.assertEquals((Object)"aVariable", (Object)name);
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if ("anotherVariable".equals(name)) {
                Assert.assertEquals((Object)"anotherVariable", (Object)name);
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Found an unexpected variable: '" + name + "'"));
        }
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCompleteCaseTask() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        try {
            this.caseService.withCaseExecution(caseTaskId).complete();
            Assert.fail((String)"It should not be possible to complete a case task, while the case instance is active.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminateCaseTask() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        this.terminate(caseTaskId);
        subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminateSubCaseInstance() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        CmmnExecution subCaseInstance = (CmmnExecution)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isTerminated());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNotNull((Object)caseTask);
        Assert.assertTrue((boolean)caseTask.isActive());
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSuspendCaseTask() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        this.suspend(caseTaskId);
        subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.terminate(superCaseInstanceId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testSuspendSubCaseInstance() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.suspend(subCaseInstanceId);
        CmmnExecution subCaseInstance = (CmmnExecution)this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        Assert.assertTrue((boolean)subCaseInstance.isSuspended());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNotNull((Object)caseTask);
        Assert.assertTrue((boolean)caseTask.isActive());
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testResumeCaseTask() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.suspend(caseTaskId);
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        this.resume(caseTaskId);
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertTrue((boolean)caseTask.isActive());
        subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertTrue((boolean)subCaseInstance.isActive());
        String subCaseInstanceId = this.queryOneTaskCaseInstance().getId();
        this.terminate(subCaseInstanceId);
        this.close(subCaseInstanceId);
        this.testRule.assertCaseEnded(subCaseInstanceId);
        this.terminate(caseTaskId);
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/casetask/CaseTaskTest.testNotBlockingCaseTask.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testNotBlockingCaseTask() {
        String superCaseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        CaseInstance subCaseInstance = this.queryOneTaskCaseInstance();
        Assert.assertNotNull((Object)subCaseInstance);
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertNull((Object)caseTask);
        CaseInstance superCaseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneCaseTaskCase").singleResult();
        Assert.assertNotNull((Object)superCaseInstance);
        Assert.assertTrue((boolean)superCaseInstance.isCompleted());
        this.close(superCaseInstanceId);
        this.testRule.assertCaseEnded(superCaseInstanceId);
        this.terminate(subCaseInstance.getId());
        this.close(subCaseInstance.getId());
        this.testRule.assertProcessEnded(subCaseInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testActivityType() {
        this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        CaseExecution caseTask = this.queryCaseExecutionByActivityId("PI_CaseTask_1");
        Assert.assertEquals((Object)"caseTask", (Object)caseTask.getActivityType());
    }

    @Override
    protected CaseInstance createCaseInstanceByKey(String caseDefinitionKey) {
        return this.createCaseInstanceByKey(caseDefinitionKey, null, null);
    }

    @Override
    protected CaseInstance createCaseInstanceByKey(String caseDefinitionKey, String businessKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).businessKey(businessKey).create();
    }

    @Override
    protected CaseExecution queryCaseExecutionById(String id) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().caseExecutionId(id).singleResult();
    }

    @Override
    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected CaseInstance queryOneTaskCaseInstance() {
        return (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

