/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CaseDefinitionBuilder;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.cmmn.operation.CaseExecutionStateTransitionCollector;
import org.camunda.bpm.engine.test.cmmn.operation.TaskWaitState;
import org.junit.Assert;
import org.junit.Test;

public class CaseInstanceCloseTest {
    @Test
    public void testCloseCompletedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("close", (CaseExecutionListener)stateTransitionCollector).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).property("manualActivationRule", TestHelper.defaultManualActivation()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.disable();
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        caseInstance.close();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("completed --close(Case1)--> closed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)caseInstance.isClosed());
    }

    @Test
    public void testCloseTerminatedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("close", (CaseExecutionListener)stateTransitionCollector).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        caseInstance.terminate();
        Assert.assertTrue((boolean)caseInstance.isTerminated());
        caseInstance.close();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("terminated --close(Case1)--> closed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)caseInstance.isClosed());
    }

    @Test
    public void testCloseSuspendedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("close", (CaseExecutionListener)stateTransitionCollector).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        caseInstance.suspend();
        Assert.assertTrue((boolean)caseInstance.isSuspended());
        caseInstance.close();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("suspended --close(Case1)--> closed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)caseInstance.isClosed());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
    }

    @Test
    public void testCloseActiveCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("close", (CaseExecutionListener)stateTransitionCollector).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        Assert.assertTrue((boolean)caseInstance.isActive());
        try {
            caseInstance.close();
        }
        catch (CaseIllegalStateTransitionException caseIllegalStateTransitionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("A"));
    }

    @Test
    public void testCloseTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("close", (CaseExecutionListener)stateTransitionCollector).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        try {
            taskA.close();
            Assert.fail((String)"It should not be possible to close a task.");
        }
        catch (CaseIllegalStateTransitionException caseIllegalStateTransitionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("A"));
    }

    @Test
    public void testCloseStage() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("close", (CaseExecutionListener)stateTransitionCollector).createActivity("X").behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        try {
            stageX.close();
            Assert.fail((String)"It should not be possible to close a stage.");
        }
        catch (CaseIllegalStateTransitionException caseIllegalStateTransitionException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("X"));
    }
}

