/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.SignalCmd;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

public class CompetingJoinTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected static ControllableThread activeThread;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Deployment
    @Test
    public void testCompetingJoins() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("CompetingJoinsProcess");
        Execution execution1 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("wait1").singleResult();
        Execution execution2 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("wait2").singleResult();
        LOG.debug("test thread starts thread one");
        SignalThread threadOne = new SignalThread(execution1.getId());
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        SignalThread threadTwo = new SignalThread(execution2.getId());
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    public class SignalThread
    extends ControllableThread {
        String executionId;
        OptimisticLockingException exception;

        public SignalThread(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingJoinTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new SignalCmd(this.executionId, null, null, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

