/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredDatabase(excludes={"cockroachdb"})
public class ConcurrentHistoryCleanupUpdateOfFailingJobTest
extends ConcurrencyTestHelper {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setHistoryCleanupBatchWindowStartTime("00:00"));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected int retries = 5;

    @Before
    public void initializeProcessEngine() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void tearDown() {
        this.testRule.deleteHistoryCleanupJobs();
    }

    @Test
    public void testFailedHistoryCleanupJobUpdate() throws InterruptedException {
        String cleanUpJobId = ((Job)this.historyService.findHistoryCleanupJobs().get(0)).getId();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(c -> {
            JobEntity cleanupJob = c.getJobManager().findJobById(cleanUpJobId);
            cleanupJob.setExceptionStacktrace("foo");
            return null;
        });
        ConcurrencyTestHelper.ThreadControl threadOne = this.executeControllableCommand(new JobUpdateCmd(cleanUpJobId));
        ConcurrencyTestHelper.ThreadControl threadTwo = this.executeControllableCommand(new ControllableBootstrap());
        threadTwo.reportInterrupts();
        threadOne.waitForSync();
        threadTwo.waitForSync();
        threadOne.makeContinue();
        threadOne.waitForSync();
        threadTwo.makeContinue();
        Thread.sleep(3000L);
        threadOne.waitUntilDone();
        threadTwo.waitUntilDone(true);
        Assertions.assertThat((Throwable)threadTwo.getException()).isNull();
        Job cleanupJob = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((int)cleanupJob.getRetries()).isEqualTo(this.retries);
        String stacktrace = this.managementService.getJobExceptionStacktrace(cleanupJob.getId());
        Assertions.assertThat((String)stacktrace).isEqualTo((Object)"foo");
    }

    public class JobUpdateCmd
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        private String jobId;

        public JobUpdateCmd(String jobId) {
            this.jobId = jobId;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getTransactionContext().addTransactionListener(TransactionState.COMMITTING, cc -> this.monitor.sync());
            this.monitor.sync();
            JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
            job.setRetries(ConcurrentHistoryCleanupUpdateOfFailingJobTest.this.retries);
            return null;
        }
    }

    public class ControllableBootstrap
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new BootstrapEngineCommand().execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

