/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency.partitioning;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.concurrency.partitioning.AbstractPartitioningTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Test;

public class CompetingHistoricByteArrayPartitioningTest
extends AbstractPartitioningTest {
    protected final String VARIABLE_NAME = "aVariableName";
    protected final String VARIABLE_VALUE = "aVariableValue";
    protected final String ANOTHER_VARIABLE_VALUE = "anotherVariableValue";

    @Test
    public void shouldSuppressOleOnConcurrentFetchAndDelete() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK, (Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)Variables.byteArrayValue((byte[])"aVariableValue".getBytes()))).getId();
        String[] historicByteArrayId = new String[1];
        this.commandExecutor.execute(commandContext -> {
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(processInstanceId);
            VariableInstanceEntity varInstance = (VariableInstanceEntity)execution.getVariableInstance("aVariableName");
            HistoricVariableInstanceEntity historicVariableInstance = commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstanceByVariableInstanceId(varInstance.getId());
            historicByteArrayId[0] = historicVariableInstance.getByteArrayValueId();
            return null;
        });
        ConcurrencyTestHelper.ThreadControl asyncThread = this.executeControllableCommand(new AsyncThread(processInstanceId, historicByteArrayId[0]));
        asyncThread.reportInterrupts();
        asyncThread.waitForSync();
        this.commandExecutor.execute(commandContext -> {
            commandContext.getByteArrayManager().deleteByteArrayById(historicByteArrayId[0]);
            return null;
        });
        this.commandExecutor.execute(commandContext -> {
            Assertions.assertThat((Object)((ByteArrayEntity)commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, historicByteArrayId[0]))).isNull();
            return null;
        });
        asyncThread.makeContinue();
        asyncThread.waitUntilDone();
        if (this.testRule.isOptimisticLockingExceptionSuppressible()) {
            Assertions.assertThat((String)((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getName()).isEqualTo((Object)"aVariableName");
            Assertions.assertThat((String)new String((byte[])((VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult()).getValue())).isEqualTo((Object)"anotherVariableValue");
        } else {
            Assertions.assertThat((Throwable)asyncThread.getException()).isInstanceOf(CrdbTransactionRetryException.class);
        }
    }

    public class AsyncThread
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        String processInstanceId;
        String historicByteArrayId;

        AsyncThread(String processInstanceId, String historicByteArrayId) {
            this.processInstanceId = processInstanceId;
            this.historicByteArrayId = historicByteArrayId;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, this.historicByteArrayId);
            this.monitor.sync();
            CompetingHistoricByteArrayPartitioningTest.this.runtimeService.setVariable(this.processInstanceId, "aVariableName", (Object)Variables.byteArrayValue((byte[])"anotherVariableValue".getBytes()));
            return null;
        }
    }
}

