/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.businessruletask;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;
import org.junit.Test;

public class DmnBusinessRuleTaskResultMappingTest
extends PluggableProcessEngineTest {
    protected static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml";
    protected static final String CUSTOM_MAPPING_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCustomOutputMapping.bpmn20.xml";
    protected static final String SINGLE_ENTRY_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml";
    protected static final String SINGLE_RESULT_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml";
    protected static final String COLLECT_ENTRIES_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml";
    protected static final String RESULT_LIST_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testResultList.bpmn20.xml";
    protected static final String DEFAULT_MAPPING_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml";
    protected static final String INVALID_MAPPING_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testInvalidMapping.bpmn20.xml";
    protected static final String OVERRIDE_DECISION_RESULT_BPMN = "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testOverrideVariable.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCustomOutputMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testCustomOutputMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries");
        Assert.assertEquals((Object)"foo", (Object)this.runtimeService.getVariable(processInstance.getId(), "result1"));
        Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)this.runtimeService.getVariableTyped(processInstance.getId(), "result1"));
        Assert.assertEquals((Object)"bar", (Object)this.runtimeService.getVariable(processInstance.getId(), "result2"));
        Assert.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)this.runtimeService.getVariableTyped(processInstance.getId(), "result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleEntryMapping() {
        ProcessInstance processInstance = this.startTestProcess("single entry");
        Assert.assertEquals((Object)"foo", (Object)this.runtimeService.getVariable(processInstance.getId(), "result"));
        Assert.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)this.runtimeService.getVariableTyped(processInstance.getId(), "result"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleResultMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries");
        Map output = (Map)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertEquals((long)2L, (long)output.size());
        Assert.assertEquals((Object)"foo", output.get("result1"));
        Assert.assertEquals((Object)"bar", output.get("result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testCollectEntriesMapping() {
        ProcessInstance processInstance = this.startTestProcess("single entry list");
        List output = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertEquals((long)2L, (long)output.size());
        Assert.assertEquals((Object)"foo", output.get(0));
        Assert.assertEquals((Object)"foo", output.get(1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testResultList.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testResultListMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries list");
        List resultList = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertEquals((long)2L, (long)resultList.size());
        for (Map valueMap : resultList) {
            Assert.assertEquals((long)2L, (long)valueMap.size());
            Assert.assertEquals((Object)"foo", valueMap.get("result1"));
            Assert.assertEquals((Object)"bar", valueMap.get("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testDefaultResultMapping() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries list");
        List resultList = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertEquals((long)2L, (long)resultList.size());
        for (Map valueMap : resultList) {
            Assert.assertEquals((long)2L, (long)valueMap.size());
            Assert.assertEquals((Object)"foo", valueMap.get("result1"));
            Assert.assertEquals((Object)"bar", valueMap.get("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleEntryMappingFailureMultipleOutputs() {
        try {
            this.startTestProcess("single entry list");
            Assert.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleEntryMappingFailureMultipleValues() {
        try {
            this.startTestProcess("multiple entries");
            Assert.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleResultMappingFailure() {
        try {
            this.startTestProcess("single entry list");
            Assert.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-22001", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testCollectEntriesMappingFailure() {
        try {
            this.startTestProcess("multiple entries");
            Assert.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-22002", e.getMessage());
        }
    }

    @Test
    public void testInvalidMapping() {
        try {
            this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(INVALID_MAPPING_BPMN));
            Assert.fail((String)"expect parse exception");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("No decision result mapper found for name 'invalid'", e.getMessage());
            Assertions.assertThat((int)((ResourceReport)e.getResorceReports().get(0)).getErrors().size()).isEqualTo(1);
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"ruleTask");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testTransientDecisionResult() {
        ProcessInstance processInstance = this.startTestProcess("single entry");
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "decisionResult"));
        Assert.assertNull((Object)this.historyService.createHistoricVariableInstanceQuery().variableName("decisionResult").singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testOverrideVariable.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testFailedToOverrideDecisionResultVariable() {
        try {
            this.startTestProcess("single entry");
            Assert.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("transient variable with name decisionResult to non-transient", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleEntry.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleEntryEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        Object result = this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertNull((Object)result);
        TypedValue resultTyped = this.runtimeService.getVariableTyped(processInstance.getId(), "result");
        Assert.assertEquals((Object)Variables.untypedNullValue(), (Object)resultTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testSingleResult.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testSingleResultEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        Object result = this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertNull((Object)result);
        TypedValue resultTyped = this.runtimeService.getVariableTyped(processInstance.getId(), "result");
        Assert.assertEquals((Object)Variables.untypedNullValue(), (Object)resultTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testCollectEntries.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testCollectEntriesEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        List result = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testResultList.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testResultListEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        List result = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.testDefaultMapping.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/result/DmnBusinessRuleTaskResultMappingTest.dmn11.xml"})
    @Test
    public void testDefaultMappingEmptyResult() {
        ProcessInstance processInstance = this.startTestProcess("empty result");
        List result = (List)this.runtimeService.getVariable(processInstance.getId(), "result");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    protected ProcessInstance startTestProcess(String input) {
        return this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("input", input));
    }
}

