/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.errorcode;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ExceptionBuiltinCodesTest {
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.cmd"}).level(Level.WARN);
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule);
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void clear() {
        this.engineRule.getIdentityService().deleteUser("kermit");
        this.engineRule.getAuthorizationService().createAuthorizationQuery().list().forEach(authorization -> this.authorizationService.deleteAuthorization(authorization.getId()));
        this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceBusinessKey("sub-process").list().forEach(pi -> this.runtimeService.deleteProcessInstance(pi.getProcessInstanceId(), ""));
    }

    @Test
    public void shouldHaveColumnSizeTooSmallErrorCode() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.engineTestRule.deploy(modelInstance);
        String businessKey = this.generateString(1000);
        Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("process", businessKey)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.COLUMN_SIZE_TOO_SMALL.getCode()});
    }

    @Test
    public void shouldHaveDefaultErrorCodeUniqueKeyConstraintPersistenceExceptionNotCovered() {
        Authorization authorizationOne = this.authorizationService.createNewAuthorization(1);
        authorizationOne.setGroupId("aUserId");
        authorizationOne.setPermissions(new Permission[]{TaskPermissions.READ});
        authorizationOne.setResourceId("foo");
        authorizationOne.setResource((Resource)Resources.TASK);
        this.authorizationService.saveAuthorization(authorizationOne);
        Authorization authorizationTwo = this.authorizationService.createNewAuthorization(1);
        authorizationTwo.setGroupId("aUserId");
        authorizationTwo.setPermissions(new Permission[]{TaskPermissions.READ});
        authorizationTwo.setResourceId("foo");
        authorizationTwo.setResource((Resource)Resources.TASK);
        Assertions.assertThatThrownBy(() -> this.authorizationService.saveAuthorization(authorizationTwo)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FALLBACK.getCode()});
        Assertions.assertThat((List)this.loggingRule.getLog()).isEmpty();
    }

    @Test
    public void shouldHaveOleErrorCode() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        user2.setFirstName("name two");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.saveUser(user2)).isInstanceOf(OptimisticLockingException.class)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.OPTIMISTIC_LOCKING.getCode()});
    }

    @Test
    public void shouldHaveForeignKeyConstraintViolationCode() {
        BpmnModelInstance modelInstance = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).camundaInBusinessKey("sub-process")).endEvent().done();
        this.engineTestRule.deploy(modelInstance);
        modelInstance = Bpmn.createExecutableProcess((String)"called").startEvent().userTask().endEvent().done();
        this.engineTestRule.deploy(modelInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calling").getId();
        List executions = this.runtimeService.createExecutionQuery().list();
        executions.forEach(execution -> {
            ((ExecutionEntity)execution).setCachedEntityState(0);
            this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute(commandContext -> {
                commandContext.getDbEntityManager().merge((DbEntity)((ExecutionEntity)execution));
                return null;
            });
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.deleteProcessInstance(processInstanceId, "")).isInstanceOf(ProcessEngineException.class)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FOREIGN_KEY_CONSTRAINT_VIOLATION.getCode()});
    }

    protected String generateString(int size) {
        return new String(new char[size]).replace('\u0000', 'a');
    }
}

