/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricActivityInstanceStateTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSingleEndEvent() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "start", 1);
        this.assertNonCanceledActivityInstance(allInstances, "start");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testSingleEndActivity() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "start", 1);
        this.assertNonCanceledActivityInstance(allInstances, "start");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testSingleEndEventAfterParallelJoin() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelJoin", 2);
        this.assertNonCanceledActivityInstance(allInstances, "parallelJoin");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testEndParallelJoin() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "task1", 1);
        this.assertNonCanceledActivityInstance(allInstances, "task1");
        this.assertNonCompletingActivityInstance(allInstances, "task2", 1);
        this.assertNonCanceledActivityInstance(allInstances, "task2");
        this.assertIsCompletingActivityInstances(allInstances, "parallelJoinEnd", 2);
        this.assertNonCanceledActivityInstance(allInstances, "parallelJoinEnd");
    }

    @Deployment
    @Test
    public void testTwoEndEvents() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelSplit", 1);
        this.assertNonCanceledActivityInstance(allInstances, "parallelSplit", 1);
        this.assertIsCompletingActivityInstances(allInstances, "end1", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end1");
        this.assertIsCompletingActivityInstances(allInstances, "end2", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end2");
    }

    @Deployment
    @Test
    public void testTwoEndActivities() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelSplit", 1);
        this.assertNonCanceledActivityInstance(allInstances, "parallelSplit");
        this.assertIsCompletingActivityInstances(allInstances, "end1", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end1");
        this.assertIsCompletingActivityInstances(allInstances, "end2", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end2");
    }

    @Deployment
    @Test
    public void testSingleEndEventAndSingleEndActivity() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "parallelSplit", 1);
        this.assertNonCanceledActivityInstance(allInstances, "parallelSplit");
        this.assertIsCompletingActivityInstances(allInstances, "end1");
        this.assertNonCanceledActivityInstance(allInstances, "end1");
        this.assertIsCompletingActivityInstances(allInstances, "end2");
        this.assertNonCanceledActivityInstance(allInstances, "end2");
    }

    @Deployment
    @Test
    public void testSimpleSubProcess() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "intermediateSubprocess", 1);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess");
        this.assertIsCompletingActivityInstances(allInstances, "subprocessEnd", 1);
        this.assertNonCanceledActivityInstance(allInstances, "subprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testParallelMultiInstanceSubProcess() {
        this.startProcess();
        List<HistoricActivityInstance> activityInstances = this.getEndActivityInstances();
        Assert.assertEquals((long)7L, (long)activityInstances.size());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCompletingActivityInstances(allInstances, "intermediateSubprocess", 3);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess");
        this.assertIsCompletingActivityInstances(allInstances, "subprocessEnd", 3);
        this.assertNonCanceledActivityInstance(allInstances, "subprocessEnd");
        this.assertNonCompletingActivityInstance(allInstances, "intermediateSubprocess#multiInstanceBody", 1);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess#multiInstanceBody");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testSequentialMultiInstanceSubProcess() {
        this.startProcess();
        List<HistoricActivityInstance> activityInstances = this.getEndActivityInstances();
        Assert.assertEquals((long)7L, (long)activityInstances.size());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCompletingActivityInstances(allInstances, "intermediateSubprocess", 3);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess");
        this.assertIsCompletingActivityInstances(allInstances, "subprocessEnd", 3);
        this.assertNonCanceledActivityInstance(allInstances, "subprocessEnd");
        this.assertNonCompletingActivityInstance(allInstances, "intermediateSubprocess#multiInstanceBody", 1);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateSubprocess#multiInstanceBody");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testIntermediateTask() {
        this.startProcess();
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "intermediateTask", 1);
        this.assertNonCanceledActivityInstance(allInstances, "intermediateTask");
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testBoundaryErrorCancel() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCanceledActivityInstance(allInstances, "start");
        this.assertNonCompletingActivityInstance(allInstances, "start");
        this.assertNonCanceledActivityInstance(allInstances, "subprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "subprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "gtw");
        this.assertNonCompletingActivityInstance(allInstances, "gtw");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "errorSubprocessEnd", 1);
        this.assertNonCompletingActivityInstance(allInstances, "errorSubprocessEnd");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCompletingActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCanceledActivityInstance(allInstances, "endAfterBoundary");
        this.assertIsCompletingActivityInstances(allInstances, "endAfterBoundary", 1);
    }

    @Deployment
    @Test
    public void testBoundarySignalCancel() {
        ProcessInstance processInstance = this.startProcess();
        Assert.assertFalse((boolean)processInstance.isEnded());
        this.runtimeService.signalEventReceived("interrupt");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCompletingActivityInstance(allInstances, "subprocessBoundary");
        this.assertNonCanceledActivityInstance(allInstances, "endAfterBoundary");
        this.assertIsCompletingActivityInstances(allInstances, "endAfterBoundary", 1);
    }

    @Deployment
    @Test
    public void testEventSubprocessErrorCancel() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertIsCanceledActivityInstances(allInstances, "errorEnd", 1);
        this.assertNonCompletingActivityInstance(allInstances, "errorEnd");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "eventSubprocessEnd", 1);
    }

    @Deployment
    @Test
    public void testEventSubprocessMessageCancel() {
        this.startProcess();
        this.runtimeService.correlateMessage("message");
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "eventSubprocessEnd", 1);
    }

    @Deployment
    @Test
    public void testEventSubprocessSignalCancel() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertIsCanceledActivityInstances(allInstances, "signalEnd", 1);
        this.assertNonCompletingActivityInstance(allInstances, "signalEnd");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCompletingActivityInstance(allInstances, "eventSubprocessStart");
        this.assertNonCanceledActivityInstance(allInstances, "eventSubprocessEnd");
        this.assertIsCompletingActivityInstances(allInstances, "eventSubprocessEnd", 1);
    }

    @Deployment
    @Test
    public void testEndTerminateEventCancel() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
    }

    @Deployment
    @Test
    public void testEndTerminateEventCancelInSubprocess() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertNonCanceledActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
        this.assertIsCompletingActivityInstances(allInstances, "end", 1);
        this.assertNonCanceledActivityInstance(allInstances, "end");
    }

    @Deployment
    @Test
    public void testEndTerminateEventCancelWithSubprocess() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceStateTest.testCancelProcessInstanceInUserTask.bpmn", "org/camunda/bpm/engine/test/history/HistoricActivityInstanceStateTest.testEndTerminateEventWithCallActivity.bpmn"})
    @Test
    public void testEndTerminateEventCancelWithCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process1");
        this.runtimeService.correlateMessage("continue");
        this.testRule.assertProcessEnded(processInstance.getId());
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "callActivity", 1);
        this.assertNonCompletingActivityInstance(allInstances, "callActivity");
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertNonCanceledActivityInstance(allInstances, "terminateEnd");
        this.assertIsCompletingActivityInstances(allInstances, "terminateEnd", 1);
    }

    @Deployment
    @Test
    public void testCancelProcessInstanceInUserTask() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
    }

    @Deployment
    @Test
    public void testCancelProcessInstanceInSubprocess() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
    }

    @Deployment
    @Test
    public void testCancelProcessWithParallelGateway() {
        ProcessInstance processInstance = this.startProcess();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        List<HistoricActivityInstance> allInstances = this.getAllActivityInstances();
        this.assertIsCanceledActivityInstances(allInstances, "userTask1", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask1");
        this.assertIsCanceledActivityInstances(allInstances, "userTask2", 1);
        this.assertNonCompletingActivityInstance(allInstances, "userTask2");
        this.assertIsCanceledActivityInstances(allInstances, "subprocess", 1);
        this.assertNonCompletingActivityInstance(allInstances, "subprocess");
    }

    private void assertIsCanceledActivityInstances(List<HistoricActivityInstance> allInstances, String activityId, int count) {
        this.assertCorrectCanceledState(allInstances, activityId, count, true);
    }

    private void assertNonCanceledActivityInstance(List<HistoricActivityInstance> instances, String activityId) {
        this.assertNonCanceledActivityInstance(instances, activityId, -1);
    }

    private void assertNonCanceledActivityInstance(List<HistoricActivityInstance> instances, String activityId, int count) {
        this.assertCorrectCanceledState(instances, activityId, count, false);
    }

    private void assertCorrectCanceledState(List<HistoricActivityInstance> allInstances, String activityId, int expectedCount, boolean canceled) {
        int found = 0;
        for (HistoricActivityInstance instance : allInstances) {
            if (!instance.getActivityId().equals(activityId)) continue;
            ++found;
            Assert.assertEquals((String)String.format("expect <%s> to be %scanceled", activityId, canceled ? "" : "non-"), (Object)canceled, (Object)instance.isCanceled());
        }
        Assert.assertTrue((String)("contains entry for activity <" + activityId + ">"), (found > 0 ? 1 : 0) != 0);
        if (expectedCount != -1) {
            Assert.assertTrue((String)("contains <" + expectedCount + "> entries for activity <" + activityId + ">"), (found == expectedCount ? 1 : 0) != 0);
        }
    }

    private void assertIsCompletingActivityInstances(List<HistoricActivityInstance> allInstances, String activityId) {
        this.assertIsCompletingActivityInstances(allInstances, activityId, -1);
    }

    private void assertIsCompletingActivityInstances(List<HistoricActivityInstance> allInstances, String activityId, int count) {
        this.assertCorrectCompletingState(allInstances, activityId, count, true);
    }

    private void assertNonCompletingActivityInstance(List<HistoricActivityInstance> instances, String activityId) {
        this.assertNonCompletingActivityInstance(instances, activityId, -1);
    }

    private void assertNonCompletingActivityInstance(List<HistoricActivityInstance> instances, String activityId, int count) {
        this.assertCorrectCompletingState(instances, activityId, count, false);
    }

    private void assertCorrectCompletingState(List<HistoricActivityInstance> allInstances, String activityId, int expectedCount, boolean completing) {
        int found = 0;
        for (HistoricActivityInstance instance : allInstances) {
            if (!instance.getActivityId().equals(activityId)) continue;
            ++found;
            Assert.assertEquals((String)String.format("expect <%s> to be %scompleting", activityId, completing ? "" : "non-"), (Object)completing, (Object)instance.isCompleteScope());
        }
        Assert.assertTrue((String)("contains entry for activity <" + activityId + ">"), (found > 0 ? 1 : 0) != 0);
        if (expectedCount != -1) {
            Assert.assertTrue((String)("contains <" + expectedCount + "> entries for activity <" + activityId + ">"), (found == expectedCount ? 1 : 0) != 0);
        }
    }

    private List<HistoricActivityInstance> getEndActivityInstances() {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceEndTime().asc()).completeScope().list();
    }

    private List<HistoricActivityInstance> getAllActivityInstances() {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).list();
    }

    private ProcessInstance startProcess() {
        return this.runtimeService.startProcessInstanceByKey("process");
    }
}

