/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.BackoffJobAcquisitionStrategy;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BackoffJobAcquisitionStrategyTest {
    protected static final long BASE_IDLE_WAIT_TIME = 50L;
    protected static final float IDLE_INCREASE_FACTOR = 1.5f;
    protected static final long MAX_IDLE_TIME = 500L;
    protected static final long BASE_BACKOFF_WAIT_TIME = 80L;
    protected static final float BACKOFF_INCREASE_FACTOR = 2.0f;
    protected static final long MAX_BACKOFF_TIME = 1000L;
    protected static final int DECREASE_THRESHOLD = 3;
    protected static final int NUM_JOBS_TO_ACQUIRE = 10;
    protected static final String ENGINE_NAME = "engine";
    protected JobAcquisitionStrategy strategy;

    @Before
    public void setUp() {
        this.strategy = new BackoffJobAcquisitionStrategy(50L, 1.5f, 500L, 80L, 2.0f, 1000L, 3, 10);
    }

    @Test
    public void testIdleWaitTime() {
        JobAcquisitionContext context = new JobAcquisitionContext();
        context.submitAcquiredJobs(ENGINE_NAME, this.buildAcquiredJobs(10, 0, 0));
        this.strategy.reconfigure(context);
        Assert.assertEquals((long)50L, (long)this.strategy.getWaitTime());
        for (int idleLevel = 1; idleLevel < 6; ++idleLevel) {
            context.reset();
            context.submitAcquiredJobs(ENGINE_NAME, this.buildAcquiredJobs(10, 0, 0));
            this.strategy.reconfigure(context);
            Assert.assertEquals((long)((long)(50.0 * Math.pow(1.5, idleLevel))), (long)this.strategy.getWaitTime());
        }
        context.reset();
        context.submitAcquiredJobs(ENGINE_NAME, this.buildAcquiredJobs(10, 0, 0));
        this.strategy.reconfigure(context);
        Assert.assertEquals((long)500L, (long)this.strategy.getWaitTime());
    }

    @Test
    public void testAcquisitionAfterIdleWait() {
        JobAcquisitionContext context = new JobAcquisitionContext();
        context.submitAcquiredJobs(ENGINE_NAME, this.buildAcquiredJobs(10, 0, 0));
        this.strategy.reconfigure(context);
        Assert.assertEquals((long)50L, (long)this.strategy.getWaitTime());
        context.reset();
        context.submitAcquiredJobs(ENGINE_NAME, this.buildAcquiredJobs(10, 10, 0));
        this.strategy.reconfigure(context);
        Assert.assertEquals((long)0L, (long)this.strategy.getWaitTime());
    }

    @Test
    public void testAcquireLessJobsOnRejection() {
        JobAcquisitionContext context = new JobAcquisitionContext();
        AcquiredJobs acquiredJobs = this.buildAcquiredJobs(10, 10, 0);
        context.submitAcquiredJobs(ENGINE_NAME, acquiredJobs);
        int numJobsRejected = 5;
        for (int i = 0; i < numJobsRejected; ++i) {
            context.submitRejectedBatch(ENGINE_NAME, (List)acquiredJobs.getJobIdBatches().get(i));
        }
        this.strategy.reconfigure(context);
        Assert.assertEquals((long)(10 - numJobsRejected), (long)this.strategy.getNumJobsToAcquire(ENGINE_NAME));
        Assert.assertEquals((long)0L, (long)this.strategy.getWaitTime());
    }

    @Test
    public void testWaitTimeOnFullRejection() {
        JobAcquisitionContext context = new JobAcquisitionContext();
        AcquiredJobs acquiredJobs = this.buildAcquiredJobs(10, 10, 0);
        context.submitAcquiredJobs(ENGINE_NAME, acquiredJobs);
        for (int i = 0; i < 10; ++i) {
            context.submitRejectedBatch(ENGINE_NAME, (List)acquiredJobs.getJobIdBatches().get(i));
        }
        this.strategy.reconfigure(context);
        Assert.assertEquals((long)BackoffJobAcquisitionStrategy.DEFAULT_EXECUTION_SATURATION_WAIT_TIME, (long)this.strategy.getWaitTime());
    }

    protected AcquiredJobs buildAcquiredJobs(int numJobsToAcquire, int numJobsAcquired, int numJobsFailedToLock) {
        int i;
        AcquiredJobs acquiredJobs = new AcquiredJobs(numJobsToAcquire);
        for (i = 0; i < numJobsAcquired; ++i) {
            acquiredJobs.addJobIdBatch(Arrays.asList(Integer.toString(i)));
        }
        for (i = 0; i < numJobsFailedToLock; ++i) {
            acquiredJobs.removeJobId(Integer.toString(i));
        }
        return acquiredJobs;
    }
}

