/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class JobDefinitionDeploymentTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testTimerStartEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-start-event", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theStart", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DATE: 2036-11-14T11:12:22", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
        Job timerStartJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((Object)jobDefinition.getId(), (Object)timerStartJob.getJobDefinitionId());
    }

    @Deployment
    @Test
    public void testTimerBoundaryEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-transition", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theBoundaryEvent", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DATE: 2036-11-14T11:12:22", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    @Test
    public void testMultipleTimerBoundaryEvents() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess");
        Assert.assertEquals((long)2L, (long)jobDefinitionQuery.count());
        JobDefinition jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"theBoundaryEvent1"}).singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-transition", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theBoundaryEvent1", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DATE: 2036-11-14T11:12:22", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
        jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"theBoundaryEvent2"}).singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-transition", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theBoundaryEvent2", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DURATION: PT5M", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    @Test
    public void testEventBasedGateway() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess");
        Assert.assertEquals((long)2L, (long)jobDefinitionQuery.count());
        JobDefinition jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"timer1"}).singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-intermediate-transition", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"timer1", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DURATION: PT5M", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
        jobDefinition = (JobDefinition)jobDefinitionQuery.activityIdIn(new String[]{"timer2"}).singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-intermediate-transition", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"timer2", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DURATION: PT10M", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    @Test
    public void testTimerIntermediateEvent() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"timer-intermediate-transition", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"timer", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"DURATION: PT5M", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    @Test
    public void testAsyncContinuation() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"async-continuation", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theService", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"async-before", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    @Test
    public void testAsyncContinuationOfMultiInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"async-continuation", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theService#multiInstanceBody", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"async-after", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment
    @Test
    public void testAsyncContinuationOfActivityWrappedInMultiInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey("testProcess").singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"async-continuation", (Object)jobDefinition.getJobType());
        Assert.assertEquals((Object)"theService", (Object)jobDefinition.getActivityId());
        Assert.assertEquals((Object)"async-after", (Object)jobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)jobDefinition.getProcessDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testAsyncContinuation.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/JobDefinitionDeploymentTest.testMultipleProcessesWithinDeployment.bpmn20.xml"})
    @Test
    public void testMultipleProcessDeployment() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        List jobDefinitions = query.list();
        Assert.assertEquals((long)3L, (long)jobDefinitions.size());
        Assert.assertEquals((long)1L, (long)query.processDefinitionKey("testProcess").list().size());
        Assert.assertEquals((long)2L, (long)query.processDefinitionKey("anotherTestProcess").list().size());
    }
}

