/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import java.util.concurrent.Callable;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.engine.impl.scripting.env.ScriptEnvResolver;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractScriptEnvironmentTest
extends PluggableProcessEngineTest {
    protected final String processPath = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected ScriptEnvResolver resolver;
    protected ScriptFactory scriptFactory;
    protected EmbeddedProcessApplication processApplication;

    @Before
    public void setUp() {
        this.scriptFactory = this.processEngineConfiguration.getScriptFactory();
        this.resolver = this.getResolver();
        this.processEngineConfiguration.getEnvScriptResolvers().add(this.resolver);
        this.processApplication = new EmbeddedProcessApplication();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.getEnvScriptResolvers().remove(this.resolver);
    }

    protected abstract ScriptEnvResolver getResolver();

    protected abstract String getScript();

    protected void executeScript(final ProcessApplicationInterface processApplication, final String language) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                return (Void)Context.executeWithinProcessApplication((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ScriptingEngines scriptingEngines = AbstractScriptEnvironmentTest.this.processEngineConfiguration.getScriptingEngines();
                        ScriptEngine scriptEngine = scriptingEngines.getScriptEngineForLanguage(language);
                        SourceExecutableScript script = AbstractScriptEnvironmentTest.this.createScript(language, AbstractScriptEnvironmentTest.this.getScript());
                        ScriptingEnvironment scriptingEnvironment = AbstractScriptEnvironmentTest.this.processEngineConfiguration.getScriptingEnvironment();
                        Bindings bindings = scriptingEngines.createBindings(scriptEngine, null);
                        scriptingEnvironment.execute((ExecutableScript)script, null, bindings, scriptEngine);
                        return null;
                    }
                }, (ProcessApplicationReference)processApplication.getReference());
            }
        });
    }

    protected SourceExecutableScript createScript(String language, String source) {
        return (SourceExecutableScript)this.scriptFactory.createScriptFromSource(language, source);
    }
}

