/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.engine.impl.scripting.env.ScriptEnvResolver;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.test.standalone.scripting.AbstractScriptEnvironmentTest;
import org.junit.Test;

public class EnvScriptResolutionTest
extends AbstractScriptEnvironmentTest {
    protected static final String SCRIPT_LANGUAGE = "graal.js";
    protected static final String ECMASCRIPT_LANGUAGE = "ecmascript";
    protected static final String SCRIPT = "print('hello world');";
    protected static final String ENV_SCRIPT = "print('hello world from env script');";

    @Override
    protected ScriptEnvResolver getResolver() {
        return language -> {
            String[] stringArray;
            if (ECMASCRIPT_LANGUAGE.equals(language)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ENV_SCRIPT;
            } else {
                stringArray = null;
            }
            return stringArray;
        };
    }

    @Override
    protected String getScript() {
        return SCRIPT;
    }

    @Test
    public void shouldFindEnvScriptForLanguage() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        this.executeScript((ProcessApplicationInterface)this.processApplication, ECMASCRIPT_LANGUAGE);
        Map environmentScripts = this.processApplication.getEnvironmentScripts();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)environmentScripts).hasSize(1)).containsKey((Object)ECMASCRIPT_LANGUAGE)).extracting(new String[]{ECMASCRIPT_LANGUAGE}).hasSize(1);
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void shouldFindEnvScriptForScriptEngineLanguageIfLanguageNotFound() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        this.executeScript((ProcessApplicationInterface)this.processApplication, SCRIPT_LANGUAGE);
        Map environmentScripts = this.processApplication.getEnvironmentScripts();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)environmentScripts).hasSize(2)).containsKeys((Object[])new String[]{ECMASCRIPT_LANGUAGE, SCRIPT_LANGUAGE}).containsEntry((Object)SCRIPT_LANGUAGE, Collections.emptyList())).extracting(new String[]{ECMASCRIPT_LANGUAGE}).hasSize(1);
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }
}

