/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

/**
 * Callback for being notified when a model instance has started.
 *
 * @author Daniel Meyer
 *
 */
public class ProcessInstanceStartContext {

  protected ActivityImpl initial;

  /**
   * @param initial
   */
  public ProcessInstanceStartContext(ActivityImpl initial) {
    this.initial = initial;
  }

  public ActivityImpl getInitial() {
    return initial;
  }

  public void setInitial(ActivityImpl initial) {
    this.initial = initial;
  }

  public void initialStarted(PvmExecutionImpl execution) {
    // do nothing
  }

  public boolean isAsync() {
    return initial.isAsync();
  }

}
