/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplication;
import org.camunda.bpm.application.impl.ServletProcessApplication;

@HandlesTypes(value={ProcessApplication.class})
public class ServletProcessApplicationDeployer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(ServletProcessApplicationDeployer.class.getName());

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (c == null || c.isEmpty()) {
            return;
        }
        if (c.size() > 1) {
            String msg = this.getLogMultiplePas(c, ctx);
            LOGGER.log(Level.SEVERE, msg);
            throw new ServletException(msg);
        }
        Class<?> paClass = c.iterator().next();
        if (!AbstractProcessApplication.class.isAssignableFrom(paClass)) {
            String msg = this.getLogWrongType(paClass);
            LOGGER.log(Level.SEVERE, msg);
            throw new ServletException(msg);
        }
        if (ServletProcessApplication.class.isAssignableFrom(paClass)) {
            LOGGER.info("Detected @ProcessApplication class " + paClass.getName());
            ctx.addListener(paClass.getName());
        }
    }

    protected String getLogWrongType(Class<?> paClass) {
        String msg = "Class '" + paClass + "' is annotated with @" + ProcessApplication.class.getName() + " " + "but is not a subclass of " + AbstractProcessApplication.class.getName();
        return msg;
    }

    protected String getLogMultiplePas(Set<Class<?>> c, ServletContext ctx) {
        StringBuilder builder = new StringBuilder();
        builder.append("An application must not contain more than one class annotated with @ProcessApplication.\n Application '");
        builder.append(ctx.getContextPath());
        builder.append("' contains the following @ProcessApplication classes:\n");
        for (Class<?> clazz : c) {
            builder.append("  ");
            builder.append(clazz.getName());
            builder.append("\n");
        }
        String msg = builder.toString();
        return msg;
    }
}

