/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.kernel;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanService;
import org.camunda.bpm.engine.ProcessEngineException;

public class MBeanServiceContainer {
    protected MBeanServer mBeanServer;
    protected Map<ObjectName, MBeanService<?>> servicesByName = new ConcurrentHashMap();
    protected ThreadLocal<Stack<MBeanDeploymentOperation>> activeDeploymentOperations = new ThreadLocal();

    public synchronized <S> void startService(ServiceType serviceType, String localName, MBeanService<S> service) {
        ObjectName serviceName = serviceType.getServiceName(localName);
        this.startService(serviceName, service);
    }

    public synchronized <S> void startService(ObjectName serviceName, MBeanService<S> service) {
        if (this.getService(serviceName) != null) {
            throw new ProcessEngineException("Cannot register service " + serviceName + " with MBeans Container, service with same name already registered.");
        }
        MBeanServer beanServer = this.getmBeanServer();
        service.start(this);
        try {
            beanServer.registerMBean(service, serviceName);
            this.servicesByName.put(serviceName, service);
            Stack<MBeanDeploymentOperation> currentOperationContext = this.activeDeploymentOperations.get();
            if (currentOperationContext != null) {
                currentOperationContext.peek().serviceAdded(serviceName);
            }
        }
        catch (Exception e) {
            throw new ProcessEngineException("Could not register service " + serviceName + " with the MBean server", e);
        }
    }

    public synchronized void stopService(ServiceType serviceType, String localName) {
        ObjectName serviceName = serviceType.getServiceName(localName);
        this.stopService(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopService(ObjectName serviceName) {
        MBeanServer mBeanServer = this.getmBeanServer();
        MBeanService service = (MBeanService)this.getService(serviceName);
        if (service == null) {
            throw new ProcessEngineException("Cannot stop service " + serviceName + ": no such service registered.");
        }
        try {
            service.stop(this);
        }
        finally {
            try {
                mBeanServer.unregisterMBean(serviceName);
                this.servicesByName.remove(serviceName);
            }
            catch (Throwable t) {
                throw new ProcessEngineException("Exception while unregistering " + serviceName.getCanonicalName() + " with the MBeanServer", t);
            }
        }
    }

    public MBeanDeploymentOperation.MBeanDeploymentOperationBuilder createDeploymentOperation(String name) {
        return new MBeanDeploymentOperation.MBeanDeploymentOperationBuilder(this, name);
    }

    public MBeanDeploymentOperation.MBeanDeploymentOperationBuilder createUndeploymentOperation(String name) {
        MBeanDeploymentOperation.MBeanDeploymentOperationBuilder builder = new MBeanDeploymentOperation.MBeanDeploymentOperationBuilder(this, name);
        builder.setUndeploymentOperation();
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDeploymentOperation(MBeanDeploymentOperation operation) {
        Stack<MBeanDeploymentOperation> currentOperationContext = this.activeDeploymentOperations.get();
        if (currentOperationContext == null) {
            currentOperationContext = new Stack();
            this.activeDeploymentOperations.set(currentOperationContext);
        }
        try {
            currentOperationContext.push(operation);
            operation.execute();
        }
        finally {
            currentOperationContext.pop();
            if (currentOperationContext.isEmpty()) {
                this.activeDeploymentOperations.remove();
            }
        }
    }

    public <S> S getService(ServiceType type, String localName) {
        ObjectName serviceName = type.getServiceName(localName);
        return this.getService(serviceName);
    }

    protected <S> S getService(ObjectName name) {
        return (S)this.servicesByName.get(name);
    }

    protected <S> S getServiceValue(ObjectName name) {
        MBeanService service = (MBeanService)this.getService(name);
        if (service != null) {
            return service.getValue();
        }
        return null;
    }

    public <S> S getServiceValue(ServiceType type, String localName) {
        ObjectName serviceName = type.getServiceName(localName);
        return this.getServiceValue(serviceName);
    }

    public <S> List<MBeanService<S>> getServicesByType(ServiceType type) {
        Set<ObjectName> serviceNames = this.getServiceNames(type);
        ArrayList<MBeanService<S>> res = new ArrayList<MBeanService<S>>();
        for (ObjectName serviceName : serviceNames) {
            res.add(this.servicesByName.get(serviceName));
        }
        return res;
    }

    public Set<ObjectName> getServiceNames(ServiceType type) {
        return this.getmBeanServer().queryNames(type.getTypeName(), null);
    }

    public <S> List<S> getServiceValuesByType(ServiceType type) {
        Set<ObjectName> serviceNames = this.getServiceNames(type);
        ArrayList res = new ArrayList();
        for (ObjectName serviceName : serviceNames) {
            MBeanService<?> mbeanService = this.servicesByName.get(serviceName);
            if (mbeanService == null) continue;
            res.add(mbeanService.getValue());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServer getmBeanServer() {
        if (this.mBeanServer == null) {
            MBeanServiceContainer mBeanServiceContainer = this;
            synchronized (mBeanServiceContainer) {
                if (this.mBeanServer == null) {
                    this.mBeanServer = this.createOrLookupMbeanServer();
                }
            }
        }
        return this.mBeanServer;
    }

    public void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    protected MBeanServer createOrLookupMbeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static interface ServiceType {
        public ObjectName getServiceName(String var1);

        public ObjectName getTypeName();
    }
}

