/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import javax.script.CompiledScript;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.scripting.ScriptingEngines;

public class ScriptInvocationHandler {
    protected String script;
    protected String language;
    protected String resultVariable;
    protected CompiledScript compiledScript;
    protected boolean isScriptCompilationSupported = true;

    public ScriptInvocationHandler(String script, String language, String resultVariable) {
        this.script = script;
        this.language = language;
        this.resultVariable = resultVariable;
    }

    public void evaluate(VariableScope variableScope) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ScriptingEngines scriptingEngines = processEngineConfiguration.getScriptingEngines();
        if (processEngineConfiguration.isEnableScriptCompilation()) {
            this.preCompileScript(scriptingEngines);
        }
        Object result = null;
        result = this.compiledScript == null ? scriptingEngines.evaluate(this.script, this.language, variableScope) : scriptingEngines.evaluate(this.compiledScript, this.language, variableScope);
        if (this.resultVariable != null) {
            variableScope.setVariable(this.resultVariable, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preCompileScript(ScriptingEngines scriptingEngines) {
        if (this.compiledScript == null && this.isScriptCompilationSupported) {
            ScriptInvocationHandler scriptInvocationHandler = this;
            synchronized (scriptInvocationHandler) {
                if (this.compiledScript == null && this.isScriptCompilationSupported) {
                    this.compiledScript = scriptingEngines.compile(this.script, this.language);
                    this.isScriptCompilationSupported = this.compiledScript != null;
                }
            }
        }
    }
}

