/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import javax.script.ScriptException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.ScriptInvocationHandler;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagation;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected ScriptInvocationHandler invocationHandler;

    public ScriptTaskActivityBehavior(String script, String language, String resultVariable) {
        this.invocationHandler = this.createInvocationHandler(script, language, resultVariable);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        boolean noErrors = true;
        try {
            this.invocationHandler.evaluate(execution);
        }
        catch (ProcessEngineException e) {
            noErrors = false;
            if (e.getCause() instanceof ScriptException && e.getCause().getCause() instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)e.getCause().getCause(), execution);
            }
            if (e.getCause() instanceof ScriptException && e.getCause().getCause() instanceof ScriptException && e.getCause().getCause().getCause() instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)e.getCause().getCause().getCause(), execution);
            }
            ErrorPropagation.propagateException(e, execution);
        }
        if (noErrors) {
            this.leave(execution);
        }
    }

    protected ScriptInvocationHandler createInvocationHandler(String script, String language, String resultVariable) {
        return new ScriptInvocationHandler(script, language, resultVariable);
    }
}

