/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.ProcessEngineServicesAware;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.PlanItemState;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.core.variable.SimpleVariableStrore;

public class PlanItemImpl
extends CmmnExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(PlanItemImpl.class.getName());
    private static AtomicInteger idGenerator = new AtomicInteger();
    protected List<PlanItemImpl> planItems;
    protected PlanItemImpl caseInstance;
    protected PlanItemImpl parent;
    protected SimpleVariableStrore variableStrore = new SimpleVariableStrore();

    @Override
    public String getCaseDefinitionId() {
        return this.getCaseDefinition().getId();
    }

    @Override
    public PlanItemImpl getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (PlanItemImpl)parent;
    }

    @Override
    public String getParentId() {
        return this.getParent().getId();
    }

    @Override
    public String getActivityId() {
        return this.getActivity().getId();
    }

    @Override
    public String getActivityName() {
        return this.getActivity().getName();
    }

    public List<PlanItemImpl> getPlanItems() {
        if (this.planItems == null) {
            this.planItems = new ArrayList<PlanItemImpl>();
        }
        return this.planItems;
    }

    @Override
    public PlanItemImpl getCaseInstance() {
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (PlanItemImpl)caseInstance;
    }

    @Override
    protected String generateActivityInstanceId(String activityId) {
        int nextId = idGenerator.incrementAndGet();
        String compositeId = activityId + ":" + nextId;
        if (compositeId.length() > 64) {
            return String.valueOf(nextId);
        }
        return compositeId;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        throw new UnsupportedOperationException(ProcessEngineServicesAware.class.getName() + " is unsupported in transient PlanItemImpl");
    }

    @Override
    protected PlanItemImpl createPlanItem(CmmnActivity activity) {
        PlanItemImpl child = this.newPlanItem();
        child.setActivity(activity);
        child.setParent(this);
        this.getPlanItems().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        child.setState(PlanItemState.AVAILABLE);
        this.activityInstanceId = child.generateActivityInstanceId(activity.getId());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Child planItem " + child + " created with parent " + this);
        }
        return child;
    }

    @Override
    protected PlanItemImpl newPlanItem() {
        return new PlanItemImpl();
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStrore;
    }

    @Override
    public String toString() {
        if (this.isCaseInstance()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }
}

