/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;

public class DeploymentManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbSqlSession().insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceManager().insertResource(resource);
        }
        Context.getProcessEngineConfiguration().getDeploymentCache().deploy(deployment);
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        String processDefinitionId;
        List processDefinitions = this.getDbSqlSession().createProcessDefinitionQuery().deploymentId(deploymentId).list();
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", cascade);
            }
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getIdentityLinkManager().deleteIdentityLinksByProcDef(processDefinitionId);
            List<Job> timerStartJobs = Context.getCommandContext().getJobManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey());
            ProcessDefinitionEntity latestVersion = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
            if (latestVersion != null && latestVersion.getId().equals(processDefinition.getId())) {
                for (Job job : timerStartJobs) {
                    ((JobEntity)job).delete();
                }
            }
            if (!cascade) continue;
            Context.getCommandContext().getHistoricIncidentManager().deleteHistoricIncidentsByProcessDefinitionId(processDefinitionId);
        }
        this.getProcessDefinitionManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            Context.getProcessEngineConfiguration().getDeploymentCache().removeProcessDefinition(processDefinitionId);
            List<EventSubscriptionEntity> findEventSubscriptionsByConfiguration = Context.getCommandContext().getEventSubscriptionManager().findEventSubscriptionsByConfiguration("message", processDefinition.getId());
            for (EventSubscriptionEntity eventSubscriptionEntity : findEventSubscriptionsByConfiguration) {
                eventSubscriptionEntity.delete();
            }
            Context.getCommandContext().getJobDefinitionManager().deleteJobDefinitionsByProcessDefinitionId(processDefinition.getId());
        }
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.getDbSqlSession().delete("deleteDeployment", deploymentId);
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbSqlSession().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return this.getDbSqlSession().selectById(DeploymentEntity.class, deploymentId);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        String query = "selectDeploymentsByQueryCriteria";
        return this.getDbSqlSession().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbSqlSession().selectList("selectResourceNamesByDeploymentId", deploymentId);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

