/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Incident;

public class IncidentEntity
implements Incident,
PersistentObject,
HasRevision {
    protected int revision;
    protected String id;
    protected Date incidentTimestamp;
    protected String incidentType;
    protected String executionId;
    protected String activityId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected String incidentMessage;

    public List<IncidentEntity> createRecursiveIncidents() {
        ArrayList<IncidentEntity> createdIncidents = new ArrayList<IncidentEntity>();
        this.createRecursiveIncidents(this.id, createdIncidents);
        return createdIncidents;
    }

    protected void createRecursiveIncidents(String rootCauseIncidentId, List<IncidentEntity> createdIncidents) {
        String superExecutionId;
        ExecutionEntity execution = this.getExecution();
        if (execution != null && (superExecutionId = execution.getProcessInstance().getSuperExecutionId()) != null && !superExecutionId.isEmpty()) {
            IncidentEntity newIncident = IncidentEntity.create(this.incidentType, superExecutionId, null, null);
            newIncident.setCauseIncidentId(this.id);
            newIncident.setRootCauseIncidentId(rootCauseIncidentId);
            IncidentEntity.insert(newIncident);
            createdIncidents.add(newIncident);
            newIncident.createRecursiveIncidents(rootCauseIncidentId, createdIncidents);
        }
    }

    public static IncidentEntity createAndInsertIncident(String incidentType, String configuration, String message) {
        return IncidentEntity.createAndInsertIncident(incidentType, null, configuration, message);
    }

    public static IncidentEntity createAndInsertIncident(String incidentType, String executionId, String configuration, String message) {
        IncidentEntity newIncident = IncidentEntity.create(incidentType, executionId, configuration, message);
        IncidentEntity.insert(newIncident);
        return newIncident;
    }

    public static IncidentEntity createAndInsertIncident(String incidentType, String processDefinitionId, String activityId, String configuration, String message) {
        IncidentEntity newIncident = IncidentEntity.create(incidentType, null, configuration, message);
        newIncident.setActivityId(activityId);
        newIncident.setProcessDefinitionId(processDefinitionId);
        IncidentEntity.insert(newIncident);
        return newIncident;
    }

    protected static IncidentEntity create(String incidentType, String executionId, String configuration, String message) {
        String incidentId = Context.getProcessEngineConfiguration().getDbSqlSessionFactory().getIdGenerator().getNextId();
        IncidentEntity newIncident = new IncidentEntity();
        newIncident.setId(incidentId);
        newIncident.setIncidentTimestamp(ClockUtil.getCurrentTime());
        newIncident.setIncidentMessage(message);
        newIncident.setConfiguration(configuration);
        newIncident.setIncidentType(incidentType);
        newIncident.setCauseIncidentId(incidentId);
        newIncident.setRootCauseIncidentId(incidentId);
        if (executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
            newIncident.setExecution(execution);
        }
        return newIncident;
    }

    protected static void insert(IncidentEntity incident) {
        Context.getCommandContext().getDbSqlSession().insert(incident);
        incident.fireHistoricIncidentEvent("create");
    }

    public void delete() {
        this.remove(false);
    }

    public void resolve() {
        this.remove(true);
    }

    protected void remove(boolean resolved) {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            IncidentEntity parentIncident;
            ExecutionEntity superExecution = null;
            superExecution = execution.getId().equals(execution.getProcessInstanceId()) ? execution.getSuperExecution() : execution.getProcessInstance().getSuperExecution();
            if (superExecution != null && (parentIncident = superExecution.getIncidentByCauseIncidentId(this.getId())) != null) {
                parentIncident.remove(resolved);
            }
            execution.removeIncident(this);
        }
        Context.getCommandContext().getDbSqlSession().delete(this);
        String eventType = resolved ? "resolve" : "delete";
        this.fireHistoricIncidentEvent(eventType);
    }

    protected void fireHistoricIncidentEvent(String eventType) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int historyLevel = processEngineConfiguration.getHistoryLevel();
        if (historyLevel >= 3) {
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEvent event = null;
            if ("create".equals(eventType)) {
                event = eventProducer.createHistoricIncidentCreateEvt(this);
            } else if ("resolve".equals(eventType)) {
                event = eventProducer.createHistoricIncidentResolveEvt(this);
            } else if ("delete".equals(eventType)) {
                event = eventProducer.createHistoricIncidentDeleteEvt(this);
            } else {
                return;
            }
            eventHandler.handleEvent(event);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getIncidentTimestamp() {
        return this.incidentTimestamp;
    }

    public void setIncidentTimestamp(Date incidentTimestamp) {
        this.incidentTimestamp = incidentTimestamp;
    }

    @Override
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @Override
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @Override
    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.activityId = execution.getActivityId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.processDefinitionId = execution.getProcessDefinitionId();
        execution.addIncident(this);
    }

    public ExecutionEntity getExecution() {
        if (this.executionId != null) {
            return Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return null;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("executionId", this.executionId);
        return persistentState;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", incidentTimestamp=" + this.incidentTimestamp + ", incidentType=" + this.incidentType + ", executionId=" + this.executionId + ", activityId=" + this.activityId + ", processInstanceId=" + this.processInstanceId + ", processDefinitionId=" + this.processDefinitionId + ", causeIncidentId=" + this.causeIncidentId + ", rootCauseIncidentId=" + this.rootCauseIncidentId + ", configuration=" + this.configuration + ", incidentMessage=" + this.incidentMessage + "]";
    }
}

